/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.essentialscommands.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import fox.mods.essentialscommands.utils.Warp;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class WarpManager {
    private static final File warpFile = new File("config/warps.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, Warp> warps = new HashMap<String, Warp>();

    public static void loadWarps() {
        if (!warpFile.exists()) {
            WarpManager.saveWarps();
            return;
        }
        try (FileReader reader = new FileReader(warpFile);){
            Map loadedWarps = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Warp>>(){}.getType());
            if (loadedWarps != null) {
                warps.putAll(loadedWarps);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveWarps() {
        try (FileWriter writer = new FileWriter(warpFile);){
            gson.toJson(warps, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean addWarp(String name, Warp warp) {
        if (warps.containsKey(name)) {
            return false;
        }
        warps.put(name, warp);
        WarpManager.saveWarps();
        return true;
    }

    public static Warp getWarp(String name) {
        return warps.get(name);
    }

    public static boolean removeWarp(String name) {
        if (warps.remove(name) != null) {
            WarpManager.saveWarps();
            return true;
        }
        return false;
    }

    public static Map<String, Warp> getAllWarps() {
        return warps;
    }
}

