/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.api.essentialscommands.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class EssentialsCommandsConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<String> DISCORD_LINK;
    public static final ForgeConfigSpec.ConfigValue<Integer> SPAWN_X;
    public static final ForgeConfigSpec.ConfigValue<Integer> SPAWN_Y;
    public static final ForgeConfigSpec.ConfigValue<Integer> SPAWN_Z;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SPAWN_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<Double> SPAWN_TELEPORT_TIME;
    public static final ForgeConfigSpec.ConfigValue<Double> HOME_TELEPORT_TIME;
    public static final ForgeConfigSpec.ConfigValue<Double> WARP_TELEPORT_TIME;
    public static final ForgeConfigSpec.ConfigValue<Double> SPAWN_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Double> WARP_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Double> HOME_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_HOMES_NUMBER;
    public static final ForgeConfigSpec.ConfigValue<String> MUTE_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<String> UNMUTE_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<String> COOLDOWN_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<String> SPAWN_DISABLED_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<String> TOO_MANY_HOMES_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<String> HOME_NOT_FOUND_MESSAGE;

    static {
        BUILDER.push("Settings");
        DISCORD_LINK = BUILDER.comment("This is the Discord link that will be prompted in chat by using the /discord command.").define("discordLink", (Object)"Set the Discord link in the config file!");
        SPAWN_X = BUILDER.comment("This is the X coordinate of the Spawn block. Players will be teleported here after using /spawn.").define("spawnX", (Object)0);
        SPAWN_Y = BUILDER.comment("This is the Y coordinate of the Spawn block. Players will be teleported here after using /spawn.").define("spawnY", (Object)80);
        SPAWN_Z = BUILDER.comment("This is the Z coordinate of the Spawn block. Players will be teleported here after using /spawn.").define("spawnZ", (Object)0);
        SPAWN_ENABLED = BUILDER.comment("Defines if /spawn is available or not.").define("spawnEnabled", false);
        SPAWN_TELEPORT_TIME = BUILDER.comment("Time it takes to teleport after doing /spawn in seconds.").define("spawnTpTime", (Object)5.0);
        HOME_TELEPORT_TIME = BUILDER.comment("Time it takes to teleport after doing /home in seconds.").define("homeTpTime", (Object)5.0);
        WARP_TELEPORT_TIME = BUILDER.comment("Time it takes to teleport after doing /warp in seconds.").define("warpTpTime", (Object)5.0);
        SPAWN_COOLDOWN = BUILDER.comment("This is the cooldown for /spawn.").define("spawnCooldown", (Object)30.0);
        WARP_COOLDOWN = BUILDER.comment("This is the cooldown for /warp").define("warpCooldown", (Object)30.0);
        HOME_COOLDOWN = BUILDER.comment("This is the cooldown for /home.").define("homeCooldown", (Object)30.0);
        MAX_HOMES_NUMBER = BUILDER.comment("Maximum number of homes a player can have at a time.").define("maxHomes", (Object)3);
        BUILDER.pop();
        BUILDER.push("Messages");
        MUTE_MESSAGE = BUILDER.comment("This is the message sent to a player when they get muted. Use %duration% to include the duration in seconds of the mute.").define("muteMessage", (Object)"You have been muted for %duration%!");
        UNMUTE_MESSAGE = BUILDER.comment("This is the message sent to a player when they get unmuted.").define("unmuteMessage", (Object)"You are no longer muted!");
        COOLDOWN_MESSAGE = BUILDER.comment("This is the message sent to a player when they try to use a command while it's in cooldown.").define("unmuteMessage", (Object)"You are still in cooldown!");
        SPAWN_DISABLED_MESSAGE = BUILDER.comment("This is the message sent to a player when they try to use /spawn while spawn is disabled.").define("spawnDisabledMessage", (Object)"Spawn is disabled!");
        TOO_MANY_HOMES_MESSAGE = BUILDER.comment("This is the message sent to a player when they try to use /sethome while already owning maximum homes.").define("tooManyHomesMessage", (Object)"You have reached the limit on Homes.");
        HOME_NOT_FOUND_MESSAGE = BUILDER.comment("This is the message sent to a player when they try to use /home or /delhome with the incorrect home name").define("homeNotFound", (Object)"You don't have a home with that name.");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

