/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Supplier;

class ContainerContext {
    final Slot slot;
    final InventoryHandler.InventoryMapping slotMapping;
    final ServerPlayer player;
    final ImmutableBiMap<Container, InventoryHandler.InventoryMapping> mapping;
    private InventoryHandler.InventoryMapping slotTarget;
    static final Container PLAYER_HOTBAR = new SimpleContainer(0);
    static final Container PLAYER_MAIN = new SimpleContainer(0);
    static final Container PLAYER_OFFHAND = new SimpleContainer(0);

    static boolean validSlot(Slot slot) {
        return slot != null && slot.f_40218_ != null && (slot instanceof SlotItemHandler || slot.f_40218_.m_6643_() > 0) && !InventorySorter.INSTANCE.isSlotBlacklisted(slot);
    }

    public ContainerContext(Slot slot, ServerPlayer playerEntity) {
        this.slot = slot;
        this.player = playerEntity;
        HashMap<Container, InventoryHandler.InventoryMapping> mapping = new HashMap<Container, InventoryHandler.InventoryMapping>();
        AbstractContainerMenu openContainer = playerEntity.f_36096_;
        openContainer.f_38839_.stream().filter(ContainerContext::validSlot).forEach(sl -> {
            InventoryHandler.InventoryMapping inventoryMapping = mapping.computeIfAbsent(sl.f_40218_, k -> new InventoryHandler.InventoryMapping(sl.f_40218_, openContainer, sl.f_40218_, (Slot)sl));
            inventoryMapping.addSlot((Slot)sl);
            if (sl == slot) {
                this.slotTarget = inventoryMapping;
            }
        });
        if (mapping.containsKey(playerEntity.m_150109_())) {
            InventoryHandler.InventoryMapping playerMapping = (InventoryHandler.InventoryMapping)mapping.remove(playerEntity.m_150109_());
            if (this.slotTarget == playerMapping) {
                this.slotTarget = null;
            }
            int mainStart = 9;
            int mainEnd = 36;
            int offhandStart = 40;
            InventoryHandler.InventoryMapping hotbarMapping = new InventoryHandler.InventoryMapping(PLAYER_HOTBAR, openContainer, (Container)playerEntity.m_150109_(), openContainer.m_38853_(0));
            InventoryHandler.InventoryMapping mainMapping = new InventoryHandler.InventoryMapping(PLAYER_MAIN, openContainer, (Container)playerEntity.m_150109_(), openContainer.m_38853_(mainStart));
            InventoryHandler.InventoryMapping offhandMapping = new InventoryHandler.InventoryMapping(PLAYER_OFFHAND, openContainer, (Container)playerEntity.m_150109_(), openContainer.m_38853_(offhandStart));
            for (int i = playerMapping.begin; i <= playerMapping.end; ++i) {
                InventoryHandler.InventoryMapping inventoryMapping;
                Slot s = openContainer.m_38853_(i);
                if (s.getSlotIndex() < mainStart && s.f_40218_ == playerEntity.m_150109_()) {
                    hotbarMapping.begin = Math.min(s.f_40219_, hotbarMapping.begin);
                    hotbarMapping.end = Math.max(s.f_40219_, hotbarMapping.end);
                    mapping.put(PLAYER_HOTBAR, hotbarMapping);
                    inventoryMapping = hotbarMapping;
                } else if (s.getSlotIndex() < mainEnd && s.f_40218_ == playerEntity.m_150109_()) {
                    mainMapping.begin = Math.min(s.f_40219_, mainMapping.begin);
                    mainMapping.end = Math.max(s.f_40219_, mainMapping.end);
                    mapping.put(PLAYER_MAIN, mainMapping);
                    inventoryMapping = mainMapping;
                } else if (s.getSlotIndex() >= offhandStart && s.f_40218_ == playerEntity.m_150109_()) {
                    offhandMapping.begin = Math.min(s.f_40219_, offhandMapping.begin);
                    offhandMapping.end = Math.max(s.f_40219_, offhandMapping.end);
                    mapping.put(PLAYER_OFFHAND, offhandMapping);
                    inventoryMapping = offhandMapping;
                } else {
                    inventoryMapping = null;
                }
                if (s != slot) continue;
                this.slotTarget = inventoryMapping;
            }
        }
        for (Map.Entry map : Sets.newLinkedHashSet(mapping.entrySet())) {
            if (!((InventoryHandler.InventoryMapping)map.getValue()).markForRemoval) continue;
            mapping.remove(map.getKey());
            if (this.slotTarget != map.getValue()) continue;
            this.slotTarget = null;
        }
        this.slotMapping = this.slotTarget;
        this.mapping = ImmutableBiMap.copyOf(mapping);
        InventorySorter.LOGGER.log(Level.DEBUG, "Slot mapping {}", new Supplier[]{() -> this.mapping});
        InventorySorter.LOGGER.log(Level.DEBUG, "Action slot {}", new Supplier[]{() -> this.slotMapping});
    }
}

