/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.ItemStackHolder;
import cpw.mods.inventorysorter.QuarkSortingHandler;
import java.util.Comparator;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;

public enum InventoryHandler {
    INSTANCE;


    public Multiset<ItemStackHolder> getInventoryContent(ContainerContext context) {
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        HashMultiset itemcounts = HashMultiset.create();
        for (int i = slotLow; i < slotHigh; ++i) {
            ItemStack stack;
            Slot slot = context.player.f_36096_.m_38853_(i);
            if (!slot.m_8010_((Player)context.player) || (stack = slot.m_7993_()).m_41619_()) continue;
            ItemStackHolder holder = new ItemStackHolder(stack.m_41777_());
            itemcounts.add((Object)holder, stack.m_41613_());
        }
        TreeMultiset entries = TreeMultiset.create((Comparator)new ItemStackComparator());
        for (Multiset.Entry entry : itemcounts.entrySet()) {
            entries.add((Object)((ItemStackHolder)entry.getElement()), entry.getCount());
        }
        return entries;
    }

    public static class InventoryMapping {
        int begin = Integer.MAX_VALUE;
        int end = 0;
        final Container inv;
        final Container proxy;
        final AbstractContainerMenu container;
        final Slot slot;
        boolean markForRemoval;
        boolean markAsHeterogeneous;

        InventoryMapping(Container inv, AbstractContainerMenu container, Container proxy, Slot slot) {
            this.inv = inv;
            this.container = container;
            this.proxy = proxy;
            this.slot = slot;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("i", (Object)this.inv).add("c", (Object)this.container).add("b", this.begin).add("e", this.end).toString();
        }

        void addSlot(Slot sl) {
            if (!(this.slot.getClass() == sl.getClass() || this.inv instanceof Inventory || this.inv instanceof FurnaceBlockEntity || this.inv instanceof BrewingStandBlockEntity)) {
                this.markForRemoval = true;
            }
            if (this.slot.getClass() != sl.getClass()) {
                this.markAsHeterogeneous = true;
            }
            this.begin = Math.min(sl.f_40219_, this.begin);
            this.end = Math.max(sl.f_40219_, this.end);
        }
    }

    public static class ItemStackComparator
    implements Comparator<ItemStackHolder> {
        @Override
        public int compare(ItemStackHolder holder1, ItemStackHolder holder2) {
            ItemStack stack1 = holder1.itemStack;
            ItemStack stack2 = holder2.itemStack;
            if (stack1.m_41619_()) {
                return -1;
            }
            if (stack2.m_41619_()) {
                return 1;
            }
            if (holder1 == holder2) {
                return 0;
            }
            int compareResult = 0;
            block0 : switch ((Config.ClientConfig.SortOrder)((Object)Config.ClientConfig.CONFIG.sortOrder.get())) {
                case QUARK: {
                    compareResult = QuarkSortingHandler.stackCompare(stack1, stack2);
                    break;
                }
                case CREATIVE: {
                    Item item1 = stack1.m_41720_();
                    Item item2 = stack2.m_41720_();
                    for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
                        boolean isItem1Found = tab.m_257694_(item1.m_7968_());
                        boolean isItem2Found = tab.m_257694_(item2.m_7968_());
                        if (!isItem1Found && !isItem2Found) continue;
                        if (!isItem2Found) {
                            return -1;
                        }
                        if (!isItem1Found) {
                            return 1;
                        }
                        for (ItemStack stack : tab.m_260957_()) {
                            if (stack.m_41720_() == item1) {
                                compareResult = -1;
                                break block0;
                            }
                            if (stack.m_41720_() != item2) continue;
                            compareResult = 1;
                            break block0;
                        }
                        break block0;
                    }
                    break;
                }
                case ITEM_ID: {
                    compareResult = Ints.compare((int)Item.m_41393_((Item)stack1.m_41720_()), (int)Item.m_41393_((Item)stack2.m_41720_()));
                    break;
                }
                case ITEM_NAME: {
                    compareResult = stack1.m_41720_().m_7626_(stack1).getString().compareTo(stack2.m_41720_().m_7626_(stack2).getString());
                    break;
                }
                case DISPLAY_NAME: {
                    compareResult = stack1.m_41786_().getString().compareTo(stack2.m_41786_().getString());
                    break;
                }
                default: {
                    return 0;
                }
            }
            return compareResult != 0 ? compareResult : QuarkSortingHandler.FALLBACK_COMPARATOR.compare(stack1, stack2);
        }
    }
}

