/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.InventorySorterCommand;
import cpw.mods.inventorysorter.KeyHandler;
import cpw.mods.inventorysorter.Network;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventorysorter")
public class InventorySorter {
    public static InventorySorter INSTANCE;
    static final Logger LOGGER;
    ResourceLocation lastContainerType;
    boolean debugLog;
    private final Set<String> slotblacklist = new HashSet<String>();
    private final Set<String> containerblacklist = new HashSet<String>();
    private final Set<String> imcSlotBlacklist = new HashSet<String>();
    private final Set<String> imcContainerBlacklist = new HashSet<String>();
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;
    private static final RegistryObject<SingletonArgumentInfo<InventorySorterCommand.ContainerResourceLocationArgument>> CONTAINER_CLASS;

    public InventorySorter() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::preinit);
        bus.addListener(this::handleimc);
        bus.addListener(this::onConfigLoad);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.ServerConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.ClientConfig.SPEC);
        COMMAND_ARGUMENT_TYPES.register(bus);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> KeyHandler::init);
    }

    private void handleimc(InterModProcessEvent evt) {
        Stream imc = InterModComms.getMessages((String)"inventorysorter");
        imc.forEach(this::handleIMCMessage);
    }

    private void handleIMCMessage(InterModComms.IMCMessage msg) {
        String blackListTarget;
        Object message;
        if ("slotblacklist".equals(msg.method())) {
            message = msg.messageSupplier().get();
            if (message instanceof String && this.imcSlotBlacklist.add(blackListTarget = (String)message)) {
                this.debugLog("SlotBlacklist added {}", () -> new String[]{blackListTarget});
            } else {
                LOGGER.warn("Rejected slotblacklist due to bad messageSupplier type. Please supply a [String]");
            }
        }
        if ("containerblacklist".equals(msg.method())) {
            message = msg.messageSupplier().get();
            if (message instanceof String && this.imcContainerBlacklist.add(blackListTarget = (String)message)) {
                this.debugLog("ContainerBlacklist added {}", () -> new String[]{blackListTarget});
            } else {
                LOGGER.warn("Rejected containerblacklist due to bad messageSupplier type. Please supply a [ResourceLocation]");
            }
        }
        this.updateBlacklists();
    }

    private void preinit(FMLCommonSetupEvent evt) {
        Network.init();
    }

    private void onServerStarting(ServerStartingEvent evt) {
        InventorySorterCommand.register((CommandDispatcher<CommandSourceStack>)evt.getServer().m_129892_().m_82094_());
    }

    private void updateBlacklists() {
        this.slotblacklist.clear();
        this.containerblacklist.clear();
        this.slotblacklist.addAll((Collection)Config.ServerConfig.CONFIG.slotBlacklist.get());
        this.containerblacklist.addAll((Collection)Config.ServerConfig.CONFIG.containerBlacklist.get());
        this.slotblacklist.addAll(this.imcSlotBlacklist);
        this.containerblacklist.addAll(this.imcContainerBlacklist);
    }

    private void updateConfig() {
        Config.ServerConfig.CONFIG.containerBlacklist.set(this.containerblacklist.stream().filter(e -> !this.imcContainerBlacklist.contains(e)).collect(Collectors.toList()));
        Config.ServerConfig.CONFIG.slotBlacklist.set(this.slotblacklist.stream().filter(e -> !this.imcSlotBlacklist.contains(e)).collect(Collectors.toList()));
        this.updateBlacklists();
    }

    boolean isSlotBlacklisted(Slot slot) {
        return this.slotblacklist.contains(slot.getClass().getName()) || ((List)Config.ServerConfig.CONFIG.slotBlacklist.get()).contains(slot.getClass().getName());
    }

    boolean isContainerBlacklisted(ResourceLocation container) {
        return this.containerblacklist.contains(container.toString()) || ((List)Config.ServerConfig.CONFIG.containerBlacklist.get()).contains(container.toString());
    }

    void onConfigLoad(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getConfigData() == null) {
            return;
        }
        if (configEvent.getConfig().getSpec() == Config.ServerConfig.SPEC) {
            this.updateConfig();
        }
    }

    final void debugLog(String message, Supplier<String[]> args) {
        if (this.debugLog) {
            LOGGER.error(message, (Object[])args.get());
        }
    }

    static int blackListAdd(CommandContext<CommandSourceStack> context) {
        ResourceLocation containerType = (ResourceLocation)context.getArgument("container", ResourceLocation.class);
        if (ForgeRegistries.MENU_TYPES.containsKey(containerType)) {
            InventorySorter.INSTANCE.containerblacklist.add(containerType.toString());
            INSTANCE.updateConfig();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"inventorysorter.commands.inventorysorter.bladd.message", (Object[])new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"inventorysorter.commands.inventorysorter.badtype", (Object[])new Object[]{containerType}), true);
        return 0;
    }

    static int blackListRemove(CommandContext<CommandSourceStack> context) {
        ResourceLocation containerType = (ResourceLocation)context.getArgument("container", ResourceLocation.class);
        if (ForgeRegistries.MENU_TYPES.containsKey(containerType) && InventorySorter.INSTANCE.containerblacklist.remove(containerType.toString())) {
            INSTANCE.updateConfig();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"inventorysorter.commands.inventorysorter.blremove.message", (Object[])new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"inventorysorter.commands.inventorysorter.badtype", (Object[])new Object[]{containerType}), true);
        return 0;
    }

    static int showLast(CommandContext<CommandSourceStack> context) {
        if (InventorySorter.INSTANCE.lastContainerType != null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"inventorysorter.commands.inventorysorter.showlast.message", (Object[])new Object[]{InventorySorter.INSTANCE.lastContainerType}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"inventorysorter.commands.inventorysorter.showlast.nosort"), true);
        }
        return 0;
    }

    static int showBlacklist(CommandContext<CommandSourceStack> context) {
        if (InventorySorter.INSTANCE.containerblacklist.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"inventorysorter.commands.inventorysorter.showblacklist.empty"), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"inventorysorter.commands.inventorysorter.showblacklist.message", (Object[])new Object[]{InventorySorter.listBlacklist().collect(Collectors.toList())}), true);
        }
        return 0;
    }

    static Stream<ResourceLocation> listContainers() {
        return ForgeRegistries.MENU_TYPES.getEntries().stream().map(e -> ((ResourceKey)e.getKey()).m_135782_());
    }

    static Stream<ResourceLocation> listBlacklist() {
        return InventorySorter.INSTANCE.containerblacklist.stream().map(ResourceLocation::new);
    }

    static {
        LOGGER = LogManager.getLogger();
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)"inventorysorter");
        CONTAINER_CLASS = COMMAND_ARGUMENT_TYPES.register("container_reslocation", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(InventorySorterCommand.ContainerResourceLocationArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(InventorySorterCommand.ContainerResourceLocationArgument::new)));
    }
}

