/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.EffectDataAccessor;
import fzzyhmstrs.emi_loot.mixins.EntityEffectPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class EntityEffectPredicateParser {
    public static class_2561 parseEntityEffectPredicate(class_2102 predicate) {
        Map<class_1291, class_2102.class_2103> effects = ((EntityEffectPredicateAccessor)predicate).getEffects();
        LinkedList<class_5250> list = new LinkedList<class_5250>();
        for (Map.Entry<class_1291, class_2102.class_2103> entry : effects.entrySet()) {
            Boolean visible;
            Boolean ambient;
            class_2096.class_2100 duration;
            class_2561 name = entry.getKey().method_5560();
            class_2102.class_2103 data = entry.getValue();
            class_2096.class_2100 amplifier = ((EffectDataAccessor)data).getAmplifier();
            if (!amplifier.equals(class_2096.class_2100.field_9708)) {
                Integer max;
                Integer min = (Integer)amplifier.method_9038();
                if (Objects.equals(min, max = (Integer)amplifier.method_9042()) && min != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier", name.getString(), min + 1));
                } else if (min != null && max != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier_2", name.getString(), min + 1, max + 1));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier_3", name.getString()));
                }
            }
            if (!(duration = ((EffectDataAccessor)data).getDuration()).equals(class_2096.class_2100.field_9708)) {
                Integer max;
                Integer min = (Integer)duration.method_9038();
                if (Objects.equals(min, max = (Integer)duration.method_9042()) && min != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration", name.getString(), min + 1));
                } else if (min != null && max != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration_2", name.getString(), min + 1, max + 1));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration_3", name.getString()));
                }
            }
            if ((ambient = ((EffectDataAccessor)data).getAmbient()) != null) {
                if (ambient.booleanValue()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.ambient_true", name.getString()));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.ambient_false", name.getString()));
                }
            }
            if ((visible = ((EffectDataAccessor)data).getVisible()) != null) {
                if (visible.booleanValue()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.visible_true", name.getString()));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.visible_false", name.getString()));
                }
            }
            list.add(LText.translatable("emi_loot.entity_predicate.effect.fallback", name.getString()));
        }
        if (!list.isEmpty()) {
            return LText.translatable("emi_loot.entity_predicate.effect_1", ListProcessors.buildAndList(list));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Unparsable entity effect predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

