/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.DrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.network.node.DrawerBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.DrawerNetworkBlockNode;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.storage.DrawerSlot;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class DrawerBlock
extends StorageDrawerBlock<DrawerBlockEntity> {
    public final int slots;

    public DrawerBlock(class_4970.class_2251 settings, int slots) {
        super(settings);
        this.slots = slots;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 blockView, List<class_2561> tooltip, class_1836 context) {
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        if (nbt == null) {
            return;
        }
        List<DrawerSlot> list = nbt.method_10554("items", 10).stream().map(class_2487.class::cast).map(data -> {
            DrawerSlot slot = new DrawerSlot(null, 1.0);
            slot.readNbt((class_2487)data);
            return slot;
        }).filter(slot -> !slot.isBlank() || slot.getUpgrade() != null || slot.isHidden() || slot.isLocked() || slot.isVoiding()).toList();
        if (list.isEmpty()) {
            return;
        }
        boolean shift = ExtendedDrawers.SHIFT_ACCESS.isShiftPressed();
        if (!shift) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extended_drawers.shift_for_modifiers").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43473());
        }
        if (!list.stream().allMatch(DrawerSlot::isBlank) || shift) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extended_drawers.drawer_contents").method_27692(class_124.field_1080));
        }
        for (DrawerSlot slot2 : list) {
            class_5250 text;
            if (!slot2.isBlank()) {
                text = class_2561.method_43470((String)" - ");
                text.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(slot2.getTrueAmount()))).method_27693(" ").method_10852(slot2.getResource().toStack().method_7964());
            } else {
                if (!shift) continue;
                text = class_2561.method_43470((String)" - ");
                text.method_10852((class_2561)class_2561.method_43471((String)"tooltip.extended_drawers.empty").method_27692(class_124.field_1056));
            }
            if (shift) {
                text.method_27693("  ").method_10852((class_2561)class_2561.method_43470((String)"V").method_27692(slot2.isVoiding() ? class_124.field_1068 : class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"L").method_27692(slot2.isLocked() ? class_124.field_1068 : class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"H").method_27692(slot2.isHidden() ? class_124.field_1068 : class_124.field_1063));
                if (slot2.isDuping()) {
                    text.method_10852((class_2561)class_2561.method_43470((String)"D").method_27692(class_124.field_1068));
                }
                if (slot2.getUpgrade() != null) {
                    text.method_27693(" ").method_10852((class_2561)slot2.getUpgrade().method_7848().method_27661().method_27692(class_124.field_1075));
                }
            }
            tooltip.add((class_2561)text.method_27692(class_124.field_1080));
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        DrawerBlockEntity drawer;
        if (!state.method_27852(newState.method_26204()) && (drawer = (DrawerBlockEntity)((Object)this.getBlockEntity(world, pos))) != null && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().drawersDropContentsOnBreak()) {
            for (DrawerSlot slot : drawer.storages) {
                ItemUtils.offerOrDropStacks(world, pos, null, null, slot.getResource(), slot.getAmount());
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    protected class_2591<DrawerBlockEntity> getType() {
        return ModBlocks.DRAWER_BLOCK_ENTITY;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        DrawerBlockEntity drawer = (DrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return 0;
        }
        return StorageUtil.calculateComparatorOutput((Storage)drawer.combinedStorage);
    }

    @Override
    protected ModifierAccess getModifierAccess(DrawerBlockEntity drawer, class_241 facePos) {
        return this.getSlot(drawer, this.getSlotIndex(drawer, facePos));
    }

    @Override
    public int getSlotIndex(DrawerBlockEntity drawer, class_241 facePos) {
        return switch (this.slots) {
            case 1 -> 0;
            case 2 -> {
                if (facePos.field_1343 < 0.5f) {
                    yield 0;
                }
                yield 1;
            }
            case 4 -> {
                if (facePos.field_1342 < 0.5f) {
                    if (facePos.field_1343 < 0.5f) {
                        yield 0;
                    }
                    yield 1;
                }
                if (facePos.field_1343 < 0.5f) {
                    yield 2;
                }
                yield 3;
            }
            default -> throw new IllegalStateException("unexpected drawer slot count");
        };
    }

    public DrawerSlot getSlot(DrawerBlockEntity drawer, int slot) {
        return drawer.storages[slot];
    }

    @Override
    public DrawerNetworkBlockNode getNode() {
        return DrawerBlockNode.INSTANCE;
    }
}

