/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.misc;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.util.NodePos;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.mattidragon.extendeddrawers.network.NetworkRegistry;
import io.github.mattidragon.extendeddrawers.network.cache.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.network.node.CompactingDrawerBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.DrawerBlockNode;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class DrawerCacheCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"drawercache").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"print").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"pos");
            NetworkRegistry.UNIVERSE.getServerGraphWorld(source.method_9225()).getAllGraphsAt(pos).map(graph -> (NetworkStorageCache)graph.getGraphEntity(NetworkRegistry.STORAGE_CACHE_TYPE)).map(NetworkStorageCache::getDebugInfo).flatMap(Collection::stream).forEach(line -> source.method_9226(() -> line, false));
            return 1;
        }))).then(class_2170.method_9247((String)"check").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"pos");
            List graphs = NetworkRegistry.UNIVERSE.getServerGraphWorld(source.method_9225()).getAllGraphsAt(pos).toList();
            if (graphs.isEmpty()) {
                source.method_9226(() -> class_2561.method_43470((String)"No graph found").method_27692(class_124.field_1061), false);
                return 0;
            }
            if (graphs.size() > 1) {
                source.method_9226(() -> class_2561.method_43470((String)"Multiple graphs found").method_27692(class_124.field_1061), false);
                return 0;
            }
            BlockGraph graph = (BlockGraph)graphs.get(0);
            NetworkStorageCache cache = (NetworkStorageCache)graph.getGraphEntity(NetworkRegistry.STORAGE_CACHE_TYPE);
            graph.getNodes().filter(node -> node.getNode() instanceof DrawerBlockNode || node.getNode() instanceof CompactingDrawerBlockNode).map(NodeHolder::getPos).map(NodePos::pos).forEach(nodePos -> source.method_9226(() -> class_2561.method_43470((String)("Node at " + nodePos.method_23854() + ": ")).method_27692(class_124.field_1054).method_10852(cache.getDebugInfo((class_2338)nodePos)), false));
            source.method_9226(() -> class_2561.method_43470((String)"Checked cache").method_27692(class_124.field_1060), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"update").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"pos");
            List<NetworkStorageCache> caches = NetworkRegistry.UNIVERSE.getServerGraphWorld(source.method_9225()).getAllGraphsAt(pos).map(graph -> (NetworkStorageCache)graph.getGraphEntity(NetworkRegistry.STORAGE_CACHE_TYPE)).toList();
            caches.forEach(NetworkStorageCache::update);
            source.method_9226(() -> class_2561.method_43470((String)"Updated cache").method_27692(class_124.field_1060), false);
            return 1;
        })).then(class_2170.method_9247((String)"force").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"pos");
            List<NetworkStorageCache> caches = NetworkRegistry.UNIVERSE.getServerGraphWorld(source.method_9225()).getAllGraphsAt(pos).map(graph -> (NetworkStorageCache)graph.getGraphEntity(NetworkRegistry.STORAGE_CACHE_TYPE)).toList();
            caches.forEach(NetworkStorageCache::forceUpdate);
            source.method_9226(() -> class_2561.method_43470((String)"Force updated cache").method_27692(class_124.field_1060), false);
            return 1;
        }))))));
    }
}

