/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things;

import com.glisco.things.Things;
import com.glisco.things.blocks.PlacedItemBlockEntity;
import com.glisco.things.blocks.ThingsBlocks;
import com.glisco.things.client.DisplacementTomeScreen;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.items.trinkets.AgglomerationItem;
import com.glisco.things.items.trinkets.SocksItem;
import com.glisco.things.misc.DisplacementTomeScreenHandler;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.ops.ItemOps;
import io.wispforest.owo.ops.WorldOps;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_747;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThingsNetwork {
    public static final Logger LOGGER = LogManager.getLogger((String)"things-network");
    public static final OwoNetChannel CHANNEL = OwoNetChannel.create((class_2960)Things.id("main"));
    private static final class_3908 ENDER_POUCH_FACTORY = new class_747((syncId, inv, player) -> class_1707.method_19245((int)syncId, (class_1661)inv, (class_1263)player.method_7274()), (class_2561)class_2561.method_43471((String)"container.enderpouch"));

    public static void init() {
        CHANNEL.registerServerbound(OpenEnderChestPacket.class, (message, access) -> {
            class_3222 player = access.player();
            if (!Things.hasTrinket((class_1309)player, ThingsItems.ENDER_POUCH)) {
                LOGGER.warn("Received illegal openEChest packet");
                return;
            }
            player.method_17355(ENDER_POUCH_FACTORY);
        });
        CHANNEL.registerServerbound(DisplacementTomeScreenHandler.ActionPacket.class, (message, access) -> {
            class_1703 patt2144$temp = access.player().field_7512;
            if (!(patt2144$temp instanceof DisplacementTomeScreenHandler)) {
                return;
            }
            DisplacementTomeScreenHandler handler = (DisplacementTomeScreenHandler)patt2144$temp;
            DisplacementTomeScreenHandler.ActionPacket.Action action = message.action();
            switch (action) {
                case TELEPORT: {
                    handler.requestTeleport(message.data());
                    break;
                }
                case CREATE_POINT: {
                    handler.addPoint(message.data());
                    break;
                }
                case DELETE_POINT: {
                    if (handler.deletePoint(message.data())) break;
                    LOGGER.warn("Received invalid DELETE_POINT request");
                    break;
                }
                case RENAME_POINT: {
                    if (handler.renamePoint(message.data())) break;
                    LOGGER.warn("Received invalid RENAME_POINT request");
                }
            }
        });
        CHANNEL.registerClientbound(DisplacementTomeScreenHandler.UpdateClientPacket.class, (message, access) -> {
            class_437 patt2993$temp = access.runtime().field_1755;
            if (!(patt2993$temp instanceof DisplacementTomeScreen)) {
                return;
            }
            DisplacementTomeScreen tomeScreen = (DisplacementTomeScreen)patt2993$temp;
            ((DisplacementTomeScreenHandler)tomeScreen.method_17577()).setBook(message.tome());
            tomeScreen.method_41843();
        });
        CHANNEL.registerServerbound(PlaceItemPacket.class, (message, access) -> {
            class_3965 target = message.target();
            class_2338 pos = target.method_17777().method_10093(target.method_17780());
            class_1937 world = access.player().method_37908();
            if (!world.method_8320(pos).method_26215()) {
                return;
            }
            if (!world.method_8477(pos)) {
                LOGGER.warn("Received illegal place item packet");
                return;
            }
            class_1799 stack = access.player().method_5998(class_1268.field_5808);
            if (stack.method_7960()) {
                return;
            }
            if (!world.method_8320(target.method_17777()).method_26206((class_1922)world, target.method_17777(), target.method_17780())) {
                return;
            }
            world.method_8501(pos, (class_2680)ThingsBlocks.PLACED_ITEM.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)target.method_17780().method_10153()));
            ((PlacedItemBlockEntity)world.method_8321(pos)).setItem(ItemOps.singleCopy((class_1799)stack));
            stack.method_7934(1);
        });
        CHANNEL.registerServerbound(ToggleSocksJumpBoostPacket.class, (message, access) -> {
            class_3222 player = access.player();
            if (!Things.hasTrinket((class_1309)player, ThingsItems.SOCKS)) {
                return;
            }
            class_1799 socks = (class_1799)((class_3545)Things.getTrinkets((class_1309)player).getEquipped(ThingsItems.SOCKS).get(0)).method_15441();
            socks.mutate(SocksItem.JUMP_BOOST_TOGGLE_KEY, enabled -> enabled == false);
            WorldOps.playSound((class_1937)player.method_37908(), (class_243)player.method_19538(), (class_3414)class_3417.field_14561, (class_3419)class_3419.field_15248, (float)1.0f, (float)2.0f);
            Things.TOGGLE_JUMP_BOOST_PARTICLES.spawn(player.method_37908(), player.method_19538());
        });
        CHANNEL.registerServerbound(AgglomerationItem.ScrollHandStackTrinket.class, AgglomerationItem.ScrollHandStackTrinket::scrollItemStack);
        CHANNEL.registerServerbound(AgglomerationItem.ScrollStackFromSlotTrinket.class, AgglomerationItem.ScrollStackFromSlotTrinket::scrollItemStack);
    }

    public record OpenEnderChestPacket() {
    }

    public record PlaceItemPacket(class_3965 target) {
    }

    public record ToggleSocksJumpBoostPacket() {
    }
}

