/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.predicate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.util.Serializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class AndConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<AndConnectionPredicate> SERIALIZER = new Serializer<AndConnectionPredicate>(){

        @Override
        public AndConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("predicates") || !json.get("predicates").isJsonArray()) {
                throw new JsonParseException("And-predicate must have array property 'predicates'!");
            }
            ArrayList<ConnectionPredicate> predicates = new ArrayList<ConnectionPredicate>();
            JsonArray array = json.getAsJsonArray("predicates");
            for (JsonElement element : array) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Property 'predicates' must only contain objects!");
                }
                ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(element.getAsJsonObject());
                predicates.add(predicate);
            }
            return new AndConnectionPredicate(predicates);
        }

        @Override
        public JsonObject serialize(AndConnectionPredicate value) {
            JsonObject json = new JsonObject();
            JsonArray predicatesJson = new JsonArray();
            for (ConnectionPredicate predicate : value.predicates) {
                predicatesJson.add((JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicate));
            }
            json.add("predicates", (JsonElement)predicatesJson);
            return json;
        }
    };
    private final List<ConnectionPredicate> predicates;

    public AndConnectionPredicate(List<ConnectionPredicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean shouldConnect(class_2350 side, @Nullable class_2680 ownState, class_2680 otherState, class_2680 blockInFront, ConnectionDirection direction) {
        return this.predicates.stream().allMatch(predicate -> predicate.shouldConnect(side, ownState, otherState, blockInFront, direction));
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }
}

