/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.image;

import com.dfsek.terra.addons.image.image.Image;

public class StitchedImage
implements Image {
    private final Image[][] images;
    private final int[] rowOffsets;
    private final int[] columnOffsets;
    private final int width;
    private final int height;

    public StitchedImage(Image[][] images, boolean zeroIndexed) throws IllegalArgumentException {
        int j;
        int i;
        int width = 0;
        int height = 0;
        int rows = images.length;
        int columns = images[0].length;
        this.rowOffsets = new int[rows];
        this.columnOffsets = new int[columns];
        for (i = 0; i < rows; ++i) {
            int rowHeight = images[i][0].getHeight();
            this.rowOffsets[i] = height;
            height += rowHeight;
            for (j = 1; j < columns; ++j) {
                if (images[i][j].getHeight() == rowHeight) continue;
                throw new IllegalArgumentException("Image heights in row " + (i + (zeroIndexed ? 0 : 1)) + " do not match");
            }
        }
        for (i = 0; i < columns; ++i) {
            int columnWidth = images[0][i].getWidth();
            this.columnOffsets[i] = width;
            width += columnWidth;
            for (j = 1; j < rows; ++j) {
                if (images[i][j].getWidth() == columnWidth) continue;
                throw new IllegalArgumentException("Image widths in column " + (i + (zeroIndexed ? 0 : 1)) + " do not match");
            }
        }
        this.width = width;
        this.height = height;
        this.images = images;
    }

    private int getColumn(int x) {
        for (int i = this.columnOffsets.length - 1; i > 0; --i) {
            if (x < this.columnOffsets[i]) continue;
            return i;
        }
        return 0;
    }

    private int getRow(int y) {
        for (int i = this.rowOffsets.length - 1; i > 0; --i) {
            if (y < this.rowOffsets[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getRGB(int x, int y) {
        int row = this.getRow(y);
        int column = this.getColumn(x);
        return this.images[row][column].getRGB(x - this.columnOffsets[column], y - this.rowOffsets[row]);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

