/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.commands.structure;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.CommandManager;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.standard.EnumArgument;
import cloud.commandframework.arguments.standard.LongArgument;
import cloud.commandframework.context.CommandContext;
import com.dfsek.terra.addons.manifest.api.AddonInitializer;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.command.CommandSender;
import com.dfsek.terra.api.command.arguments.RegistryArgument;
import com.dfsek.terra.api.entity.Entity;
import com.dfsek.terra.api.event.events.platform.CommandRegistrationEvent;
import com.dfsek.terra.api.event.functional.FunctionalEventHandler;
import com.dfsek.terra.api.inject.annotations.Inject;
import com.dfsek.terra.api.registry.Registry;
import com.dfsek.terra.api.structure.Structure;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.reflection.TypeKey;
import com.dfsek.terra.api.world.WritableWorld;
import java.util.Random;

public class StructureCommandAddon
implements AddonInitializer {
    @Inject
    private Platform platform;
    @Inject
    private BaseAddon addon;

    private static Registry<Structure> getStructureRegistry(CommandContext<CommandSender> sender) {
        return ((Entity)((CommandSender)sender.getSender()).getEntity().orElseThrow()).world().getPack().getRegistry(Structure.class);
    }

    public void initialize() {
        ((FunctionalEventHandler)this.platform.getEventManager().getHandler(FunctionalEventHandler.class)).register(this.addon, CommandRegistrationEvent.class).then(event -> {
            CommandManager manager = event.getCommandManager();
            manager.command(manager.commandBuilder("structures", ArgumentDescription.of((String)"Manage or generate structures"), new String[0]).literal("generate", new String[0]).argument((CommandArgument.Builder)RegistryArgument.builder((String)"structure", StructureCommandAddon::getStructureRegistry, (TypeKey)TypeKey.of(Structure.class))).argument(LongArgument.optional((String)"seed", (long)0L)).argument(EnumArgument.optional(Rotation.class, (String)"rotation", (Enum)Rotation.NONE)).handler(context -> {
                Structure structure = (Structure)context.get("structure");
                Entity sender = (Entity)((CommandSender)context.getSender()).getEntity().orElseThrow();
                structure.generate(sender.position().toInt(), (WritableWorld)sender.world(), (Long)context.get("seed") == 0L ? new Random() : new Random((Long)context.get("seed")), (Rotation)context.get("rotation"));
            }).permission("terra.structures.generate"));
        });
    }
}

