/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.config;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import me.melontini.andromeda.config.AndromedaConfig;
import me.melontini.andromeda.util.ConfigHelper;
import me.melontini.dark_matter.api.base.util.PrependingLogger;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class AndromedaFeatureManager {
    private static final PrependingLogger LOGGER = new PrependingLogger(LogManager.getLogger((String)"AndromedaFeatureManager"), PrependingLogger.LOGGER_NAME);
    private static final Map<String, FeatureProcessor> PROCESSORS = new LinkedHashMap<String, FeatureProcessor>(5);
    private static final Map<String, Set<String>> MOD_BLAME = new HashMap<String, Set<String>>();
    private static final Map<Field, String> MODIFIED_FIELDS = new HashMap<Field, String>();
    private static final Map<Field, String> FIELD_TO_STRING = new HashMap<Field, String>();
    private static final Map<String, Object> MOD_JSON = new LinkedHashMap<String, Object>();

    public static void registerProcessor(String id, FeatureProcessor processor) {
        PROCESSORS.putIfAbsent(id, processor);
    }

    public static void unregisterProcessor(String id) {
        PROCESSORS.remove(id);
    }

    public static boolean isModified(Field field) {
        return MODIFIED_FIELDS.containsKey(field);
    }

    public static String blameProcessor(Field field) {
        return MODIFIED_FIELDS.get(field);
    }

    public static String[] blameMod(Field feature) {
        return (String[])MOD_BLAME.get(FIELD_TO_STRING.get(feature)).stream().sorted(String::compareToIgnoreCase).toArray(String[]::new);
    }

    public static void processFeatures(AndromedaConfig config) {
        MODIFIED_FIELDS.clear();
        if (!config.enableFeatureManager) {
            return;
        }
        for (Map.Entry<String, FeatureProcessor> entry : PROCESSORS.entrySet()) {
            Map<String, Object> featureConfigEntry = entry.getValue().process(config);
            if (featureConfigEntry == null || featureConfigEntry.isEmpty()) continue;
            LOGGER.info("Processor: {}", new Object[]{entry.getKey()});
            StringBuilder builder = new StringBuilder().append("Config: ");
            featureConfigEntry.keySet().forEach(s -> builder.append((String)s).append("=").append(featureConfigEntry.get(s)).append("; "));
            LOGGER.info(builder.toString());
            AndromedaFeatureManager.configure(config, entry.getKey(), featureConfigEntry);
        }
    }

    private static void configure(AndromedaConfig config, String processor, Map<String, Object> featureConfig) {
        HashSet<String> skipped = new HashSet<String>();
        for (Map.Entry<String, Object> configEntry : featureConfig.entrySet()) {
            String configOption = configEntry.getKey();
            try {
                Field f = ConfigHelper.setConfigOption(configOption, config, configEntry.getValue());
                MODIFIED_FIELDS.put(f, processor);
                FIELD_TO_STRING.putIfAbsent(f, configOption);
            }
            catch (NoSuchFieldException e) {
                skipped.add(configOption);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (!skipped.isEmpty()) {
            StringBuilder builder = new StringBuilder().append("Skipped: ");
            skipped.forEach(s -> builder.append((String)s).append("; "));
            LOGGER.warn((Object)builder);
        }
    }

    private static void parseMetadata(ModContainer mod) {
        CustomValue customValue = mod.getMetadata().getCustomValue("andromeda:features");
        if (customValue.getType() != CustomValue.CvType.OBJECT) {
            LOGGER.error("andromeda:features must be an object. Mod: " + mod.getMetadata().getId() + " Type: " + customValue.getType());
        } else {
            CustomValue.CvObject object = customValue.getAsObject();
            block4: for (Map.Entry feature : object) {
                switch (((CustomValue)feature.getValue()).getType()) {
                    case BOOLEAN: {
                        MOD_JSON.put((String)feature.getKey(), ((CustomValue)feature.getValue()).getAsBoolean());
                        MOD_BLAME.computeIfAbsent((String)feature.getKey(), k -> new HashSet()).add(mod.getMetadata().getName());
                        break;
                    }
                    case OBJECT: {
                        CustomValue.CvObject featureObject = ((CustomValue)feature.getValue()).getAsObject();
                        if (!featureObject.containsKey("value")) {
                            LOGGER.error("Missing \"value\" field in andromeda:features. Mod: " + mod.getMetadata().getId());
                            continue block4;
                        }
                        if (!AndromedaFeatureManager.testModVersion(featureObject, "minecraft", (String)feature.getKey()) || !AndromedaFeatureManager.testModVersion(featureObject, "andromeda", (String)feature.getKey())) continue block4;
                        if (featureObject.get("value").getType() == CustomValue.CvType.BOOLEAN) {
                            MOD_JSON.put((String)feature.getKey(), featureObject.get("value").getAsBoolean());
                            MOD_BLAME.computeIfAbsent((String)feature.getKey(), k -> new HashSet()).add(mod.getMetadata().getName());
                            break;
                        }
                        LOGGER.error("Unsupported andromeda:features type. Mod: " + mod.getMetadata().getId() + " Type: " + ((CustomValue)feature.getValue()).getType());
                        break;
                    }
                    default: {
                        LOGGER.error("Unsupported andromeda:features type. Mod: " + mod.getMetadata().getId() + " Type: " + ((CustomValue)feature.getValue()).getType());
                    }
                }
            }
        }
    }

    private static boolean testModVersion(CustomValue.CvObject featureObject, String modId, String modBlame) {
        if (featureObject.containsKey(modId)) {
            try {
                VersionPredicate predicate = VersionPredicate.parse((String)featureObject.get(modId).getAsString());
                return predicate.test((Object)((ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow()).getMetadata().getVersion());
            }
            catch (VersionParsingException e) {
                LOGGER.error("Couldn't parse version predicate for {} provided by {}", new Object[]{modId, modBlame});
                return false;
            }
        }
        return true;
    }

    static {
        AndromedaFeatureManager.registerProcessor("mod_json", config -> {
            if (MOD_JSON.isEmpty()) {
                FabricLoader.getInstance().getAllMods().stream().filter(mod -> mod.getMetadata().containsCustomValue("andromeda:features")).forEach(AndromedaFeatureManager::parseMetadata);
            }
            return MOD_JSON;
        });
        FabricLoader.getInstance().getEntrypoints("andromeda:feature_manager", Runnable.class).forEach(Runnable::run);
    }

    public static interface FeatureProcessor {
        @Nullable
        public Map<String, Object> process(AndromedaConfig var1);
    }
}

