/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.registries;

import java.util.ArrayList;
import java.util.Collection;
import me.melontini.andromeda.Andromeda;
import me.melontini.andromeda.items.LockpickItem;
import me.melontini.andromeda.items.RoseOfTheValley;
import me.melontini.andromeda.items.boats.FurnaceBoatItem;
import me.melontini.andromeda.items.boats.HopperBoatItem;
import me.melontini.andromeda.items.boats.JukeboxBoatItem;
import me.melontini.andromeda.items.boats.TNTBoatItem;
import me.melontini.andromeda.items.minecarts.AnvilMinecartItem;
import me.melontini.andromeda.items.minecarts.JukeBoxMinecartItem;
import me.melontini.andromeda.items.minecarts.NoteBlockMinecartItem;
import me.melontini.andromeda.items.minecarts.SpawnerMinecartItem;
import me.melontini.andromeda.registries.BlockRegistry;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.andromeda.util.AndromedaTexts;
import me.melontini.dark_matter.api.base.util.MathStuff;
import me.melontini.dark_matter.api.content.ContentBuilder;
import me.melontini.dark_matter.api.content.RegistryUtil;
import me.melontini.dark_matter.api.content.interfaces.DarkMatterEntries;
import me.melontini.dark_matter.api.minecraft.client.util.DrawUtil;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1087;
import net.minecraft.class_156;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_7706;
import net.minecraft.class_7833;
import net.minecraft.class_7923;

public class ItemRegistry {
    public static RoseOfTheValley ROSE_OF_THE_VALLEY = (RoseOfTheValley)RegistryUtil.asItem((class_2248)BlockRegistry.ROSE_OF_THE_VALLEY);
    public static SpawnerMinecartItem SPAWNER_MINECART = (SpawnerMinecartItem)ContentBuilder.ItemBuilder.create((class_2960)new class_2960("andromeda", "spawner_minecart"), () -> new SpawnerMinecartItem(class_1688.class_1689.field_7680, new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_40198)).build();
    public static AnvilMinecartItem ANVIL_MINECART = (AnvilMinecartItem)ContentBuilder.ItemBuilder.create((class_2960)new class_2960("andromeda", "anvil_minecart"), () -> new AnvilMinecartItem((class_1792.class_1793)new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_40198)).registerCondition(Andromeda.CONFIG.newMinecarts.isAnvilMinecartOn).build();
    public static NoteBlockMinecartItem NOTE_BLOCK_MINECART = (NoteBlockMinecartItem)ContentBuilder.ItemBuilder.create((class_2960)new class_2960("andromeda", "note_block_minecart"), () -> new NoteBlockMinecartItem((class_1792.class_1793)new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_40198)).registerCondition(Andromeda.CONFIG.newMinecarts.isNoteBlockMinecartOn).build();
    public static JukeBoxMinecartItem JUKEBOX_MINECART = (JukeBoxMinecartItem)ContentBuilder.ItemBuilder.create((class_2960)new class_2960("andromeda", "jukebox_minecart"), () -> new JukeBoxMinecartItem((class_1792.class_1793)new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_40198)).registerCondition(Andromeda.CONFIG.newMinecarts.isJukeboxMinecartOn).build();
    public static class_1792 INFINITE_TOTEM = ContentBuilder.ItemBuilder.create((class_2960)new class_2960("andromeda", "infinite_totem"), () -> new class_1792((class_1792.class_1793)new FabricItemSettings().maxCount(1).rarity(class_1814.field_8904))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_40198)).registerCondition(Andromeda.CONFIG.totemSettings.enableInfiniteTotem).build();
    public static class_1792 LOCKPICK = ContentBuilder.ItemBuilder.create((class_2960)new class_2960("andromeda", "lockpick"), () -> new LockpickItem((class_1792.class_1793)new FabricItemSettings().maxCount(16))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_41060)).registerCondition(Andromeda.CONFIG.lockpickEnabled).build();
    public static class_1747 INCUBATOR = (class_1747)RegistryUtil.asItem((class_2248)BlockRegistry.INCUBATOR_BLOCK);
    private static class_1799 ITEM_GROUP_ICON;
    public static class_1761 GROUP;

    public static void register() {
        for (class_1690.class_1692 value : class_1690.class_1692.values()) {
            ContentBuilder.ItemBuilder.create((class_2960)ItemRegistry.boatId(value, "furnace"), () -> new FurnaceBoatItem(value, (class_1792.class_1793)new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_41060)).registerCondition(Andromeda.CONFIG.newBoats.isFurnaceBoatOn).build();
            ContentBuilder.ItemBuilder.create((class_2960)ItemRegistry.boatId(value, "jukebox"), () -> new JukeboxBoatItem(value, (class_1792.class_1793)new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_41060)).registerCondition(Andromeda.CONFIG.newBoats.isJukeboxBoatOn).build();
            ContentBuilder.ItemBuilder.create((class_2960)ItemRegistry.boatId(value, "tnt"), () -> new TNTBoatItem(value, (class_1792.class_1793)new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_41060)).registerCondition(Andromeda.CONFIG.newBoats.isTNTBoatOn).build();
            ContentBuilder.ItemBuilder.create((class_2960)ItemRegistry.boatId(value, "hopper"), () -> new HopperBoatItem(value, (class_1792.class_1793)new FabricItemSettings().maxCount(1))).itemGroup((class_1761)class_7923.field_44687.method_29107(class_7706.field_41060)).registerCondition(Andromeda.CONFIG.newBoats.isHopperBoatOn).build();
        }
        AndromedaLog.info("ItemRegistry init complete!");
    }

    public static class_2960 boatId(class_1690.class_1692 type, String boat) {
        return new class_2960("andromeda", type.method_7559().replace(":", "_") + "_boat_with_" + boat);
    }

    private static void appendStacks(DarkMatterEntries entries, Collection<class_1799> list, boolean lineBreak) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int rows = MathStuff.fastCeil((double)((double)list.size() / 9.0));
        entries.addAll(list, DarkMatterEntries.Visibility.TAB);
        int left = rows * 9 - list.size();
        for (int i = 0; i < left; ++i) {
            entries.add(class_1799.field_8037, DarkMatterEntries.Visibility.TAB);
        }
        if (lineBreak) {
            entries.addAll((Collection)class_2371.method_10213((int)9, (Object)class_1799.field_8037), DarkMatterEntries.Visibility.TAB);
        }
    }

    private static class_1799 getAndSetIcon() {
        if (ITEM_GROUP_ICON == null) {
            ITEM_GROUP_ICON = Andromeda.CONFIG.unknown && ROSE_OF_THE_VALLEY != null ? new class_1799((class_1935)ROSE_OF_THE_VALLEY) : (Andromeda.CONFIG.totemSettings.enableInfiniteTotem && INFINITE_TOTEM != null ? new class_1799((class_1935)INFINITE_TOTEM) : (Andromeda.CONFIG.incubatorSettings.enableIncubator && INCUBATOR != null ? new class_1799((class_1935)INCUBATOR) : new class_1799((class_1935)class_1802.field_8542)));
        }
        return ITEM_GROUP_ICON;
    }

    static {
        GROUP = ContentBuilder.ItemGroupBuilder.create((class_2960)new class_2960("andromeda", "group")).entries(entries -> {
            ArrayList<class_1799> misc = new ArrayList<class_1799>();
            if (Andromeda.CONFIG.incubatorSettings.enableIncubator && INCUBATOR != null) {
                misc.add(INCUBATOR.method_7854());
            }
            if (Andromeda.CONFIG.totemSettings.enableInfiniteTotem && INFINITE_TOTEM != null) {
                misc.add(INFINITE_TOTEM.method_7854());
            }
            ItemRegistry.appendStacks(entries, misc, true);
            ArrayList<class_1799> carts = new ArrayList<class_1799>();
            if (Andromeda.CONFIG.newMinecarts.isAnvilMinecartOn && ANVIL_MINECART != null) {
                carts.add(ANVIL_MINECART.method_7854());
            }
            if (Andromeda.CONFIG.newMinecarts.isJukeboxMinecartOn && JUKEBOX_MINECART != null) {
                carts.add(JUKEBOX_MINECART.method_7854());
            }
            if (Andromeda.CONFIG.newMinecarts.isNoteBlockMinecartOn && NOTE_BLOCK_MINECART != null) {
                carts.add(NOTE_BLOCK_MINECART.method_7854());
            }
            carts.add(SPAWNER_MINECART.method_7854());
            ItemRegistry.appendStacks(entries, carts, true);
            ArrayList<class_1799> boats = new ArrayList<class_1799>();
            for (class_1690.class_1692 value : class_1690.class_1692.values()) {
                if (Andromeda.CONFIG.newBoats.isFurnaceBoatOn) {
                    boats.add(((class_1792)class_7923.field_41178.method_10223(new class_2960("andromeda", value.method_7559().replace(":", "_") + "_boat_with_furnace"))).method_7854());
                }
                if (Andromeda.CONFIG.newBoats.isJukeboxBoatOn) {
                    boats.add(((class_1792)class_7923.field_41178.method_10223(new class_2960("andromeda", value.method_7559().replace(":", "_") + "_boat_with_jukebox"))).method_7854());
                }
                if (Andromeda.CONFIG.newBoats.isTNTBoatOn) {
                    boats.add(((class_1792)class_7923.field_41178.method_10223(new class_2960("andromeda", value.method_7559().replace(":", "_") + "_boat_with_tnt"))).method_7854());
                }
                if (!Andromeda.CONFIG.newBoats.isHopperBoatOn) continue;
                boats.add(((class_1792)class_7923.field_41178.method_10223(new class_2960("andromeda", value.method_7559().replace(":", "_") + "_boat_with_hopper"))).method_7854());
            }
            ItemRegistry.appendStacks(entries, boats, false);
        }).icon(ItemRegistry::getAndSetIcon).animatedIcon(() -> (context, itemX, itemY, selected, isTopRow) -> {
            class_310 client = class_310.method_1551();
            float angle = (float)class_156.method_658() * 0.09f;
            class_4587 matrixStack = context.method_51448();
            matrixStack.method_22903();
            matrixStack.method_46416((float)itemX, (float)itemY, 100.0f);
            matrixStack.method_22904(8.0, 8.0, 0.0);
            matrixStack.method_22905(1.0f, -1.0f, 1.0f);
            matrixStack.method_22905(16.0f, 16.0f, 16.0f);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(angle));
            class_1087 model = client.method_1480().method_4019(ItemRegistry.getAndSetIcon(), null, null, 0);
            DrawUtil.renderGuiItemModelCustomMatrixNoTransform((class_4587)matrixStack, (class_1799)ItemRegistry.getAndSetIcon(), (class_1087)model);
            matrixStack.method_22909();
        }).displayName(AndromedaTexts.ITEM_GROUP_NAME).build();
    }
}

