/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.util;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import me.melontini.andromeda.Andromeda;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.dark_matter.api.base.util.MakeSure;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_163;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_194;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class AdvancementGeneration {
    public static final Hash.Strategy<class_1799> STRATEGY = new Hash.Strategy<class_1799>(){

        public int hashCode(class_1799 itemStack) {
            if (itemStack != null) {
                class_2487 nbtCompound = itemStack.method_7969();
                int i = 31 + itemStack.method_7909().hashCode();
                return 31 * i + (nbtCompound == null ? 0 : nbtCompound.hashCode());
            }
            return 0;
        }

        public boolean equals(class_1799 itemStack, class_1799 itemStack2) {
            return itemStack == itemStack2 || itemStack != null && itemStack2 != null && itemStack.method_7960() == itemStack2.method_7960() && class_1799.method_7973((class_1799)itemStack, (class_1799)itemStack2);
        }
    };
    private static final Map<class_3956<?>, BiConsumer<Map<class_2960, class_161.class_162>, class_1860<?>>> RECIPE_TYPE_HANDLERS = new HashMap();

    public static BiConsumer<Map<class_2960, class_161.class_162>, class_1860<?>> basicConsumer(String typeName) {
        return (map, recipe) -> map.put(AdvancementGeneration.idFromRecipe(recipe, typeName), AdvancementGeneration.createAdvBuilder(recipe.method_8114(), (class_1856)recipe.method_8117().get(0)));
    }

    private static class_2960 idFromRecipe(class_1860<?> recipe, String typeName) {
        return new class_2960(recipe.method_8114().method_12836(), "recipes/gen/" + typeName + "/" + recipe.method_8114().toString().replace(":", "_"));
    }

    public static void addRecipeTypeHandler(class_3956<?> type, BiConsumer<Map<class_2960, class_161.class_162>, class_1860<?>> consumer) {
        RECIPE_TYPE_HANDLERS.putIfAbsent(type, consumer);
    }

    public static void generateRecipeAdvancements(MinecraftServer server) {
        ConcurrentHashMap advancementBuilders = new ConcurrentHashMap();
        AtomicInteger count = new AtomicInteger();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        List lists = Lists.partition(server.method_3772().method_8126().stream().toList(), (int)800);
        for (List list : lists) {
            futures.add(CompletableFuture.runAsync(() -> {
                for (class_1860 recipe : list) {
                    if (Andromeda.CONFIG.autogenRecipeAdvancements.blacklistedRecipeNamespaces.contains(recipe.method_8114().method_12836()) || Andromeda.CONFIG.autogenRecipeAdvancements.blacklistedRecipeIds.contains(recipe.method_8114().toString()) || recipe.method_8118() && Andromeda.CONFIG.autogenRecipeAdvancements.ignoreRecipesHiddenInTheRecipeBook) continue;
                    if (RECIPE_TYPE_HANDLERS.get(recipe.method_17716()) != null) {
                        count.getAndIncrement();
                        RECIPE_TYPE_HANDLERS.get(recipe.method_17716()).accept(advancementBuilders, recipe);
                        continue;
                    }
                    if (recipe.method_8117().isEmpty()) continue;
                    count.getAndIncrement();
                    advancementBuilders.put(new class_2960(recipe.method_8114().method_12836(), "recipes/gen/generic/" + recipe.method_8114().toString().replace(":", "_")), AdvancementGeneration.createAdvBuilder(recipe.method_8114(), (class_1856[])recipe.method_8117().toArray(class_1856[]::new)));
                }
            }, class_156.method_18349()));
        }
        CompletableFuture<Void> future = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        server.method_18857(future::isDone);
        class_163 advancementManager = server.method_3851().field_13404;
        advancementManager.method_711(advancementBuilders);
        for (class_161 advancement : advancementManager.method_715()) {
            if (advancement.method_686() == null) continue;
            class_194.method_852((class_161)advancement);
        }
        AndromedaLog.info("finished generating {} recipe advancements", count.get());
        advancementBuilders.clear();
    }

    @NotNull
    public static class_161.class_162 createAdvBuilder(class_2960 id, class_1856 ... ingredients) {
        String[][] reqs;
        MakeSure.notEmpty((Object[])ingredients);
        class_161.class_162 builder = class_161.class_162.method_707();
        builder.method_708(class_2960.method_12829((String)"minecraft:recipes/root"));
        ArrayList<String> names = new ArrayList<String>();
        HashSet<class_6862> tags = new HashSet<class_6862>();
        ObjectLinkedOpenCustomHashSet stacks = new ObjectLinkedOpenCustomHashSet(STRATEGY);
        for (int i = 0; i < ingredients.length; ++i) {
            class_1856 ingredient = ingredients[i];
            ArrayList predicates = new ArrayList();
            for (int j = 0; j < ingredient.field_9019.length; ++j) {
                class_1856.class_1859 entry = ingredient.field_9019[j];
                if (entry instanceof class_1856.class_1857) {
                    class_1856.class_1857 stackEntry = (class_1856.class_1857)entry;
                    if (stackEntry.field_9021.method_7960() || stacks.contains(stackEntry.field_9021)) continue;
                    stacks.add(stackEntry.field_9021);
                    names.add(String.valueOf(i));
                    class_2073.class_2074 predicateBuilder = class_2073.class_2074.method_8973().method_8977(new class_1935[]{stackEntry.field_9021.method_7909()});
                    if (stackEntry.field_9021.method_7969() != null) {
                        predicateBuilder.method_20399(stackEntry.field_9021.method_7969());
                    }
                    Optional.ofNullable(predicateBuilder.method_8976()).ifPresent(predicates::add);
                    continue;
                }
                if (entry instanceof class_1856.class_1858) {
                    class_1856.class_1858 tagEntry = (class_1856.class_1858)entry;
                    if (tags.contains(tagEntry.field_9022)) continue;
                    tags.add(tagEntry.field_9022);
                    names.add(String.valueOf(i));
                    Optional.ofNullable(class_2073.class_2074.method_8973().method_8975(tagEntry.field_9022).method_8976()).ifPresent(predicates::add);
                    continue;
                }
                AndromedaLog.error("unknown ingredient found in {}", id);
            }
            builder.method_709(String.valueOf(i), (class_184)class_2066.class_2068.method_8957((class_2073[])((class_2073[])predicates.toArray(class_2073[]::new))));
        }
        builder.method_709("has_recipe", (class_184)new class_2119.class_2121(class_5258.method_27973((class_5341[])new class_5341[0]), id));
        if (Andromeda.CONFIG.autogenRecipeAdvancements.requireAllItems) {
            reqs = new String[names.size()][2];
            for (int i = 0; i < names.size(); ++i) {
                reqs[i][0] = s = (String)names.get(i);
                reqs[i][1] = "has_recipe";
            }
        } else {
            reqs = new String[1][names.size() + 1];
            for (int i = 0; i < names.size(); ++i) {
                reqs[0][i] = s = (String)names.get(i);
            }
            reqs[0][names.size()] = "has_recipe";
        }
        builder.method_34884(reqs);
        names.clear();
        tags.clear();
        stacks.clear();
        Optional.ofNullable(class_170.class_171.method_753((class_2960)id).method_751()).ifPresent(arg_0 -> ((class_161.class_162)builder).method_706(arg_0));
        return builder;
    }

    static {
        AdvancementGeneration.addRecipeTypeHandler(class_3956.field_17547, AdvancementGeneration.basicConsumer("blasting"));
        AdvancementGeneration.addRecipeTypeHandler(class_3956.field_17548, AdvancementGeneration.basicConsumer("smoking"));
        AdvancementGeneration.addRecipeTypeHandler(class_3956.field_17546, AdvancementGeneration.basicConsumer("smelting"));
        AdvancementGeneration.addRecipeTypeHandler(class_3956.field_17549, AdvancementGeneration.basicConsumer("campfire_cooking"));
        AdvancementGeneration.addRecipeTypeHandler(class_3956.field_17641, AdvancementGeneration.basicConsumer("stonecutting"));
        AdvancementGeneration.addRecipeTypeHandler(class_3956.field_17545, (map, recipe) -> {
            if (!(recipe instanceof class_1852) && !recipe.method_8117().isEmpty()) {
                map.put(AdvancementGeneration.idFromRecipe(recipe, "crafting"), AdvancementGeneration.createAdvBuilder(recipe.method_8114(), (class_1856[])recipe.method_8117().toArray(class_1856[]::new)));
            }
        });
    }
}

