/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import me.melontini.andromeda.config.AndromedaConfig;
import me.melontini.andromeda.config.AndromedaFeatureManager;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.andromeda.util.ConfigHelper;
import me.melontini.andromeda.util.SharedConstants;
import me.melontini.andromeda.util.annotations.MixinRelatedConfigOption;
import me.melontini.andromeda.util.exceptions.AndromedaException;
import me.melontini.dark_matter.api.base.util.PrependingLogger;
import me.melontini.dark_matter.api.base.util.mixin.ExtendedPlugin;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class AndromedaMixinPlugin
extends ExtendedPlugin {
    private static final PrependingLogger LOGGER = new PrependingLogger(LogManager.getLogger((String)"AndromedaMixinPlugin"), PrependingLogger.LOGGER_NAME);
    private static final String MIXIN_TO_OPTION_ANNOTATION = "L" + MixinRelatedConfigOption.class.getName().replace(".", "/") + ";";
    private static AndromedaConfig CONFIG;
    private static boolean log;

    public void onLoad(String mixinPackage) {
        super.onLoad(mixinPackage);
        LOGGER.info("Platform: " + SharedConstants.PLATFORM);
        Path mtConfig = FabricLoader.getInstance().getConfigDir().resolve("m-tweaks.json");
        if (Files.exists(mtConfig, new LinkOption[0])) {
            try {
                Files.move(mtConfig, SharedConstants.CONFIG_PATH, new CopyOption[0]);
            }
            catch (IOException e) {
                AndromedaLog.error("Couldn't rename old m-tweaks config!", e);
            }
        }
        AndromedaMixinPlugin.loadConfigFromFile();
        log = AndromedaMixinPlugin.CONFIG.debugMessages || FabricLoader.getInstance().isDevelopmentEnvironment();
        AndromedaLog.setDebug(log);
        if (AndromedaMixinPlugin.CONFIG.compatMode) {
            LOGGER.warn("Compat mode is on!");
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean load;
        block9: {
            load = super.shouldApplyMixin(targetClassName, mixinClassName);
            if (AndromedaMixinPlugin.CONFIG.compatMode && load) {
                try {
                    ClassNode node = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
                    if (node.visibleAnnotations == null) break block9;
                    block5: for (AnnotationNode node1 : node.visibleAnnotations) {
                        if (!MIXIN_TO_OPTION_ANNOTATION.equals(node1.desc)) continue;
                        Map values = AndromedaMixinPlugin.mapAnnotationNode((AnnotationNode)node1);
                        List configOptions = (List)values.get("value");
                        for (String configOption : configOptions) {
                            try {
                                load = (Boolean)ConfigHelper.getConfigOption(configOption, CONFIG);
                            }
                            catch (NoSuchFieldException e) {
                                throw new AndromedaException("Invalid config option in MixinRelatedConfigOption: " + configOption + " This is no fault of yours.");
                            }
                            catch (ClassCastException e) {
                                throw new AndromedaException("Non-boolean config option in MixinRelatedConfigOption: " + configOption + " This is no fault of yours.");
                            }
                            if (load) continue;
                            continue block5;
                        }
                    }
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException e) {
                    throw new AndromedaException("Exception while evaluating shouldApplyMixin", (Throwable)e);
                }
            }
        }
        if (log) {
            LOGGER.info("{} ({}) : {}", new Object[]{mixinClassName.replaceFirst("me\\.melontini\\.andromeda\\.mixin\\.", ""), targetClassName.replaceFirst("net\\.minecraft\\.", ""), load ? "applied \u2705" : "skipped \u23e9"});
        }
        return load;
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        super.postApply(targetClassName, targetClass, mixinClassName, mixinInfo);
        if (targetClass.visibleAnnotations != null && !targetClass.visibleAnnotations.isEmpty()) {
            targetClass.visibleAnnotations.removeIf(node -> MIXIN_TO_OPTION_ANNOTATION.equals(node.desc));
        }
    }

    private static void loadConfigFromFile() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path config = SharedConstants.CONFIG_PATH;
        if (Files.exists(config, new LinkOption[0])) {
            try {
                CONFIG = (AndromedaConfig)gson.fromJson(Files.readString(config), AndromedaConfig.class);
                AndromedaFeatureManager.processFeatures(CONFIG);
                Files.write(config, gson.toJson((Object)CONFIG).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        CONFIG = new AndromedaConfig();
        AndromedaFeatureManager.processFeatures(CONFIG);
        try {
            Files.createFile(config, new FileAttribute[0]);
            Files.write(config, gson.toJson((Object)CONFIG).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOGGER.info("Definitely up to a lot of good");
    }
}

