/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.util;

import java.util.List;
import java.util.Optional;
import me.melontini.andromeda.content.managers.CustomTraderManager;
import me.melontini.andromeda.content.managers.EnderDragonManager;
import me.melontini.andromeda.networks.AndromedaPackets;
import me.melontini.dark_matter.api.base.util.MakeSure;
import me.melontini.dark_matter.api.minecraft.data.NbtBuilder;
import me.melontini.dark_matter.api.minecraft.world.PlayerUtil;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2743;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4482;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

public class WorldUtil {
    public static final class_2960 BEE_LOOT_ID = new class_2960("andromeda", "bee_nest/bee_nest_broken");
    public static final List<class_2350> AROUND_BLOCK_DIRECTIONS = List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034);

    public static CustomTraderManager getTraderManager(@NotNull class_3218 world) {
        return (CustomTraderManager)world.method_17983().method_17924(nbtCompound -> {
            CustomTraderManager manager = new CustomTraderManager();
            manager.readNbt((class_2487)nbtCompound);
            return manager;
        }, CustomTraderManager::new, "andromeda_trader_statemanager");
    }

    public static EnderDragonManager getEnderDragonManager(class_3218 world) {
        return (EnderDragonManager)world.method_17983().method_17924(nbtCompound -> {
            EnderDragonManager manager = new EnderDragonManager(world);
            manager.readNbt((class_2487)nbtCompound);
            return manager;
        }, () -> new EnderDragonManager(world), "andromeda_ender_dragon_fight");
    }

    public static void addParticle(class_1937 world, class_2394 parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        if (!world.field_9236) {
            class_2540 packetByteBuf = PacketByteBufs.create();
            packetByteBuf.method_42065((class_2359)class_7923.field_41180, (Object)parameters.method_10295());
            packetByteBuf.writeDouble(x);
            packetByteBuf.writeDouble(y);
            packetByteBuf.writeDouble(z);
            packetByteBuf.writeDouble(velocityX);
            packetByteBuf.writeDouble(velocityY);
            packetByteBuf.writeDouble(velocityZ);
            for (class_1657 player : PlayerUtil.findPlayersInRange((class_1937)world, (class_2338)new class_2338(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z)), (int)85)) {
                ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)AndromedaPackets.ADD_ONE_PARTICLE, (class_2540)packetByteBuf);
            }
        } else {
            throw new UnsupportedOperationException("Can't send packets to client unless you're on server.");
        }
    }

    public static void crudeSetVelocity(class_1297 entity, double x, double y, double z) {
        WorldUtil.crudeSetVelocity(entity, new class_243(x, y, z));
    }

    public static void crudeSetVelocity(class_1297 entity, class_243 velocity) {
        if (!entity.field_6002.field_9236) {
            entity.method_18799(velocity);
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                player.field_13987.method_14364((class_2596)new class_2743(entity));
            }
        } else {
            throw new UnsupportedOperationException("Can't send packets to client unless you're on server.");
        }
    }

    public static List<class_1799> prepareLoot(@NotNull class_1937 world, class_2960 lootId) {
        MakeSure.notNulls((Object[])new Object[]{world, lootId});
        return ((class_3218)world).method_8503().method_3857().getLootTable(lootId).method_51878(new class_8567.class_8568((class_3218)world).method_51875(class_173.field_1175));
    }

    public static void trySpawnFallingBeeNest(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_4482 beehiveBlockEntity) {
        MakeSure.notNulls((Object[])new Object[]{world, pos, state, beehiveBlockEntity});
        class_1540 fallingBlock = new class_1540(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, state.method_28498((class_2769)class_2741.field_12508) ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.FALSE) : state);
        fallingBlock.method_5749(NbtBuilder.create().put("TileEntityData", (class_2520)NbtBuilder.create().put("Bees", (class_2520)beehiveBlockEntity.method_21859()).putBoolean("AM-FromFallenBlock", true).build()).put("BlockState", (class_2520)class_2512.method_10686((class_2680)state)).build());
        world.method_8652(pos, state.method_26227().method_15759(), 3);
        world.method_8649((class_1297)fallingBlock);
    }

    public static boolean isClear(class_1937 world, class_2338 pos) {
        if (!world.method_8320(pos).method_26215()) {
            return false;
        }
        for (class_2350 dir : AROUND_BLOCK_DIRECTIONS) {
            if (world.method_8320(pos.method_10093(dir)).method_26215()) continue;
            return false;
        }
        return true;
    }

    public static Optional<class_2338> pickRandomSpot(class_1937 world, class_2338 blockPos, int range, class_5819 random) {
        class_2338 pos;
        MakeSure.notNulls((Object[])new Object[]{world, blockPos, random});
        MakeSure.isTrue((range > 0 ? 1 : 0) != 0, (String)"range can't be negative or zero!");
        int i = 0;
        double j = (double)(range * range * range) * 0.75;
        do {
            if (!((double)(++i) > j)) continue;
            return Optional.empty();
        } while (!world.method_8320((pos = new class_2338(blockPos.method_10263() + random.method_39332(-range, range), blockPos.method_10264() + random.method_39332(-range, range), blockPos.method_10260() + random.method_39332(-range, range))).method_10084()).method_26215() || !world.method_8320(pos).method_26215() || !WorldUtil.isClear(world, pos) || !WorldUtil.isClear(world, pos.method_10084()));
        return Optional.of(pos);
    }
}

