/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.util.translations;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.andromeda.util.GitTracker;
import me.melontini.andromeda.util.SharedConstants;
import me.melontini.andromeda.util.exceptions.AndromedaException;
import net.fabricmc.loader.api.FabricLoader;

public class TranslationUpdater {
    public static final Path TRANSLATION_PACK = SharedConstants.HIDDEN_PATH.resolve("andromeda_translations");
    public static final Path LANG_PATH = TRANSLATION_PACK.resolve("assets/andromeda/lang");
    private static final Path OPTIONS = FabricLoader.getInstance().getGameDir().resolve("options.txt");
    private static final String URL = "https://raw.githubusercontent.com/melontini/andromeda/" + GitTracker.getDefaultBranch() + "/src/main/resources/assets/andromeda/lang/";
    private static final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    private static String languageCode = "en_us";

    public static void onResourceReload(String code) {
        if (!languageCode.equals(code)) {
            languageCode = code;
            HashSet languages = Sets.newHashSet((Object[])new String[]{"en_us"});
            languages.add(code);
            TranslationUpdater.downloadTranslations(languages);
        }
    }

    public static void downloadTranslations(Set<String> languages) {
        for (String language : languages) {
            String file = TranslationUpdater.downloadLang(language);
            if (file.isEmpty()) continue;
            try {
                if (!Files.exists(LANG_PATH, new LinkOption[0])) {
                    Files.createDirectories(LANG_PATH, new FileAttribute[0]);
                }
                Files.writeString(LANG_PATH.resolve(language + ".json"), (CharSequence)file, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String downloadLang(String language) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(URL + language + ".json")).GET().build();
            HttpResponse<String> response = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                AndromedaLog.info("Couldn't download " + language + ".json. Status code: " + response.statusCode() + " Body: " + response.body());
                return "";
            }
            AndromedaLog.info("Downloaded " + language + ".json");
            return response.body();
        }
        catch (IOException | InterruptedException e) {
            AndromedaLog.error("Couldn't download " + language + ".json", e);
            return "";
        }
    }

    public static String getSelectedLanguage() {
        try {
            if (!Files.exists(OPTIONS, new LinkOption[0])) {
                return "";
            }
            for (String line : Files.readAllLines(OPTIONS)) {
                if (!line.matches("^lang:\\w+_\\w+")) continue;
                languageCode = line.replace("lang:", "");
                return languageCode;
            }
            throw new AndromedaException(false, "Invalid language option!");
        }
        catch (Throwable e) {
            AndromedaLog.error("Couldn't determine selected language!", e);
            return "";
        }
    }
}

