/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String CATAGORY_GENERAL = "general";
    public static final String CATAGORY_ELECTRIC_MOTOR = "electric_motor";
    public static final String CATAGORY_ALTERNATOR = "alternator";
    public static final String CATAGORY_ROLLING_MILL = "rolling_mill";
    public static final String CATAGORY_HEATER = "heater";
    public static final String CATAGORY_WIRES = "wires";
    public static final String CATAGORY_ACCUMULATOR = "accumulator";
    public static final String CATAGORY_PEI = "portable_energy_interface";
    public static final String CATAGORY_CHARGER = "charger";
    public static final String CATAGORY_TESLA_COIL = "tesla_coil";
    public static final String CATAGORY_MISC = "misc";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.IntValue ELECTRIC_MOTOR_RPM_RANGE;
    public static ForgeConfigSpec.LongValue ELECTRIC_MOTOR_MAX_INPUT;
    public static ForgeConfigSpec.IntValue ELECTRIC_MOTOR_MINIMUM_CONSUMPTION;
    public static ForgeConfigSpec.LongValue ELECTRIC_MOTOR_CAPACITY;
    public static ForgeConfigSpec.IntValue FE_RPM;
    public static ForgeConfigSpec.IntValue MAX_STRESS;
    public static ForgeConfigSpec.LongValue ALTERNATOR_MAX_OUTPUT;
    public static ForgeConfigSpec.LongValue ALTERNATOR_CAPACITY;
    public static ForgeConfigSpec.DoubleValue ALTERNATOR_EFFICIENCY;
    public static ForgeConfigSpec.IntValue ROLLING_MILL_PROCESSING_DURATION;
    public static ForgeConfigSpec.IntValue ROLLING_MILL_STRESS;
    public static ForgeConfigSpec.LongValue CONNECTOR_MAX_INPUT;
    public static ForgeConfigSpec.LongValue CONNECTOR_MAX_OUTPUT;
    public static ForgeConfigSpec.LongValue CONNECTOR_CAPACITY;
    public static ForgeConfigSpec.IntValue CONNECTOR_MAX_LENGTH;
    public static ForgeConfigSpec.BooleanValue CONNECTOR_IGNORE_FACE_CHECK;
    public static ForgeConfigSpec.LongValue ACCUMULATOR_MAX_INPUT;
    public static ForgeConfigSpec.LongValue ACCUMULATOR_MAX_OUTPUT;
    public static ForgeConfigSpec.LongValue ACCUMULATOR_CAPACITY;
    public static ForgeConfigSpec.IntValue ACCUMULATOR_MAX_HEIGHT;
    public static ForgeConfigSpec.IntValue ACCUMULATOR_MAX_WIDTH;
    public static ForgeConfigSpec.LongValue PEI_MAX_INPUT;
    public static ForgeConfigSpec.LongValue PEI_MAX_OUTPUT;
    public static ForgeConfigSpec.LongValue TESLA_COIL_MAX_INPUT;
    public static ForgeConfigSpec.LongValue TESLA_COIL_CHARGE_RATE;
    public static ForgeConfigSpec.LongValue TESLA_COIL_RECIPE_CHARGE_RATE;
    public static ForgeConfigSpec.LongValue TESLA_COIL_CAPACITY;
    public static ForgeConfigSpec.LongValue TESLA_COIL_HURT_ENERGY_REQUIRED;
    public static ForgeConfigSpec.IntValue TESLA_COIL_HURT_DMG_MOB;
    public static ForgeConfigSpec.IntValue TESLA_COIL_HURT_DMG_PLAYER;
    public static ForgeConfigSpec.IntValue TESLA_COIL_HURT_RANGE;
    public static ForgeConfigSpec.IntValue TESLA_COIL_HURT_EFFECT_TIME_MOB;
    public static ForgeConfigSpec.IntValue TESLA_COIL_HURT_EFFECT_TIME_PLAYER;
    public static ForgeConfigSpec.IntValue TESLA_COIL_HURT_FIRE_COOLDOWN;
    public static ForgeConfigSpec.IntValue DIAMOND_GRIT_SANDPAPER_USES;
    public static ForgeConfigSpec.DoubleValue BARBED_WIRE_DAMAGE;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        COMMON_BUILDER.comment("Make sure config changes are duplicated on both Clients and the Server when running a dedicated Server,").comment(" as the config isnt synced between Clients and Server.");
        COMMON_BUILDER.comment("General Settings").push(CATAGORY_GENERAL);
        FE_RPM = COMMON_BUILDER.comment("Forge Energy conversion rate (in E/t at 256 RPM, value is the E/t generated and consumed is at 256rpm).").defineInRange("fe_at_max_rpm", 240, 0, Integer.MAX_VALUE);
        MAX_STRESS = COMMON_BUILDER.comment("Max stress for the Alternator and Electric Motor (in SU at 256 RPM).").defineInRange("max_stress", 16384, 0, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Electric Motor").push(CATAGORY_ELECTRIC_MOTOR);
        ELECTRIC_MOTOR_RPM_RANGE = COMMON_BUILDER.comment("Electric Motor min/max RPM.").defineInRange("motor_rpm_range", 256, 1, Integer.MAX_VALUE);
        ELECTRIC_MOTOR_MINIMUM_CONSUMPTION = COMMON_BUILDER.comment("Electric Motor minimum required energy consumption in E/t.").defineInRange("motor_min_consumption", 8, 0, Integer.MAX_VALUE);
        ELECTRIC_MOTOR_MAX_INPUT = COMMON_BUILDER.comment("Electric Motor max input in E (Energy transfer not consumption).").defineInRange("motor_max_input", 5000L, 0L, Long.MAX_VALUE);
        ELECTRIC_MOTOR_CAPACITY = COMMON_BUILDER.comment("Electric Motor internal capacity in E.").defineInRange("motor_capacity", 5000L, 0L, Long.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Alternator").push(CATAGORY_ALTERNATOR);
        ALTERNATOR_MAX_OUTPUT = COMMON_BUILDER.comment("Alternator max input in E (Energy transfer, not generation).").defineInRange("generator_max_output", 5000L, 0L, Long.MAX_VALUE);
        ALTERNATOR_CAPACITY = COMMON_BUILDER.comment("Alternator internal capacity in E.").defineInRange("generator_capacity", 5000L, 0L, Long.MAX_VALUE);
        ALTERNATOR_EFFICIENCY = COMMON_BUILDER.comment("Alternator efficiency relative to base conversion rate.").defineInRange("generator_efficiency", 0.75, 0.01, 1.0);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Rolling Mill").push(CATAGORY_ROLLING_MILL);
        ROLLING_MILL_PROCESSING_DURATION = COMMON_BUILDER.comment("Rolling Mill duration in ticks.").defineInRange("rolling_mill_processing_duration", 100, 0, Integer.MAX_VALUE);
        ROLLING_MILL_STRESS = COMMON_BUILDER.comment("Rolling Mill base stress impact.").defineInRange("rolling_mill_stress", 16, 0, 1024);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Wires").push(CATAGORY_WIRES);
        CONNECTOR_MAX_INPUT = COMMON_BUILDER.comment("Connector max input in E/t (Energy transfer).").defineInRange("connector_max_input", 5000L, 0L, Long.MAX_VALUE);
        CONNECTOR_MAX_OUTPUT = COMMON_BUILDER.comment("Connector max output in E/t (Energy transfer).").defineInRange("connector_max_output", 5000L, 0L, Long.MAX_VALUE);
        CONNECTOR_CAPACITY = COMMON_BUILDER.comment("Connector internal input buffer in E.").defineInRange("connector_input_capacity", 5000L, 0L, Long.MAX_VALUE);
        CONNECTOR_MAX_LENGTH = COMMON_BUILDER.comment("Max wire length in blocks.").defineInRange("wire_length", 12, 0, 256);
        CONNECTOR_IGNORE_FACE_CHECK = COMMON_BUILDER.comment("Ignore checking if block face can support connector.").define("connector_ignore_face_check", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Accumulator").push(CATAGORY_ACCUMULATOR);
        ACCUMULATOR_MAX_INPUT = COMMON_BUILDER.comment("Accumulator max input in E/t (Energy transfer).").defineInRange("accumulator_max_input", 5000L, 0L, Long.MAX_VALUE);
        ACCUMULATOR_MAX_OUTPUT = COMMON_BUILDER.comment("Accumulator max output in E/t (Energy transfer).").defineInRange("accumulator_max_output", 5000L, 0L, Long.MAX_VALUE);
        ACCUMULATOR_CAPACITY = COMMON_BUILDER.comment("Accumulator internal capacity per block in E.").defineInRange("accumulator_capacity", 2000000L, 0L, Long.MAX_VALUE);
        ACCUMULATOR_MAX_HEIGHT = COMMON_BUILDER.comment("Accumulator max multiblock height.").defineInRange("accumulator_max_height", 5, 1, 8);
        ACCUMULATOR_MAX_WIDTH = COMMON_BUILDER.comment("Accumulator max multiblock width.").defineInRange("accumulator_max_width", 3, 1, 8);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Portable Energy Interface").push(CATAGORY_PEI);
        PEI_MAX_INPUT = COMMON_BUILDER.comment("PEI max input in E/t (Energy transfer).").defineInRange("pei_max_input", 5000L, 0L, Long.MAX_VALUE);
        PEI_MAX_OUTPUT = COMMON_BUILDER.comment("PEI max output in E/t (Energy transfer).").defineInRange("pei_max_output", 5000L, 0L, Long.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Tesla Coil").push(CATAGORY_TESLA_COIL);
        TESLA_COIL_MAX_INPUT = COMMON_BUILDER.comment("Tesla Coil max input in E/t (Energy transfer).").defineInRange("tesla_coil_max_input", 10000L, 0L, Long.MAX_VALUE);
        TESLA_COIL_CHARGE_RATE = COMMON_BUILDER.comment("Tesla Coil charge rate in E/t.").defineInRange("tesla_coil_charge_rate", 5000L, 0L, Long.MAX_VALUE);
        TESLA_COIL_RECIPE_CHARGE_RATE = COMMON_BUILDER.comment("Tesla Coil charge rate in E/t for recipes.").defineInRange("tesla_coil_recipe_charge_rate", 2000L, 0L, Long.MAX_VALUE);
        TESLA_COIL_CAPACITY = COMMON_BUILDER.comment("Tesla Coil internal capacity in E.").defineInRange("tesla_coil_capacity", 40000L, 0L, Long.MAX_VALUE);
        TESLA_COIL_HURT_ENERGY_REQUIRED = COMMON_BUILDER.comment("Energy consumed when Tesla Coil is fired (in E).").defineInRange("tesla_coil_hurt_energy_required", 1000L, 0L, Long.MAX_VALUE);
        TESLA_COIL_HURT_RANGE = COMMON_BUILDER.comment("Hurt range (in blocks/meters).").defineInRange("tesla_coil_hurt_range", 3, 0, Integer.MAX_VALUE);
        TESLA_COIL_HURT_DMG_MOB = COMMON_BUILDER.comment("Damaged dealt to mobs when Tesla Coil is fired (in half hearts).").defineInRange("tesla_coil_hurt_mob", 3, 0, Integer.MAX_VALUE);
        TESLA_COIL_HURT_EFFECT_TIME_MOB = COMMON_BUILDER.comment("The duration of the Shocked effect for mobs (in ticks).").defineInRange("tesla_coil_effect_time_mob", 20, 0, Integer.MAX_VALUE);
        TESLA_COIL_HURT_DMG_PLAYER = COMMON_BUILDER.comment("Damaged dealt to players when Tesla Coil is fired (in half hearts).").defineInRange("tesla_coil_hurt_player", 2, 0, Integer.MAX_VALUE);
        TESLA_COIL_HURT_EFFECT_TIME_PLAYER = COMMON_BUILDER.comment("The duration of the Shocked effect for players (in ticks).").defineInRange("tesla_coil_effect_time_player", 20, 0, Integer.MAX_VALUE);
        TESLA_COIL_HURT_FIRE_COOLDOWN = COMMON_BUILDER.comment("Tesla Coil fire interval (in ticks).").defineInRange("tesla_coil_fire_cooldown", 20, 0, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Misc").push(CATAGORY_MISC);
        DIAMOND_GRIT_SANDPAPER_USES = COMMON_BUILDER.comment("Diamond Grit Sandpaper durability (number of uses).").defineInRange("diamond_grit_sandpaper_uses", 1024, 3, Integer.MAX_VALUE);
        BARBED_WIRE_DAMAGE = COMMON_BUILDER.comment("Barbed Wire Damage.").defineInRange("barbed_wire_damage", 2.0, 0.0, 3.4028234663852886E38);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

