/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public class TileEntityUtils
implements Module {
    public static final class_1792 EMPTY_ITEM = null;
    public static final class_1799 EMPTY_STACK = class_1799.field_8037;
    public final List<String> BLOCK_NAMES = StringUtils.newArrayList();
    public final List<String> ITEM_NAMES = StringUtils.newArrayList();
    private final List<String> BLOCK_CLASSES = StringUtils.newArrayList();
    private final List<String> ITEM_CLASSES = StringUtils.newArrayList();
    private final List<String> TILE_ENTITY_CLASSES = StringUtils.newArrayList();
    public boolean enabled = false;
    public List<String> TILE_ENTITY_NAMES = StringUtils.newArrayList();
    public Map<String, class_1799> TILE_ENTITY_RESOURCES = StringUtils.newHashMap();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private class_1799 CURRENT_MAIN_HAND_ITEM;
    private class_1799 CURRENT_OFFHAND_ITEM;
    private class_1799 CURRENT_HELMET;
    private class_1799 CURRENT_CHEST;
    private class_1799 CURRENT_LEGS;
    private class_1799 CURRENT_BOOTS;
    private String CURRENT_MAIN_HAND_ITEM_NAME;
    private String CURRENT_OFFHAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;

    public static class_1799 getStackFrom(Object data) {
        class_1799 itemStack = null;
        if (data != null) {
            if (data instanceof class_2248) {
                data = TileEntityUtils.getDefaultInstance((class_2248)data);
            }
            if (data instanceof class_1792) {
                data = TileEntityUtils.getDefaultInstance((class_1792)data);
            }
            if (data instanceof class_1799) {
                itemStack = (class_1799)data;
            }
        }
        return itemStack;
    }

    public static boolean isEmpty(Object data) {
        class_1799 itemStack = TileEntityUtils.getStackFrom(data);
        if (itemStack == null || itemStack.equals(EMPTY_STACK)) {
            return true;
        }
        if (itemStack.method_7909() != EMPTY_ITEM && itemStack.method_7909() != class_1802.field_8162) {
            if (itemStack.method_7947() <= 0) {
                return true;
            }
            return itemStack.method_7919() < Short.MIN_VALUE || itemStack.method_7919() > 65535;
        }
        return true;
    }

    public static class_1799 getDefaultInstance(class_2248 blockIn) {
        return new class_1799((class_1935)blockIn);
    }

    public static class_1799 getDefaultInstance(class_1792 itemIn) {
        return new class_1799((class_1935)itemIn);
    }

    public static String getName(Object data, boolean stripColors) {
        class_1799 itemStack = TileEntityUtils.getStackFrom(data);
        String result = "";
        if (!TileEntityUtils.isEmpty(itemStack)) {
            result = StringUtils.getOrDefault(itemStack.method_7964().getString());
        }
        if (stripColors) {
            result = StringUtils.stripColors(result);
        }
        return result;
    }

    public static String getName(Object entity) {
        return TileEntityUtils.getName(entity, true);
    }

    public static boolean isRawTE(String name) {
        if (!StringUtils.isNullOrEmpty(name)) {
            String lowerName = name.toLowerCase();
            return lowerName.contains("tile.") || lowerName.contains("item.") || lowerName.contains(".") || lowerName.contains(".name");
        }
        return false;
    }

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.TILE_ENTITY_NAMES.clear();
        this.TILE_ENTITY_CLASSES.clear();
        this.TILE_ENTITY_RESOURCES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_MAIN_HAND_ITEM = EMPTY_STACK;
        this.CURRENT_OFFHAND_ITEM = EMPTY_STACK;
        this.CURRENT_MAIN_HAND_ITEM_NAME = null;
        this.CURRENT_OFFHAND_ITEM_NAME = null;
        this.CURRENT_HELMET = EMPTY_STACK;
        this.CURRENT_CHEST = EMPTY_STACK;
        this.CURRENT_LEGS = EMPTY_STACK;
        this.CURRENT_BOOTS = EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("item", "data.item");
        CraftPresence.CLIENT.clearOverride("item.message", "item.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerItem : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        boolean hasBootsChanged;
        class_1799 NEW_CURRENT_MAIN_HAND_ITEM = CraftPresence.player.method_6047();
        class_1799 NEW_CURRENT_OFFHAND_ITEM = CraftPresence.player.method_6079();
        class_1799 NEW_CURRENT_HELMET = (class_1799)CraftPresence.player.method_31548().field_7548.get(3);
        class_1799 NEW_CURRENT_CHEST = (class_1799)CraftPresence.player.method_31548().field_7548.get(2);
        class_1799 NEW_CURRENT_LEGS = (class_1799)CraftPresence.player.method_31548().field_7548.get(1);
        class_1799 NEW_CURRENT_BOOTS = (class_1799)CraftPresence.player.method_31548().field_7548.get(0);
        boolean hasMainHandChanged = NEW_CURRENT_MAIN_HAND_ITEM != this.CURRENT_MAIN_HAND_ITEM;
        boolean hasOffHandChanged = NEW_CURRENT_OFFHAND_ITEM != this.CURRENT_OFFHAND_ITEM;
        boolean hasHelmetChanged = NEW_CURRENT_HELMET != this.CURRENT_HELMET;
        boolean hasChestChanged = NEW_CURRENT_CHEST != this.CURRENT_CHEST;
        boolean hasLegsChanged = NEW_CURRENT_LEGS != this.CURRENT_LEGS;
        boolean bl = hasBootsChanged = NEW_CURRENT_BOOTS != this.CURRENT_BOOTS;
        if (hasMainHandChanged) {
            this.CURRENT_MAIN_HAND_ITEM = NEW_CURRENT_MAIN_HAND_ITEM;
            this.CURRENT_MAIN_HAND_ITEM_NAME = TileEntityUtils.getName(this.CURRENT_MAIN_HAND_ITEM);
            if (!TileEntityUtils.isEmpty(this.CURRENT_MAIN_HAND_ITEM)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.main_hand.time");
            }
        }
        if (hasOffHandChanged) {
            this.CURRENT_OFFHAND_ITEM = NEW_CURRENT_OFFHAND_ITEM;
            this.CURRENT_OFFHAND_ITEM_NAME = TileEntityUtils.getName(this.CURRENT_OFFHAND_ITEM);
            if (!TileEntityUtils.isEmpty(this.CURRENT_OFFHAND_ITEM)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.off_hand.time");
            }
        }
        if (hasHelmetChanged) {
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_HELMET_NAME = TileEntityUtils.getName(this.CURRENT_HELMET);
            if (!TileEntityUtils.isEmpty(this.CURRENT_HELMET)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.helmet.time");
            }
        }
        if (hasChestChanged) {
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_CHEST_NAME = TileEntityUtils.getName(this.CURRENT_CHEST);
            if (!TileEntityUtils.isEmpty(this.CURRENT_CHEST)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.chestplate.time");
            }
        }
        if (hasLegsChanged) {
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_LEGS_NAME = TileEntityUtils.getName(this.CURRENT_LEGS);
            if (!TileEntityUtils.isEmpty(this.CURRENT_LEGS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.leggings.time");
            }
        }
        if (hasBootsChanged) {
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_BOOTS_NAME = TileEntityUtils.getName(this.CURRENT_BOOTS);
            if (!TileEntityUtils.isEmpty(this.CURRENT_BOOTS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.boots.time");
            }
        }
        if (hasMainHandChanged || hasOffHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        String defaultItemMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault("default", "");
        String offHandItemMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_OFFHAND_ITEM_NAME, this.CURRENT_OFFHAND_ITEM_NAME);
        String mainItemMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_MAIN_HAND_ITEM_NAME, this.CURRENT_MAIN_HAND_ITEM_NAME);
        String helmetMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_HELMET_NAME, this.CURRENT_HELMET_NAME);
        String chestMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_CHEST_NAME, this.CURRENT_CHEST_NAME);
        String legsMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_LEGS_NAME, this.CURRENT_LEGS_NAME);
        String bootsMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_BOOTS_NAME, this.CURRENT_BOOTS_NAME);
        CraftPresence.CLIENT.syncArgument("item.message.default", defaultItemMessage);
        CraftPresence.CLIENT.syncArgument("item.message.holding", String.format("[%s, %s]", StringUtils.getOrDefault(this.CURRENT_MAIN_HAND_ITEM_NAME, "N/A"), StringUtils.getOrDefault(this.CURRENT_OFFHAND_ITEM_NAME, "N/A")), true);
        CraftPresence.CLIENT.syncArgument("item.message.equipped", String.format("[%s, %s, %s, %s]", StringUtils.getOrDefault(this.CURRENT_HELMET_NAME, "N/A"), StringUtils.getOrDefault(this.CURRENT_CHEST_NAME, "N/A"), StringUtils.getOrDefault(this.CURRENT_LEGS_NAME, "N/A"), StringUtils.getOrDefault(this.CURRENT_BOOTS_NAME, "N/A")), true);
        if (!TileEntityUtils.isEmpty(this.CURRENT_MAIN_HAND_ITEM)) {
            CraftPresence.CLIENT.syncArgument("data.item.main_hand.instance", this.CURRENT_MAIN_HAND_ITEM);
            CraftPresence.CLIENT.syncArgument("data.item.main_hand.class", this.CURRENT_MAIN_HAND_ITEM.getClass());
            CraftPresence.CLIENT.syncArgument("item.main_hand.name", this.CURRENT_MAIN_HAND_ITEM_NAME);
            CraftPresence.CLIENT.syncArgument("item.main_hand.message", mainItemMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.main_hand", "data.item.main_hand");
        }
        if (!TileEntityUtils.isEmpty(this.CURRENT_OFFHAND_ITEM)) {
            CraftPresence.CLIENT.syncArgument("data.item.off_hand.instance", this.CURRENT_OFFHAND_ITEM);
            CraftPresence.CLIENT.syncArgument("data.item.off_hand.class", this.CURRENT_OFFHAND_ITEM.getClass());
            CraftPresence.CLIENT.syncArgument("item.off_hand.name", this.CURRENT_OFFHAND_ITEM_NAME);
            CraftPresence.CLIENT.syncArgument("item.off_hand.message", offHandItemMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.off_hand", "data.item.off_hand");
        }
        if (!TileEntityUtils.isEmpty(this.CURRENT_HELMET)) {
            CraftPresence.CLIENT.syncArgument("data.item.helmet.instance", this.CURRENT_HELMET);
            CraftPresence.CLIENT.syncArgument("data.item.helmet.class", this.CURRENT_HELMET.getClass());
            CraftPresence.CLIENT.syncArgument("item.helmet.name", this.CURRENT_HELMET_NAME);
            CraftPresence.CLIENT.syncArgument("item.helmet.message", helmetMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.helmet", "data.item.helmet");
        }
        if (!TileEntityUtils.isEmpty(this.CURRENT_CHEST)) {
            CraftPresence.CLIENT.syncArgument("data.item.chestplate.instance", this.CURRENT_CHEST);
            CraftPresence.CLIENT.syncArgument("data.item.chestplate.class", this.CURRENT_CHEST.getClass());
            CraftPresence.CLIENT.syncArgument("item.chestplate.name", this.CURRENT_CHEST_NAME);
            CraftPresence.CLIENT.syncArgument("item.chestplate.message", chestMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.chestplate", "data.item.chestplate");
        }
        if (!TileEntityUtils.isEmpty(this.CURRENT_LEGS)) {
            CraftPresence.CLIENT.syncArgument("data.item.leggings.instance", this.CURRENT_LEGS);
            CraftPresence.CLIENT.syncArgument("data.item.leggings.class", this.CURRENT_LEGS.getClass());
            CraftPresence.CLIENT.syncArgument("item.leggings.name", this.CURRENT_LEGS_NAME);
            CraftPresence.CLIENT.syncArgument("item.leggings.message", legsMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.leggings", "data.item.leggings");
        }
        if (!TileEntityUtils.isEmpty(this.CURRENT_BOOTS)) {
            CraftPresence.CLIENT.syncArgument("data.item.boots.instance", this.CURRENT_BOOTS);
            CraftPresence.CLIENT.syncArgument("data.item.boots.class", this.CURRENT_BOOTS.getClass());
            CraftPresence.CLIENT.syncArgument("item.boots.name", this.CURRENT_BOOTS_NAME);
            CraftPresence.CLIENT.syncArgument("item.boots.message", bootsMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.boots", "data.item.boots");
        }
    }

    @Override
    public void getAllData() {
        class_1799 stack;
        List<class_2248> defaultBlocks = StringUtils.newArrayList(class_7923.field_41175.iterator());
        List<class_1792> defaultItems = StringUtils.newArrayList(class_7923.field_41178.iterator());
        for (class_2248 block : defaultBlocks) {
            if (TileEntityUtils.isEmpty(block)) continue;
            stack = TileEntityUtils.getStackFrom(block);
            String blockName = TileEntityUtils.getName(stack);
            if (!this.BLOCK_NAMES.contains(blockName)) {
                this.BLOCK_NAMES.add(blockName);
            }
            if (!this.BLOCK_CLASSES.contains(block.getClass().getName())) {
                this.BLOCK_CLASSES.add(block.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(blockName)) continue;
            this.TILE_ENTITY_RESOURCES.put(blockName, stack);
        }
        for (class_1792 item : defaultItems) {
            if (TileEntityUtils.isEmpty(item)) continue;
            stack = TileEntityUtils.getStackFrom(item);
            String itemName = TileEntityUtils.getName(stack);
            if (!this.ITEM_NAMES.contains(itemName)) {
                this.ITEM_NAMES.add(itemName);
            }
            if (!this.ITEM_CLASSES.contains(item.getClass().getName())) {
                this.ITEM_CLASSES.add(item.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(itemName)) continue;
            this.TILE_ENTITY_RESOURCES.put(itemName, stack);
        }
        for (String itemEntry : CraftPresence.CONFIG.advancedSettings.itemMessages.keySet()) {
            if (StringUtils.isNullOrEmpty(itemEntry)) continue;
            if (!this.ITEM_NAMES.contains(itemEntry)) {
                this.ITEM_NAMES.add(itemEntry);
            }
            if (this.BLOCK_NAMES.contains(itemEntry)) continue;
            this.BLOCK_NAMES.add(itemEntry);
        }
        this.verifyEntities();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    public void verifyEntities() {
        for (String item : StringUtils.newArrayList(this.ITEM_NAMES)) {
            if (!TileEntityUtils.isRawTE(item)) continue;
            this.ITEM_NAMES.remove(item);
            if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item)) continue;
            this.ITEM_NAMES.add(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]));
        }
        for (String item : StringUtils.newArrayList(this.BLOCK_NAMES)) {
            if (!TileEntityUtils.isRawTE(item)) continue;
            this.BLOCK_NAMES.remove(item);
            if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item)) continue;
            this.BLOCK_NAMES.add(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]));
        }
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.BLOCK_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.ITEM_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.BLOCK_CLASSES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.ITEM_CLASSES);
    }
}

