/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Accessibility;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.ColorEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ControlsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;

public class AccessibilitySettingsGui
extends ConfigurationGui<Accessibility> {
    private final Accessibility INSTANCE;
    private final Accessibility DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedTextControl languageIdText;
    private CheckBoxControl stripTranslationColorsButton;
    private CheckBoxControl stripExtraGuiElementsButton;
    private CheckBoxControl renderTooltipsButton;
    private ExtendedButtonControl controlsButton;

    AccessibilitySettingsGui(Screen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.accessibility");
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(0), 180, 20, "gui.config.name.accessibility.tooltip_background_color", () -> this.openScreen(new ColorEditorGui(this.currentScreen, this.getCurrentData().tooltipBackground, this.DEFAULTS.tooltipBackground, () -> Config.loadOrCreate().accessibilitySettings.tooltipBackground)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.tooltip_background_color", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(0), 180, 20, "gui.config.name.accessibility.tooltip_border_color", () -> this.openScreen(new ColorEditorGui(this.currentScreen, this.getCurrentData().tooltipBorder, this.DEFAULTS.tooltipBorder, () -> Config.loadOrCreate().accessibilitySettings.tooltipBorder)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.tooltip_border_color", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(1), 180, 20, "gui.config.name.accessibility.gui_background_color", () -> this.openScreen(new ColorEditorGui(this.currentScreen, this.getCurrentData().guiBackground, this.DEFAULTS.guiBackground, () -> Config.loadOrCreate().accessibilitySettings.guiBackground)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.gui_background_color", new Object[0]))), new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(1), 180, 20, "gui.config.name.accessibility.world_gui_background_color", () -> this.openScreen(new ColorEditorGui(this.currentScreen, this.getCurrentData().worldGuiBackground, this.DEFAULTS.worldGuiBackground, () -> Config.loadOrCreate().accessibilitySettings.worldGuiBackground)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.world_gui_background_color", new Object[0]))), new String[0]));
        this.languageIdText = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(2), 180, 20, "gui.config.name.accessibility.language_id", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.language_id", new Object[0])))));
        this.languageIdText.setControlMessage(this.getCurrentData().languageId);
        this.stripTranslationColorsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(3), "gui.config.name.accessibility.strip_translation_colors", this.getCurrentData().stripTranslationColors, null, () -> {
            if (this.stripTranslationColorsButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_translation_colors", new Object[0])));
            } else if (ModUtils.IS_TEXT_COLORS_BLOCKED) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("craftpresence.message.unsupported", new Object[0])));
            }
        }));
        this.stripExtraGuiElementsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(4, -10), "gui.config.name.accessibility.strip_extra_gui_elements", this.getCurrentData().stripExtraGuiElements, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.strip_extra_gui_elements", new Object[0])))));
        this.renderTooltipsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(5, -20), "gui.config.name.accessibility.render_tooltips", this.getCurrentData().renderTooltips, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.accessibility.render_tooltips", new Object[0])))));
        List<String> controlInfo = StringUtils.newArrayList("key.craftpresence.category");
        KeyUtils.FilterMode controlMode = KeyUtils.FilterMode.Category;
        if (Constants.IS_LEGACY_SOFT) {
            controlInfo.clear();
            StringUtils.addEntriesNotPresent(controlInfo, CraftPresence.KEYBINDINGS.getRawKeyMappings().keySet());
            controlMode = KeyUtils.FilterMode.Name;
        }
        KeyUtils.FilterMode finalControlMode = controlMode;
        this.controlsButton = this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(3, 4), 180, 20, "gui.config.message.button.controls", () -> this.openScreen(new ControlsGui(this.currentScreen, finalControlMode, controlInfo)), new String[0]));
    }

    @Override
    protected boolean canReset() {
        return !this.getCurrentData().equals(this.DEFAULTS);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.DEFAULTS);
    }

    @Override
    protected boolean canSync() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean syncData() {
        return this.setCurrentData(Config.loadOrCreate().accessibilitySettings);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.stripTranslationColorsButton.setControlEnabled(!ModUtils.IS_TEXT_COLORS_BLOCKED);
        this.controlsButton.setControlEnabled(CraftPresence.KEYBINDINGS.areKeysRegistered());
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.languageIdText.getControlMessage()));
    }

    @Override
    protected void applySettings() {
        if (!this.languageIdText.getControlMessage().equals(this.getCurrentData().languageId)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().languageId = this.languageIdText.getControlMessage();
        }
        if (this.stripTranslationColorsButton.isChecked() != this.getCurrentData().stripTranslationColors) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().stripTranslationColors = this.stripTranslationColorsButton.isChecked();
        }
        if (this.stripExtraGuiElementsButton.isChecked() != this.getCurrentData().stripExtraGuiElements) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().stripExtraGuiElements = this.stripExtraGuiElementsButton.isChecked();
        }
        if (this.renderTooltipsButton.isChecked() != this.getCurrentData().renderTooltips) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().renderTooltips = this.renderTooltipsButton.isChecked();
        }
    }

    @Override
    protected Accessibility getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected Accessibility getCurrentData() {
        return CraftPresence.CONFIG.accessibilitySettings;
    }

    @Override
    protected boolean setCurrentData(Accessibility data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

