/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class SliderControl
extends ExtendedButtonControl {
    private final float minValue;
    private final float maxValue;
    private final float valueStep;
    private final String windowTitle;
    private float sliderValue;
    private float denormalizedSlideValue;
    private Runnable onSlideEvent;

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        super(buttonId, (int)positionData.getFirst(), (int)positionData.getSecond(), (int)dimensions.getFirst(), (int)dimensions.getSecond(), "", new String[0]);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        this.windowTitle = displayString;
        this.setSliderValue(startValue);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        this(ExtendedScreen.getNextIndex(), positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Tuple<Runnable, Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>(events.getFirst(), events.getSecond()));
        this.setOnSlide(events.getThird());
    }

    @Override
    protected int getYImage(boolean mouseOver) {
        return 0;
    }

    @Override
    protected void renderBg(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            super.renderBg(matrixStack, mc, mouseX, mouseY);
            int hoverState = super.getYImage(this.isHoveringOrFocusingOver());
            int hoverValue = 46 + hoverState * 20;
            RenderUtils.renderButton(mc, this.getControlPosX() + (int)(this.sliderValue * (float)(this.getControlWidth() - 8)), this.getControlPosY(), 0, hoverValue, 196, hoverValue, 4, 20, this.getZLevel(), RenderUtils.getButtonTextures());
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (super.m_93680_(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
        }
    }

    public boolean m_7933_(int keyCode, int mouseX, int mouseY) {
        boolean bl;
        boolean bl2 = bl = keyCode == 263;
        if (bl || keyCode == 262) {
            float f = bl ? -this.valueStep : this.valueStep;
            this.setSliderValue(this.getSliderValue() + f);
            this.m_5691_();
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((float)(mouseX - (double)(this.getControlPosX() + 4)) / (float)(this.getControlWidth() - 8), true);
    }

    public void setSliderValue(float newValue, boolean useNormal) {
        if (useNormal) {
            this.sliderValue = MathUtils.clamp(newValue, 0.0f, 1.0f);
            this.denormalizedSlideValue = MathUtils.denormalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
        } else {
            this.sliderValue = MathUtils.normalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
            this.denormalizedSlideValue = MathUtils.clamp(newValue, this.minValue, this.maxValue);
        }
        this.onSlide();
    }

    public float getSliderValue(boolean useNormal) {
        return useNormal ? this.sliderValue : this.denormalizedSlideValue;
    }

    public float getSliderValue() {
        return this.getSliderValue(false);
    }

    public void setSliderValue(float newValue) {
        this.setSliderValue(newValue, false);
    }

    protected void m_7212_(double mX, double mY, double dragX, double dragY) {
        this.setValueFromMouse(mX);
        super.m_7212_(mX, mY, dragX, dragY);
    }

    public void setOnSlide(Runnable event) {
        this.onSlideEvent = event;
    }

    public void onSlide() {
        if (this.onSlideEvent != null) {
            this.onSlideEvent.run();
        }
        this.setControlMessage(this.windowTitle + ": " + this.denormalizedSlideValue);
    }
}

