/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.utils.MappingUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeUtils
implements Module {
    public boolean enabled = false;
    public List<String> BIOME_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String CURRENT_BIOME_NAME;
    private String CURRENT_BIOME_IDENTIFIER;
    private Biome CURRENT_BIOME;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.DEFAULT_NAMES.clear();
        this.BIOME_NAMES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_BIOME = null;
        this.CURRENT_BIOME_NAME = null;
        this.CURRENT_BIOME_IDENTIFIER = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("biome", "data.biome");
        CraftPresence.CLIENT.clearOverride("biome.message", "biome.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.generalSettings.detectBiomeData : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        String newBiomeName;
        Biome newBiome = (Biome)CraftPresence.player.m_9236_().m_204166_(CraftPresence.player.m_20183_()).m_203334_();
        ResourceLocation newIdentifier = CraftPresence.player.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)newBiome);
        String string = newIdentifier != null ? StringUtils.formatIdentifier(newIdentifier.toString(), false, !CraftPresence.CONFIG.advancedSettings.formatWords) : (newBiomeName = "Plains");
        String newBiome_primaryIdentifier = newIdentifier != null ? StringUtils.formatIdentifier(newIdentifier.toString(), true, !CraftPresence.CONFIG.advancedSettings.formatWords) : "plains";
        String newBiome_alternativeIdentifier = StringUtils.formatIdentifier(MappingUtils.getClassName(newBiome), true, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newBiome_Identifier = StringUtils.getOrDefault(newBiome_primaryIdentifier, newBiome_alternativeIdentifier);
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME) || !newBiome_Identifier.equals(this.CURRENT_BIOME_IDENTIFIER)) {
            this.CURRENT_BIOME = newBiome;
            this.CURRENT_BIOME_NAME = StringUtils.getOrDefault(newBiomeName, newBiome_Identifier);
            this.CURRENT_BIOME_IDENTIFIER = newBiome_Identifier;
            if (!this.DEFAULT_NAMES.contains(newBiome_Identifier)) {
                this.DEFAULT_NAMES.add(newBiome_Identifier);
            }
            if (!this.BIOME_NAMES.contains(newBiome_Identifier)) {
                this.BIOME_NAMES.add(newBiome_Identifier);
            }
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        ModuleData defaultData = CraftPresence.CONFIG.biomeSettings.biomeData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.biomeSettings.biomeData.get(this.CURRENT_BIOME_IDENTIFIER);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_BIOME_IDENTIFIER;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("biome.icon", true, currentIcon, CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon);
        CraftPresence.CLIENT.syncArgument("biome.default.icon", CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon);
        CraftPresence.CLIENT.syncArgument("data.biome.instance", this.CURRENT_BIOME);
        CraftPresence.CLIENT.syncArgument("data.biome.class", this.CURRENT_BIOME.getClass());
        CraftPresence.CLIENT.syncArgument("biome.name", this.CURRENT_BIOME_NAME);
        CraftPresence.CLIENT.syncOverride(currentData != null ? currentData : defaultData, "biome.message", "biome.icon");
        CraftPresence.CLIENT.syncArgument("biome.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("biome.icon", formattedIcon);
        CraftPresence.CLIENT.syncTimestamp("data.biome.time");
    }

    private List<ResourceLocation> getBiomeTypes() {
        List<Holder.Reference> defaultBiomeTypes;
        List<ResourceLocation> biomeTypes = StringUtils.newArrayList();
        Optional biomeRegistry = VanillaRegistries.m_255371_().m_254861_(Registries.f_256952_);
        if (biomeRegistry.isPresent() && !(defaultBiomeTypes = StringUtils.newArrayList(((HolderLookup.RegistryLookup)biomeRegistry.get()).m_214062_().toList())).isEmpty()) {
            for (Holder.Reference type : defaultBiomeTypes) {
                if (type == null) continue;
                biomeTypes.add(type.m_205785_().m_135782_());
            }
        }
        return biomeTypes;
    }

    @Override
    public void getAllData() {
        String name;
        for (ResourceLocation TYPE : this.getBiomeTypes()) {
            if (TYPE == null) continue;
            name = StringUtils.formatIdentifier(TYPE.toString(), true, !CraftPresence.CONFIG.advancedSettings.formatWords);
            if (!this.DEFAULT_NAMES.contains(name)) {
                this.DEFAULT_NAMES.add(name);
            }
            if (this.BIOME_NAMES.contains(name)) continue;
            this.BIOME_NAMES.add(name);
        }
        for (String biomeEntry : CraftPresence.CONFIG.biomeSettings.biomeData.keySet()) {
            if (StringUtils.isNullOrEmpty(biomeEntry) || this.BIOME_NAMES.contains(name = StringUtils.formatIdentifier(biomeEntry, true, !CraftPresence.CONFIG.advancedSettings.formatWords))) continue;
            this.BIOME_NAMES.add(name);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

