/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReforgeDataLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"TieredZ");
    private List<class_2960> reforgeIdentifiers = new ArrayList<class_2960>();
    private Map<class_2960, List<class_1799>> reforgeBaseMap = new HashMap<class_2960, List<class_1799>>();

    public class_2960 getFabricId() {
        return new class_2960("tiered", "reforge_loader");
    }

    public void method_14491(class_3300 resourceManager) {
        resourceManager.method_14488("reforge_items", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                for (int u = 0; u < data.getAsJsonArray("items").size(); ++u) {
                    ArrayList<class_1799> baseStacks = new ArrayList<class_1799>();
                    for (int i = 0; i < data.getAsJsonArray("base").size(); ++i) {
                        if (((class_1792)class_7923.field_41178.method_10223(new class_2960(data.getAsJsonArray("base").get(i).getAsString()))).toString().equals("air")) {
                            LOGGER.info("Resource {} was not loaded cause {} is not a valid item identifier", (Object)id.toString(), (Object)data.getAsJsonArray("base").get(i).getAsString());
                            continue;
                        }
                        baseStacks.add(((class_1792)class_7923.field_41178.method_10223(new class_2960(data.getAsJsonArray("base").get(i).getAsString()))).method_7854());
                    }
                    if (((class_1792)class_7923.field_41178.method_10223(new class_2960(data.getAsJsonArray("items").get(u).getAsString()))).toString().equals("air")) {
                        LOGGER.info("Resource {} was not loaded cause {} is not a valid item identifier", (Object)id.toString(), (Object)data.getAsJsonArray("items").get(u).getAsString());
                        continue;
                    }
                    this.reforgeIdentifiers.add(new class_2960(data.getAsJsonArray("items").get(u).getAsString()));
                    this.reforgeBaseMap.put(new class_2960(data.getAsJsonArray("items").get(u).getAsString()), baseStacks);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
    }

    public List<class_1799> getReforgeBaseItemStacks(class_1792 item) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (this.reforgeBaseMap.containsKey(class_7923.field_41178.method_10221((Object)item))) {
            return this.reforgeBaseMap.get(class_7923.field_41178.method_10221((Object)item));
        }
        return list;
    }

    public void putReforgeBaseItemStacks(class_2960 id, List<class_1799> stacks) {
        this.reforgeBaseMap.put(id, stacks);
    }

    public void clearReforgeBaseItemStacks() {
        this.reforgeBaseMap.clear();
    }

    public List<class_2960> getReforgeIdentifiers() {
        return this.reforgeIdentifiers;
    }
}

