/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.event.core;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.impl.core.CommonFactories;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class EventInvokerImpl {
    private static final Map<Class<?>, EventInvokerLike<?>> EVENT_INVOKER_LOOKUP = Collections.synchronizedMap(Maps.newIdentityHashMap());

    private EventInvokerImpl() {
    }

    public static <T> EventInvoker<T> lookup(Class<T> clazz, @Nullable Object context) {
        Objects.requireNonNull(clazz, "type is null");
        EventInvokerLike<?> invokerLike = EVENT_INVOKER_LOOKUP.get(clazz);
        Objects.requireNonNull(invokerLike, "invoker for type %s is null".formatted(clazz));
        EventInvoker<?> invoker = invokerLike.asEventInvoker(context);
        Objects.requireNonNull(invoker, "invoker for type %s is null".formatted(clazz));
        return invoker;
    }

    public static <T> void register(Class<T> clazz, EventInvokerLike<T> invoker, boolean joinInvokers) {
        EventInvokerLike<?> other = EVENT_INVOKER_LOOKUP.get(clazz);
        if (other != null) {
            if (joinInvokers) {
                invoker = EventInvokerImpl.join(invoker, other);
            } else {
                throw new IllegalArgumentException("duplicate event invoker for type %s".formatted(clazz));
            }
        }
        EVENT_INVOKER_LOOKUP.put(clazz, invoker);
    }

    private static <T> EventInvokerLike<T> join(EventInvokerLike<T> invoker, EventInvokerLike<T> other) {
        return context -> (phase, callback) -> {
            invoker.asEventInvoker(context).register(phase, callback);
            other.asEventInvoker(context).register(phase, callback);
        };
    }

    static {
        CommonFactories.INSTANCE.registerEventInvokers();
    }

    public static interface EventInvokerLike<T> {
        public EventInvoker<T> asEventInvoker(@Nullable Object var1);
    }
}

