/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades;

import com.google.common.collect.ImmutableSet;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import io.github.prismwork.emitrades.config.EMITradesConfig;
import io.github.prismwork.emitrades.recipe.VillagerTrade;
import io.github.prismwork.emitrades.util.EntityEmiStack;
import io.github.prismwork.emitrades.util.TradeProfile;
import io.github.prismwork.emitrades.util.XPlatUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3988;
import net.minecraft.class_3989;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EmiEntrypoint
public class EMITradesPlugin
implements EmiPlugin {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"EMI Trades");
    public static final class_3852 WANDERING_TRADER_PLACEHOLDER = new class_3852("wandering_trader", entry -> false, entry -> false, ImmutableSet.builder().build(), ImmutableSet.builder().build(), class_3417.field_17752);
    public static final EmiRecipeCategory VILLAGER_TRADES = new EmiRecipeCategory(new class_2960("emitrades", "villager_trades"), (EmiRenderable)EmiStack.of((class_1935)class_1802.field_8687));
    public static EMITradesConfig.Config CONFIG;
    private static final File CONFIG_FILE;

    public void register(EmiRegistry registry) {
        CONFIG = EMITradesConfig.load(CONFIG_FILE);
        registry.addCategory(VILLAGER_TRADES);
        class_5819 random = class_5819.method_43047();
        for (class_3852 profession : class_7923.field_41195) {
            class_1646 villager = (class_1646)((class_1299)class_7923.field_41177.method_10223(new class_2960("minecraft", "villager"))).method_5883((class_1937)class_310.method_1551().field_1687);
            if (villager != null) {
                villager.method_7195(villager.method_7231().method_16921(profession).method_16920(5));
                registry.addWorkstation(VILLAGER_TRADES, (EmiIngredient)EntityEmiStack.ofScaled((class_1297)villager, 8.0f));
            }
            AtomicInteger id = new AtomicInteger();
            Int2ObjectMap offers2 = (Int2ObjectMap)class_3853.field_17067.get(profession);
            if (offers2 == null || offers2.isEmpty()) continue;
            for (int level = 0; level < 5; ++level) {
                class_1646 villager1 = (class_1646)((class_1299)class_7923.field_41177.method_10223(new class_2960("minecraft", "villager"))).method_5883((class_1937)class_310.method_1551().field_1687);
                if (villager1 != null) {
                    villager1.method_7195(villager1.method_7231().method_16921(profession).method_16920(level + 1));
                }
                for (class_3853.class_1652 offer : (class_3853.class_1652[])offers2.get(level + 1)) {
                    if (EMITradesPlugin.isVanillaFactory(offer)) {
                        registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(profession, offer, level + 1, (class_3988)villager1), id.get()));
                        id.getAndIncrement();
                        continue;
                    }
                    try {
                        int attempts = 5;
                        TreeSet<class_1914> genOffers = new TreeSet<class_1914>(this::compareOffers);
                        while (attempts > 0) {
                            class_1914 inOffer = offer.method_7246((class_1297)class_310.method_1551().field_1724, random);
                            if (genOffers.add(inOffer)) {
                                ++attempts;
                                continue;
                            }
                            --attempts;
                        }
                        int finalLevel = level;
                        genOffers.forEach(tradeOffer -> {
                            registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(profession, new FakeFactory((class_1914)tradeOffer), finalLevel + 1, (class_3988)villager1), id.get()));
                            id.getAndIncrement();
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        class_3989 wanderingTrader = (class_3989)((class_1299)class_7923.field_41177.method_10223(new class_2960("minecraft", "wandering_trader"))).method_5883((class_1937)class_310.method_1551().field_1687);
        registry.addWorkstation(VILLAGER_TRADES, (EmiIngredient)EntityEmiStack.of((class_1297)wanderingTrader));
        AtomicInteger wanderingTraderId = new AtomicInteger();
        class_3853.field_17724.forEach((lvl, offers) -> {
            for (class_3853.class_1652 offer : offers) {
                if (EMITradesPlugin.isVanillaFactory(offer)) {
                    registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(WANDERING_TRADER_PLACEHOLDER, offer, (int)lvl, (class_3988)wanderingTrader), wanderingTraderId.get()));
                    wanderingTraderId.getAndIncrement();
                    continue;
                }
                try {
                    int attempts = 5;
                    TreeSet<class_1914> genOffers = new TreeSet<class_1914>(this::compareOffers);
                    while (attempts > 0) {
                        class_1914 inOffer = offer.method_7246((class_1297)class_310.method_1551().field_1724, random);
                        if (genOffers.add(inOffer)) {
                            ++attempts;
                            continue;
                        }
                        --attempts;
                    }
                    int finalLevel = lvl;
                    genOffers.forEach(tradeOffer -> {
                        registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(WANDERING_TRADER_PLACEHOLDER, new FakeFactory((class_1914)tradeOffer), finalLevel, (class_3988)wanderingTrader), wanderingTraderId.get()));
                        wanderingTraderId.getAndIncrement();
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        LOGGER.info("Reloaded.");
    }

    private static boolean isVanillaFactory(class_3853.class_1652 offer) {
        return offer instanceof class_3853.class_4166 || offer instanceof class_3853.class_4163 || offer instanceof class_3853.class_1648 || offer instanceof class_3853.class_1654 || offer instanceof class_3853.class_4167 || offer instanceof class_3853.class_4160 || offer instanceof class_3853.class_4162 || offer instanceof class_3853.class_4165 || offer instanceof class_3853.class_4161 || offer instanceof class_3853.class_4164;
    }

    private int compareOffers(@NotNull class_1914 a, @NotNull class_1914 b) {
        int diff = class_7923.field_41178.method_10206((Object)a.method_8246().method_7909()) - class_7923.field_41178.method_10206((Object)b.method_8246().method_7909());
        if (diff != 0) {
            return diff;
        }
        diff = class_7923.field_41178.method_10206((Object)a.method_8247().method_7909()) - class_7923.field_41178.method_10206((Object)b.method_8247().method_7909());
        if (diff != 0) {
            return diff;
        }
        diff = class_7923.field_41178.method_10206((Object)a.method_8250().method_7909()) - class_7923.field_41178.method_10206((Object)b.method_8250().method_7909());
        return diff;
    }

    static {
        CONFIG_FILE = XPlatUtils.getConfigPath().resolve("emitrades.json5").toFile();
    }

    @ApiStatus.Internal
    public static class FakeFactory
    implements class_3853.class_1652 {
        public final class_1799 first;
        public final class_1799 second;
        public final class_1799 sell;

        public FakeFactory(class_1914 offer) {
            this.first = offer.method_8246();
            this.second = offer.method_8247();
            this.sell = offer.method_8250();
        }

        @Nullable
        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            throw new AssertionError((Object)"Nobody should use this");
        }
    }
}

