/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.shader.ShaderCompileException;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.pipeline.ShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class FinalPassRenderer {
    private final RenderTargets renderTargets;
    @Nullable
    private final Pass finalPass;
    private final ImmutableList<SwapPass> swapPasses;
    private final GlFramebuffer baseline;
    private final GlFramebuffer colorHolder;
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures;
    private final Set<GlImage> customImages;
    private int lastColorTextureId;
    private int lastColorTextureVersion;
    private final TextureAccess noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final Object2ObjectMap<String, TextureAccess> customTextureIds;
    private WorldRenderingPipeline pipeline;
    private final CustomUniforms customUniforms;

    public FinalPassRenderer(WorldRenderingPipeline worldRenderingPipeline, ProgramSet programSet, RenderTargets renderTargets, TextureAccess textureAccess, FrameUpdateNotifier frameUpdateNotifier, ImmutableSet<Integer> immutableSet, CenterDepthSampler centerDepthSampler, Supplier<ShadowRenderTargets> supplier, Object2ObjectMap<String, TextureAccess> object2ObjectMap, Object2ObjectMap<String, TextureAccess> object2ObjectMap2, Set<GlImage> set, ImmutableSet<Integer> immutableSet2, CustomUniforms customUniforms) {
        this.pipeline = worldRenderingPipeline;
        this.updateNotifier = frameUpdateNotifier;
        this.centerDepthSampler = centerDepthSampler;
        this.customTextureIds = object2ObjectMap;
        this.irisCustomTextures = object2ObjectMap2;
        this.customImages = set;
        PackRenderTargetDirectives packRenderTargetDirectives = programSet.getPackDirectives().getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> map = packRenderTargetDirectives.getRenderTargetSettings();
        this.noiseTexture = textureAccess;
        this.renderTargets = renderTargets;
        this.customUniforms = customUniforms;
        this.finalPass = programSet.getCompositeFinal().map(programSource -> {
            Pass pass = new Pass();
            ProgramDirectives programDirectives = programSource.getDirectives();
            pass.program = this.createProgram((ProgramSource)programSource, immutableSet, immutableSet2, supplier);
            pass.computes = this.createComputes(programSet.getFinalCompute(), immutableSet, immutableSet2, supplier);
            pass.stageReadsFromAlt = immutableSet;
            pass.mipmappedBuffers = programDirectives.getMipmappedBuffers();
            return pass;
        }).orElse(null);
        IntList intList = programSet.getPackDirectives().getRenderTargetDirectives().getBuffersToBeCleared();
        this.baseline = renderTargets.createGbufferFramebuffer(immutableSet, new int[]{0});
        this.colorHolder = new GlFramebuffer();
        this.lastColorTextureId = class_310.method_1551().method_1522().method_30277();
        this.lastColorTextureVersion = ((Blaze3dRenderTargetExt)class_310.method_1551().method_1522()).iris$getColorBufferVersion();
        this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        ImmutableList.Builder builder = ImmutableList.builder();
        immutableSet.forEach(n -> {
            int n2 = n;
            if (intList.contains(n2)) {
                return;
            }
            SwapPass swapPass = new SwapPass();
            RenderTarget renderTarget = renderTargets.get(n2);
            swapPass.target = n2;
            swapPass.width = renderTarget.getWidth();
            swapPass.height = renderTarget.getHeight();
            swapPass.from = renderTargets.createColorFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{n2});
            swapPass.targetTexture = renderTargets.get(n2).getMainTexture();
            builder.add((Object)swapPass);
        });
        this.swapPasses = builder.build();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public void renderFinalPass() {
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)false);
        class_276 class_2762 = class_310.method_1551().method_1522();
        int n = class_2762.field_1482;
        int n2 = class_2762.field_1481;
        if (((Blaze3dRenderTargetExt)class_2762).iris$getColorBufferVersion() != this.lastColorTextureVersion || class_2762.method_30277() != this.lastColorTextureId) {
            this.lastColorTextureVersion = ((Blaze3dRenderTargetExt)class_2762).iris$getColorBufferVersion();
            this.lastColorTextureId = class_2762.method_30277();
            this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        }
        if (this.finalPass != null) {
            this.colorHolder.bind();
            FullScreenQuadRenderer.INSTANCE.begin();
            for (ComputeProgram computeProgram : this.finalPass.computes) {
                if (computeProgram == null) continue;
                computeProgram.use();
                this.customUniforms.push(computeProgram);
                computeProgram.dispatch(n, n2);
            }
            IrisRenderSystem.memoryBarrier(8232);
            if (!this.finalPass.mipmappedBuffers.isEmpty()) {
                RenderSystem.activeTexture((int)33984);
                UnmodifiableIterator unmodifiableIterator = this.finalPass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int n3 = (Integer)unmodifiableIterator.next();
                    FinalPassRenderer.setupMipmapping(this.renderTargets.get(n3), this.finalPass.stageReadsFromAlt.contains((Object)n3));
                }
            }
            this.finalPass.program.use();
            this.customUniforms.push(this.finalPass.program);
            FullScreenQuadRenderer.INSTANCE.renderQuad();
            FullScreenQuadRenderer.INSTANCE.end();
        } else {
            this.baseline.bindAsReadBuffer();
            IrisRenderSystem.copyTexSubImage2D(class_2762.method_30277(), 3553, 0, 0, 0, 0, 0, n, n2);
        }
        RenderSystem.activeTexture((int)33984);
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            FinalPassRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        for (SwapPass swapPass : this.swapPasses) {
            swapPass.from.bind();
            RenderSystem.bindTexture((int)swapPass.targetTexture);
            GlStateManager._glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)swapPass.width, (int)swapPass.height);
        }
        class_2762.method_1235(true);
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        GlStateManager._glUseProgram((int)0);
        for (int i = 0; i < SamplerLimits.get().getMaxTextureUnits(); ++i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        RenderSystem.activeTexture((int)33984);
    }

    public void recalculateSwapPassSize() {
        for (SwapPass swapPass : this.swapPasses) {
            RenderTarget renderTarget = this.renderTargets.get(swapPass.target);
            this.renderTargets.destroyFramebuffer(swapPass.from);
            swapPass.from = this.renderTargets.createColorFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{swapPass.target});
            swapPass.width = renderTarget.getWidth();
            swapPass.height = renderTarget.getHeight();
            swapPass.targetTexture = renderTarget.getMainTexture();
        }
    }

    private static void setupMipmapping(RenderTarget renderTarget, boolean bl) {
        int n = bl ? renderTarget.getAltTexture() : renderTarget.getMainTexture();
        IrisRenderSystem.generateMipmaps(n, 3553);
        int n2 = 9987;
        if (renderTarget.getInternalFormat().getPixelFormat().isInteger()) {
            n2 = 9984;
        }
        IrisRenderSystem.texParameteri(n, 3553, 10241, n2);
    }

    private static void resetRenderTarget(RenderTarget renderTarget) {
        int n = 9729;
        if (renderTarget.getInternalFormat().getPixelFormat().isInteger()) {
            n = 9728;
        }
        IrisRenderSystem.texParameteri(renderTarget.getMainTexture(), 3553, 10241, n);
        IrisRenderSystem.texParameteri(renderTarget.getAltTexture(), 3553, 10241, n);
        RenderSystem.bindTexture((int)0);
    }

    private Program createProgram(ProgramSource programSource, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, Supplier<ShadowRenderTargets> supplier) {
        ProgramBuilder programBuilder;
        Map<PatchShaderType, String> map = TransformPatcher.patchComposite(programSource.getName(), programSource.getVertexSource().orElseThrow(NullPointerException::new), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElseThrow(NullPointerException::new), TextureStage.COMPOSITE_AND_FINAL, this.pipeline.getTextureMap());
        String string = map.get((Object)PatchShaderType.VERTEX);
        String string2 = map.get((Object)PatchShaderType.GEOMETRY);
        String string3 = map.get((Object)PatchShaderType.FRAGMENT);
        ShaderPrinter.printProgram(programSource.getName()).addSources(map).print();
        Objects.requireNonNull(immutableSet);
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), string, string2, string3, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (ShaderCompileException shaderCompileException) {
            throw shaderCompileException;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed for final!", runtimeException);
        }
        CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
        this.customUniforms.assignTo(programBuilder);
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> immutableSet, this.renderTargets, true);
        IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
        IrisImages.addRenderTargetImages(programBuilder, () -> immutableSet, this.renderTargets);
        IrisImages.addCustomImages(programBuilder, this.customImages);
        IrisSamplers.addCustomTextures(programBuilder, this.irisCustomTextures);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, supplier.get(), null, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
            IrisImages.addShadowColorImages(programBuilder, supplier.get(), null);
        }
        this.centerDepthSampler.setUsage(programBuilder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth"));
        Program program = programBuilder.build();
        this.customUniforms.mapholderToPass(programBuilder, program);
        return program;
    }

    private ComputeProgram[] createComputes(ComputeSource[] computeSourceArray, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, Supplier<ShadowRenderTargets> supplier) {
        ComputeProgram[] computeProgramArray = new ComputeProgram[computeSourceArray.length];
        for (int i = 0; i < computeProgramArray.length; ++i) {
            ProgramBuilder programBuilder;
            Object object;
            ComputeSource computeSource = computeSourceArray[i];
            if (computeSource == null || !computeSource.getSource().isPresent()) continue;
            Objects.requireNonNull(immutableSet);
            try {
                object = TransformPatcher.patchCompute(computeSource.getName(), computeSource.getSource().orElse(null), TextureStage.COMPOSITE_AND_FINAL, this.pipeline.getTextureMap());
                ShaderPrinter.printProgram(computeSource.getName()).addSource(PatchShaderType.COMPUTE, (String)object).print();
                programBuilder = ProgramBuilder.beginCompute(computeSource.getName(), (String)object, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (ShaderCompileException shaderCompileException) {
                throw shaderCompileException;
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Shader compilation failed for final compute " + computeSource.getName() + "!", runtimeException);
            }
            object = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
            CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
            this.customUniforms.assignTo(programBuilder);
            IrisSamplers.addRenderTargetSamplers((SamplerHolder)object, () -> immutableSet, this.renderTargets, true);
            IrisSamplers.addCustomTextures(programBuilder, this.irisCustomTextures);
            IrisSamplers.addCustomImages((SamplerHolder)object, this.customImages);
            IrisImages.addRenderTargetImages(programBuilder, () -> immutableSet, this.renderTargets);
            IrisImages.addCustomImages(programBuilder, this.customImages);
            IrisSamplers.addNoiseSampler((SamplerHolder)object, this.noiseTexture);
            IrisSamplers.addCompositeSamplers((SamplerHolder)object, this.renderTargets);
            if (IrisSamplers.hasShadowSamplers((SamplerHolder)object)) {
                IrisSamplers.addShadowSamplers((SamplerHolder)object, supplier.get(), null, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
                IrisImages.addShadowColorImages(programBuilder, supplier.get(), null);
            }
            this.centerDepthSampler.setUsage(programBuilder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth"));
            computeProgramArray[i] = programBuilder.buildCompute();
            this.customUniforms.mapholderToPass(programBuilder, computeProgramArray[i]);
            computeProgramArray[i].setWorkGroupInfo(computeSource.getWorkGroupRelative(), computeSource.getWorkGroups());
        }
        return computeProgramArray;
    }

    public void destroy() {
        if (this.finalPass != null) {
            this.finalPass.destroy();
        }
        this.colorHolder.destroy();
    }

    private static final class Pass {
        Program program;
        ComputeProgram[] computes;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;

        private Pass() {
        }

        private void destroy() {
            this.program.destroy();
        }
    }

    private static final class SwapPass {
        public int target;
        public int width;
        public int height;
        GlFramebuffer from;
        int targetTexture;

        private SwapPass() {
        }
    }
}

