/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.strata.parser.tokenizer;

import ca.solostudios.strata.parser.tokenizer.Char;
import ca.solostudios.strata.parser.tokenizer.Lookahead;
import ca.solostudios.strata.parser.tokenizer.ParseException;
import ca.solostudios.strata.parser.tokenizer.Position;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookaheadReader
extends Lookahead<Char> {
    @NotNull
    private final Reader input;
    private int pos = 0;

    public LookaheadReader(@NotNull Reader input) {
        this.input = new BufferedReader(input);
    }

    public String toString() {
        if (this.itemBuffer.isEmpty()) {
            return String.format("%1d: Buffer empty", this.pos);
        }
        if (this.itemBuffer.size() < 2) {
            try {
                return String.format("%1d: %s", this.pos, this.current());
            }
            catch (ParseException e) {
                return String.format("%1d: Exception while fetching current.", this.pos);
            }
        }
        try {
            return String.format("%1d: %s, %s", this.pos, this.current(), this.next());
        }
        catch (ParseException e) {
            return String.format("%1d: Exception while fetching current or next.", this.pos);
        }
    }

    @Override
    @Nullable
    protected Char fetch() throws ParseException {
        try {
            int character = this.input.read();
            if (character == -1) {
                return null;
            }
            return new Char((char)character, this.pos++);
        }
        catch (IOException e) {
            throw new ParseException(e, (Position)new Char('\u0000', this.pos));
        }
    }

    @Override
    @NotNull
    protected Char endOfInput() {
        return new Char('\u0000', this.pos);
    }
}

