/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.strata.version;

import ca.solostudios.strata.version.Formattable;
import ca.solostudios.strata.version.PreReleaseIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PreRelease
implements Comparable<PreRelease>,
Formattable {
    public static final PreRelease NULL = new PreRelease(Collections.emptyList());
    @NotNull
    private final List<PreReleaseIdentifier> identifiers;

    public PreRelease(@NotNull List<PreReleaseIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public int compareTo(@NotNull PreRelease o) {
        int comparison;
        if (this.identifiers.isEmpty()) {
            if (o.identifiers.isEmpty()) {
                return 0;
            }
            return 1;
        }
        if (o.identifiers.isEmpty()) {
            return -1;
        }
        int i = 0;
        do {
            if (this.identifiers.size() <= i) {
                if (o.identifiers.size() <= i) {
                    return 0;
                }
                return -1;
            }
            if (o.identifiers.size() <= i) {
                return 1;
            }
            comparison = this.identifiers.get(i).compareTo(o.identifiers.get(i));
            ++i;
        } while (comparison == 0);
        return comparison;
    }

    public String toString() {
        return String.format("PreRelease{identifiers=%s}", this.identifiers);
    }

    public List<PreReleaseIdentifier> getIdentifiers() {
        return Collections.unmodifiableList(this.identifiers);
    }

    @Override
    @NotNull
    public String getFormatted() {
        if (this.identifiers.isEmpty()) {
            return "";
        }
        ListIterator<PreReleaseIdentifier> iterator = this.identifiers.listIterator();
        StringBuilder builder = new StringBuilder();
        if (iterator.hasNext()) {
            builder.append('-').append(((PreReleaseIdentifier)iterator.next()).getFormatted());
        }
        while (iterator.hasNext()) {
            builder.append('.').append(((PreReleaseIdentifier)iterator.next()).getFormatted());
        }
        return builder.toString();
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreRelease that = (PreRelease)o;
        return this.identifiers.equals(that.identifiers);
    }

    public int hashCode() {
        return this.identifiers.hashCode();
    }
}

