/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.strata.version;

import ca.solostudios.strata.version.Formattable;
import java.math.BigInteger;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class PreReleaseIdentifier
implements Comparable<PreReleaseIdentifier>,
Formattable {
    @Override
    public int compareTo(@NotNull PreReleaseIdentifier o) {
        if (this.isNumeric()) {
            if (o.isNumeric()) {
                return this.asInteger().compareTo(o.asInteger());
            }
            return -1;
        }
        if (o.isNumeric()) {
            return 1;
        }
        return this.asString().compareTo(o.asString());
    }

    protected BigInteger asInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Numerical values are not supported by this implementation");
    }

    @NotNull
    protected abstract String asString();

    @Override
    @NotNull
    public String getFormatted() {
        return this.asString();
    }

    protected abstract boolean isNumeric();

    public static final class AlphaNumericalPreReleaseIdentifier
    extends PreReleaseIdentifier {
        @NotNull
        private final String value;

        public AlphaNumericalPreReleaseIdentifier(@NotNull String value) {
            this.value = value;
        }

        public String toString() {
            return String.format("AlphaNumericalPreReleaseIdentifier{value='%s'}", this.value);
        }

        @Override
        @NotNull
        protected String asString() {
            return this.value;
        }

        @Override
        protected boolean isNumeric() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AlphaNumericalPreReleaseIdentifier that = (AlphaNumericalPreReleaseIdentifier)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class NumericalPreReleaseIdentifier
    extends PreReleaseIdentifier {
        private final BigInteger value;

        public NumericalPreReleaseIdentifier(BigInteger value) {
            this.value = value;
        }

        public String toString() {
            return String.format("NumericalPreReleaseIdentifier{value=%d}", this.value);
        }

        @Override
        @NotNull
        protected String asString() {
            return this.value.toString();
        }

        @Override
        protected BigInteger asInteger() {
            return this.value;
        }

        @Override
        protected boolean isNumeric() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumericalPreReleaseIdentifier that = (NumericalPreReleaseIdentifier)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

