/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.strata.version;

import ca.solostudios.strata.version.BuildMetadata;
import ca.solostudios.strata.version.CoreVersion;
import ca.solostudios.strata.version.Formattable;
import ca.solostudios.strata.version.PreRelease;
import java.math.BigInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Version
implements Comparable<Version>,
Formattable {
    @NotNull
    private final CoreVersion coreVersion;
    @NotNull
    private final PreRelease preRelease;
    @NotNull
    private final BuildMetadata buildMetadata;

    @Contract(pure=true)
    public Version(@NotNull CoreVersion coreVersion, @NotNull PreRelease preRelease, @NotNull BuildMetadata buildMetadata) {
        this.coreVersion = coreVersion;
        this.preRelease = preRelease;
        this.buildMetadata = buildMetadata;
    }

    @NotNull
    @Contract(pure=true)
    public BigInteger getMajor() {
        return this.coreVersion.getMajor();
    }

    @NotNull
    @Contract(pure=true)
    public BigInteger getMinor() {
        return this.coreVersion.getMinor();
    }

    @NotNull
    @Contract(pure=true)
    public BigInteger getPatch() {
        return this.coreVersion.getPatch();
    }

    @NotNull
    @Contract(pure=true)
    public CoreVersion getCoreVersion() {
        return this.coreVersion;
    }

    @NotNull
    @Contract(pure=true)
    public PreRelease getPreRelease() {
        return this.preRelease;
    }

    @NotNull
    @Contract(pure=true)
    public BuildMetadata getBuildMetadata() {
        return this.buildMetadata;
    }

    @Contract(pure=true)
    public String toString() {
        return String.format("Version{normalVersion=%s, preRelease=%s, buildMetadata=%s}", this.coreVersion, this.preRelease, this.buildMetadata);
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (!this.coreVersion.equals(version.coreVersion)) {
            return false;
        }
        if (!this.preRelease.equals(version.preRelease)) {
            return false;
        }
        return this.buildMetadata.equals(version.buildMetadata);
    }

    public int hashCode() {
        int result = this.coreVersion.hashCode();
        result = 31 * result + this.preRelease.hashCode();
        result = 31 * result + this.buildMetadata.hashCode();
        return result;
    }

    @Override
    public int compareTo(@NotNull Version o) {
        int normalVersionComparison = this.coreVersion.compareTo(o.coreVersion);
        return normalVersionComparison != 0 ? normalVersionComparison : this.preRelease.compareTo(o.preRelease);
    }

    @Override
    @NotNull
    public String getFormatted() {
        return String.format("%s%s%s", this.coreVersion.getFormatted(), this.preRelease.getFormatted(), this.buildMetadata.getFormatted());
    }
}

