/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.standard.IntegerArgument;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE)
public final class ByteArgument<C>
extends CommandArgument<C, Byte> {
    private final byte min;
    private final byte max;

    private ByteArgument(boolean required, @NonNull String name, byte min2, byte max, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new ByteParser(min2, max), defaultValue, Byte.class, suggestionsProvider, defaultDescription);
        this.min = min2;
        this.max = max;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return ByteArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Byte> of(@NonNull String name) {
        return ByteArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Byte> optional(@NonNull String name) {
        return ByteArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Byte> optional(@NonNull String name, byte defaultNum) {
        return ByteArgument.builder(name).asOptionalWithDefault(defaultNum).build();
    }

    public byte getMin() {
        return this.min;
    }

    public byte getMax() {
        return this.max;
    }

    @API(status=API.Status.STABLE)
    public static final class ByteParser<C>
    implements ArgumentParser<C, Byte> {
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final byte DEFAULT_MINIMUM = -128;
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final byte DEFAULT_MAXIMUM = 127;
        private final byte min;
        private final byte max;

        public ByteParser(byte min2, byte max) {
            this.min = min2;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Byte> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(ByteParser.class, commandContext));
            }
            try {
                byte value = Byte.parseByte(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new ByteParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new ByteParseException(input, this, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerArgument.IntegerParser.getSuggestions(this.min, this.max, input);
        }

        public byte getMax() {
            return this.max;
        }

        public byte getMin() {
            return this.min;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMax() {
            return this.max != 127;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMin() {
            return this.min != -128;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Byte> {
        private byte min = (byte)-128;
        private byte max = (byte)127;

        private Builder(@NonNull String name) {
            super(Byte.class, name);
        }

        public @NonNull @This Builder<C> withMin(byte min2) {
            this.min = min2;
            return this;
        }

        public @NonNull @This Builder<C> withMax(byte max) {
            this.max = max;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public @NonNull Builder<C> asOptionalWithDefault(byte defaultValue) {
            return (Builder)this.asOptionalWithDefault(Byte.toString(defaultValue));
        }

        public @NonNull ByteArgument<C> build() {
            return new ByteArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class ByteParseException
    extends NumberParseException {
        private static final long serialVersionUID = -4724241304872989208L;
        private final ByteParser<?> parser;

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.5.0")
        public ByteParseException(@NonNull String input, byte min2, byte max, @NonNull CommandContext<?> context) {
            this(input, new ByteParser(min2, max), context);
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public ByteParseException(@NonNull String input, @NonNull ByteParser<?> parser, @NonNull CommandContext<?> context) {
            super(input, ((ByteParser)parser).min, ((ByteParser)parser).max, ByteParser.class, context);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "byte";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteParseException that = (ByteParseException)o;
            return this.parser.equals(that.parser);
        }

        public int hashCode() {
            return Objects.hash(this.parser);
        }
    }
}

