/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE)
public final class DoubleArgument<C>
extends CommandArgument<C, Double> {
    private final double min;
    private final double max;

    private DoubleArgument(boolean required, @NonNull String name, double min2, double max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new DoubleParser(min2, max), defaultValue, Double.class, suggestionsProvider, defaultDescription);
        this.min = min2;
        this.max = max;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return DoubleArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Double> of(@NonNull String name) {
        return DoubleArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Double> optional(@NonNull String name) {
        return DoubleArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Double> optional(@NonNull String name, double defaultNum) {
        return DoubleArgument.builder(name).asOptionalWithDefault(defaultNum).build();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @API(status=API.Status.STABLE)
    public static final class DoubleParser<C>
    implements ArgumentParser<C, Double> {
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final double DEFAULT_MINIMUM = Double.NEGATIVE_INFINITY;
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final double DEFAULT_MAXIMUM = Double.POSITIVE_INFINITY;
        private final double min;
        private final double max;

        public DoubleParser(double min2, double max) {
            this.min = min2;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Double> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(DoubleParser.class, commandContext));
            }
            try {
                double value = Double.parseDouble(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new DoubleParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new DoubleParseException(input, this, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }

        public boolean hasMax() {
            return this.max != Double.POSITIVE_INFINITY;
        }

        public boolean hasMin() {
            return this.min != Double.NEGATIVE_INFINITY;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Double> {
        private double min = Double.NEGATIVE_INFINITY;
        private double max = Double.POSITIVE_INFINITY;

        private Builder(@NonNull String name) {
            super(Double.class, name);
        }

        public @NonNull @This Builder<C> withMin(int min2) {
            this.min = min2;
            return this;
        }

        public @NonNull @This Builder<C> withMax(int max) {
            this.max = max;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public @NonNull Builder<C> asOptionalWithDefault(double defaultValue) {
            return (Builder)this.asOptionalWithDefault(Double.toString(defaultValue));
        }

        public @NonNull DoubleArgument<C> build() {
            return new DoubleArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class DoubleParseException
    extends NumberParseException {
        private static final long serialVersionUID = 1764554911581976586L;
        private final DoubleParser<?> parser;

        @Deprecated
        public DoubleParseException(@NonNull String input, double min2, double max, @NonNull CommandContext<?> commandContext) {
            this(input, new DoubleParser(min2, max), commandContext);
        }

        public DoubleParseException(@NonNull String input, @NonNull DoubleParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, ((DoubleParser)parser).min, ((DoubleParser)parser).max, DoubleParser.class, commandContext);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "double";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleParseException that = (DoubleParseException)o;
            return this.parser.equals(that.parser);
        }

        public int hashCode() {
            return Objects.hash(this.parser);
        }
    }
}

