/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.tectonic.api.loader;

import com.dfsek.tectonic.api.TypeRegistry;
import com.dfsek.tectonic.api.config.Configuration;
import com.dfsek.tectonic.api.config.template.ConfigTemplate;
import com.dfsek.tectonic.api.config.template.ValidatedConfigTemplate;
import com.dfsek.tectonic.api.config.template.object.ObjectTemplate;
import com.dfsek.tectonic.api.depth.DepthTracker;
import com.dfsek.tectonic.api.exception.ConfigException;
import com.dfsek.tectonic.api.exception.LoadException;
import com.dfsek.tectonic.api.exception.ValidationException;
import com.dfsek.tectonic.api.exception.ValueMissingException;
import com.dfsek.tectonic.api.loader.type.TypeLoader;
import com.dfsek.tectonic.api.preprocessor.Result;
import com.dfsek.tectonic.api.preprocessor.ValuePreprocessor;
import com.dfsek.tectonic.impl.abstraction.AbstractConfiguration;
import com.dfsek.tectonic.impl.loading.loaders.EnumLoader;
import com.dfsek.tectonic.impl.loading.loaders.StringLoader;
import com.dfsek.tectonic.impl.loading.loaders.generic.ArrayListLoader;
import com.dfsek.tectonic.impl.loading.loaders.generic.HashMapLoader;
import com.dfsek.tectonic.impl.loading.loaders.generic.HashSetLoader;
import com.dfsek.tectonic.impl.loading.loaders.other.DurationLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.BooleanLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.ByteLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.CharLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.DoubleLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.FloatLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.IntLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.LongLoader;
import com.dfsek.tectonic.impl.loading.loaders.primitives.ShortLoader;
import com.dfsek.tectonic.impl.loading.object.ObjectTemplateLoader;
import com.dfsek.tectonic.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ConfigLoader
implements TypeRegistry {
    private static final EnumLoader ENUM_LOADER = new EnumLoader();
    private final Map<Type, TypeLoader<?>> loaders = new HashMap();
    private final Map<Class<? extends Annotation>, List<ValuePreprocessor<?>>> preprocessors = new HashMap();

    public ConfigLoader() {
        BooleanLoader booleanLoader = new BooleanLoader();
        this.registerLoader((Type)Boolean.TYPE, (TypeLoader)booleanLoader);
        this.registerLoader((Type)((Object)Boolean.class), (TypeLoader)booleanLoader);
        ByteLoader byteLoader = new ByteLoader();
        this.registerLoader((Type)Byte.TYPE, (TypeLoader)byteLoader);
        this.registerLoader((Type)((Object)Byte.class), (TypeLoader)byteLoader);
        ShortLoader shortLoader = new ShortLoader();
        this.registerLoader((Type)Short.TYPE, (TypeLoader)shortLoader);
        this.registerLoader((Type)((Object)Short.class), (TypeLoader)shortLoader);
        CharLoader charLoader = new CharLoader();
        this.registerLoader((Type)Character.TYPE, (TypeLoader)charLoader);
        this.registerLoader((Type)((Object)Character.class), (TypeLoader)charLoader);
        IntLoader intLoader = new IntLoader();
        this.registerLoader((Type)Integer.TYPE, (TypeLoader)intLoader);
        this.registerLoader((Type)((Object)Integer.class), (TypeLoader)intLoader);
        LongLoader longLoader = new LongLoader();
        this.registerLoader((Type)Long.TYPE, (TypeLoader)longLoader);
        this.registerLoader((Type)((Object)Long.class), (TypeLoader)longLoader);
        FloatLoader floatLoader = new FloatLoader();
        this.registerLoader((Type)Float.TYPE, (TypeLoader)floatLoader);
        this.registerLoader((Type)((Object)Float.class), (TypeLoader)floatLoader);
        DoubleLoader doubleLoader = new DoubleLoader();
        this.registerLoader((Type)Double.TYPE, (TypeLoader)doubleLoader);
        this.registerLoader((Type)((Object)Double.class), (TypeLoader)doubleLoader);
        this.registerLoader((Type)((Object)String.class), (TypeLoader)new StringLoader());
        ArrayListLoader arrayListLoader = new ArrayListLoader();
        this.registerLoader((Type)((Object)ArrayList.class), (TypeLoader)arrayListLoader);
        this.registerLoader((Type)((Object)List.class), (TypeLoader)arrayListLoader);
        HashMapLoader hashMapLoader = new HashMapLoader();
        this.registerLoader((Type)((Object)HashMap.class), (TypeLoader)hashMapLoader);
        this.registerLoader((Type)((Object)Map.class), (TypeLoader)hashMapLoader);
        HashSetLoader hashSetLoader = new HashSetLoader();
        this.registerLoader((Type)((Object)HashSet.class), (TypeLoader)hashSetLoader);
        this.registerLoader((Type)((Object)Set.class), (TypeLoader)hashSetLoader);
        this.registerLoader((Type)((Object)Duration.class), (TypeLoader)new DurationLoader());
        this.registerLoader((Type)((Object)Enum.class), (TypeLoader)ENUM_LOADER);
    }

    @Override
    @NotNull
    public ConfigLoader registerLoader(@NotNull Type t2, @NotNull TypeLoader<?> loader) {
        this.loaders.put(t2, loader);
        return this;
    }

    @Override
    @NotNull
    public <T> ConfigLoader registerLoader(@NotNull Type t2, @NotNull Supplier<ObjectTemplate<T>> provider) {
        this.loaders.put(t2, new ObjectTemplateLoader<T>(provider));
        return this;
    }

    public <T extends Annotation> ConfigLoader registerPreprocessor(Class<? extends T> clazz, ValuePreprocessor<T> processor) {
        this.preprocessors.computeIfAbsent(clazz, c -> new ArrayList()).add(processor);
        return this;
    }

    public boolean hasLoader(Type t2) {
        return this.loaders.containsKey(t2);
    }

    public <T extends ConfigTemplate> T load(T config, Configuration configuration) throws ConfigException {
        return this.load(config, configuration, new DepthTracker(Collections.emptyList(), configuration));
    }

    public <T extends ConfigTemplate> T load(T config, Configuration configuration, DepthTracker depthTracker) throws ConfigException {
        T result = config.loader().load(config, configuration, this::loadValue, depthTracker);
        if (result instanceof ValidatedConfigTemplate && !((ValidatedConfigTemplate)result).validate()) {
            throw new ValidationException("Failed to validate config. Reason unspecified:" + configuration.getName());
        }
        return result;
    }

    private Object loadValue(String value, AnnotatedType type, Configuration configuration, DepthTracker depthTracker, boolean isFinal) {
        if (this.containsFinal(configuration, value)) {
            return this.loadType(type, this.getFinal(configuration, value), depthTracker);
        }
        if (!isFinal && configuration instanceof AbstractConfiguration) {
            Object abs = configuration.get(value);
            if (abs == null) {
                throw new ValueMissingException("Value \"" + value + "\" was not found in the provided config, or its parents: " + configuration.getName(), depthTracker);
            }
            return this.loadType(type, abs, depthTracker);
        }
        throw new ValueMissingException("Value \"" + value + "\" was not found in the provided config: " + configuration.getName(), depthTracker);
    }

    private Object getFinal(Configuration configuration, String key) {
        if (configuration instanceof AbstractConfiguration) {
            return ((AbstractConfiguration)configuration).getBase(key);
        }
        return configuration.get(key);
    }

    private boolean containsFinal(Configuration configuration, String key) {
        if (configuration instanceof AbstractConfiguration) {
            return ((AbstractConfiguration)configuration).containsBase(key);
        }
        return configuration.contains(key);
    }

    public Object loadType(AnnotatedType t2, Object o, DepthTracker depthTracker) throws LoadException {
        for (Annotation annotation : t2.getAnnotations()) {
            if (!this.preprocessors.containsKey(annotation.annotationType())) continue;
            for (ValuePreprocessor<?> preprocessor : this.preprocessors.get(annotation.annotationType())) {
                Result<Object> result = preprocessor.process(t2, o, this, annotation, depthTracker);
                o = result.apply(o);
                depthTracker = result.getTracker(depthTracker);
            }
        }
        return this.getObject(t2, o, depthTracker);
    }

    private Object getObject(AnnotatedType t2, Object o, DepthTracker depthTracker) throws LoadException {
        try {
            Type raw = t2.getType();
            if (this.loaders.containsKey(raw)) {
                return this.loaders.get(raw).load(t2, o, this, depthTracker);
            }
            if (t2 instanceof AnnotatedParameterizedType && this.loaders.containsKey(raw = ((ParameterizedType)t2.getType()).getRawType())) {
                return this.loaders.get(raw).load(t2, o, this, depthTracker);
            }
            if (raw instanceof Class && ((Class)raw).isEnum()) {
                return ENUM_LOADER.load(t2, o, this, depthTracker);
            }
        }
        catch (LoadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoadException("Unexpected exception thrown during type loading: " + e.getMessage(), e, depthTracker);
        }
        throw new LoadException("No loaders are registered for type " + t2.getType().getTypeName(), depthTracker);
    }

    public <T> T loadType(Class<T> clazz, Object o, DepthTracker depthTracker) throws LoadException {
        try {
            if (this.loaders.containsKey(clazz)) {
                return ReflectionUtil.cast(clazz, this.loaders.get(clazz).load(clazz, o, this, depthTracker));
            }
            return ReflectionUtil.cast(clazz, o);
        }
        catch (LoadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoadException("Unexpected exception thrown during type loading: " + e.getMessage(), e, depthTracker);
        }
    }
}

