/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util.generic.either;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Either<L, R> {
    private final L left;
    private final R right;
    private final boolean leftPresent;

    private Either(L left, R right, boolean leftPresent) {
        this.left = left;
        this.right = right;
        this.leftPresent = leftPresent;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static <L1, R1> Either<L1, R1> left(L1 left) {
        return new Either<L1, Object>(Objects.requireNonNull(left), null, true);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static <L1, R1> Either<L1, R1> right(R1 right) {
        return new Either<Object, R1>(null, Objects.requireNonNull(right), false);
    }

    @NotNull
    @Contract(value="_ -> this")
    public Either<L, R> ifLeft(Consumer<L> action) {
        if (this.leftPresent) {
            action.accept(this.left);
        }
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public Either<L, R> ifRight(Consumer<R> action) {
        if (!this.leftPresent) {
            action.accept(this.right);
        }
        return this;
    }

    @NotNull
    public Optional<L> getLeft() {
        if (this.leftPresent) {
            return Optional.of(this.left);
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<R> getRight() {
        if (!this.leftPresent) {
            return Optional.of(this.right);
        }
        return Optional.empty();
    }

    public boolean hasLeft() {
        return this.leftPresent;
    }

    public boolean hasRight() {
        return !this.leftPresent;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Either)) {
            return false;
        }
        Either that = (Either)obj;
        return this.leftPresent && that.leftPresent && Objects.equals(this.left, that.left) || !this.leftPresent && !that.leftPresent && Objects.equals(this.right, that.right);
    }
}

