/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util.vector;

import com.dfsek.terra.api.util.MathUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.util.vector.Vector3Int;
import net.jafama.FastMath;
import org.jetbrains.annotations.NotNull;

public class Vector3 {
    protected double x;
    protected double y;
    protected double z;

    private Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Vector3 of(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public double inverseLength() {
        return FastMath.invSqrtQuick(this.lengthSquared());
    }

    public double distance(@NotNull Vector3 o) {
        return FastMath.sqrt(FastMath.pow2(this.x - o.getX()) + FastMath.pow2(this.y - o.getY()) + FastMath.pow2(this.z - o.getZ()));
    }

    public double distanceSquared(@NotNull Vector3 o) {
        return FastMath.pow2(this.x - o.getX()) + FastMath.pow2(this.y - o.getY()) + FastMath.pow2(this.z - o.getZ());
    }

    public double dot(@NotNull Vector3 other) {
        return this.x * other.getX() + this.y * other.getY() + this.z * other.getZ();
    }

    public double getZ() {
        return this.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getBlockX() {
        return FastMath.floorToInt(this.x);
    }

    public int getBlockY() {
        return FastMath.floorToInt(this.y);
    }

    public int getBlockZ() {
        return FastMath.floorToInt(this.z);
    }

    public boolean isNormalized() {
        return MathUtil.equals(this.lengthSquared(), 1.0);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector3)) {
            return false;
        }
        Vector3 other = (Vector3)obj;
        return MathUtil.equals(this.x, other.getX()) && MathUtil.equals(this.y, other.getY()) && MathUtil.equals(this.z, other.getZ());
    }

    public Vector3Int toInt() {
        return Vector3Int.of(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    public Mutable mutable() {
        return new Mutable(this.x, this.y, this.z);
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    public static class Mutable
    extends Vector3 {
        private Mutable(double x, double y, double z) {
            super(x, y, z);
        }

        public static Mutable of(double x, double y, double z) {
            return new Mutable(x, y, z);
        }

        public Vector3 immutable() {
            return Vector3.of(this.x, this.y, this.z);
        }

        @Override
        public double getZ() {
            return this.z;
        }

        public Mutable setZ(double z) {
            this.z = z;
            return this;
        }

        @Override
        public double getX() {
            return this.x;
        }

        public Mutable setX(double x) {
            this.x = x;
            return this;
        }

        @Override
        public double getY() {
            return this.y;
        }

        public Mutable setY(double y) {
            this.y = y;
            return this;
        }

        @Override
        public double lengthSquared() {
            return this.x * this.x + this.y * this.y + this.z * this.z;
        }

        @Override
        public double length() {
            return FastMath.sqrt(this.lengthSquared());
        }

        @Override
        public double inverseLength() {
            return FastMath.invSqrtQuick(this.lengthSquared());
        }

        public Mutable normalize() {
            return this.multiply(this.inverseLength());
        }

        public Mutable subtract(int x, int y, int z) {
            this.x -= (double)x;
            this.y -= (double)y;
            this.z -= (double)z;
            return this;
        }

        @Override
        public double dot(@NotNull Vector3 other) {
            return this.x * other.getX() + this.y * other.getY() + this.z * other.getZ();
        }

        public Mutable subtract(Vector3 end) {
            this.x -= end.getX();
            this.y -= end.getY();
            this.z -= end.getZ();
            return this;
        }

        public Mutable multiply(double m4) {
            this.x *= m4;
            this.y *= m4;
            this.z *= m4;
            return this;
        }

        public Mutable add(double x, double y, double z) {
            this.x += x;
            this.y += y;
            this.z += z;
            return this;
        }

        public Mutable add(Vector3 other) {
            this.x += other.getX();
            this.y += other.getY();
            this.z += other.getZ();
            return this;
        }

        public Mutable add(Vector3Int other) {
            this.x += (double)other.getX();
            this.y += (double)other.getY();
            this.z += (double)other.getZ();
            return this;
        }

        public Mutable add(Vector2 other) {
            this.x += other.getX();
            this.z += other.getZ();
            return this;
        }

        @NotNull
        public Mutable rotateAroundAxis(@NotNull Vector3 axis, double angle) throws IllegalArgumentException {
            return this.rotateAroundNonUnitAxis(axis.isNormalized() ? axis : axis.mutable().normalize().immutable(), angle);
        }

        @NotNull
        public Mutable rotateAroundNonUnitAxis(@NotNull Vector3 axis, double angle) throws IllegalArgumentException {
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            double x2 = axis.getX();
            double y2 = axis.getY();
            double z2 = axis.getZ();
            double cosTheta = Math.cos(angle);
            double sinTheta = Math.sin(angle);
            double dotProduct = this.dot(axis);
            double xPrime = x2 * dotProduct * (1.0 - cosTheta) + x * cosTheta + (-z2 * y + y2 * z) * sinTheta;
            double yPrime = y2 * dotProduct * (1.0 - cosTheta) + y * cosTheta + (z2 * x - x2 * z) * sinTheta;
            double zPrime = z2 * dotProduct * (1.0 - cosTheta) + z * cosTheta + (-y2 * x + x2 * y) * sinTheta;
            return this.setX(xPrime).setY(yPrime).setZ(zPrime);
        }

        @NotNull
        public Mutable rotateAroundX(double angle) {
            double angleCos = Math.cos(angle);
            double angleSin = Math.sin(angle);
            double y = angleCos * this.getY() - angleSin * this.getZ();
            double z = angleSin * this.getY() + angleCos * this.getZ();
            return this.setY(y).setZ(z);
        }

        @NotNull
        public Mutable rotateAroundY(double angle) {
            double angleCos = Math.cos(angle);
            double angleSin = Math.sin(angle);
            double x = angleCos * this.getX() + angleSin * this.getZ();
            double z = -angleSin * this.getX() + angleCos * this.getZ();
            return this.setX(x).setZ(z);
        }

        @NotNull
        public Mutable rotateAroundZ(double angle) {
            double angleCos = Math.cos(angle);
            double angleSin = Math.sin(angle);
            double x = angleCos * this.getX() - angleSin * this.getY();
            double y = angleSin * this.getX() + angleCos * this.getY();
            return this.setX(x).setY(y);
        }

        @Override
        public int hashCode() {
            int hash = 13;
            hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
            hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
            hash = 79 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
            return hash;
        }

        @Override
        public int getBlockX() {
            return FastMath.floorToInt(this.x);
        }

        @Override
        public int getBlockY() {
            return FastMath.floorToInt(this.y);
        }

        @Override
        public int getBlockZ() {
            return FastMath.floorToInt(this.z);
        }
    }
}

