/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.preprocessor;

import com.dfsek.tectonic.api.config.Configuration;
import com.dfsek.tectonic.api.depth.DepthTracker;
import com.dfsek.tectonic.api.depth.IndexLevel;
import com.dfsek.tectonic.api.exception.LoadException;
import com.dfsek.tectonic.api.loader.ConfigLoader;
import com.dfsek.tectonic.api.preprocessor.Result;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.util.generic.pair.Pair;
import com.dfsek.terra.config.preprocessor.MetaPreprocessor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MetaListLikePreprocessor
extends MetaPreprocessor<Meta> {
    public MetaListLikePreprocessor(Map<String, Configuration> configs) {
        super(configs);
    }

    @Override
    @NotNull
    public <T> Result<T> process(AnnotatedType t2, T c, ConfigLoader loader, Meta annotation, DepthTracker depthTracker) {
        Class baseClass;
        ParameterizedType parameterizedType;
        Type type;
        Type type2 = t2.getType();
        if (type2 instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)type2).getRawType()) instanceof Class && (List.class.isAssignableFrom(baseClass = (Class)type) || Set.class.isAssignableFrom(baseClass)) && c instanceof List) {
            List list = (List)c;
            int offset = 0;
            ArrayList newList = new ArrayList((List)c);
            for (int i = 0; i < list.size(); ++i) {
                String s2;
                Object o = list.get(i);
                if (!(o instanceof String) || !(s2 = ((String)o).trim()).startsWith("<< ")) continue;
                String meta = s2.substring(3);
                Pair<Configuration, Object> pair = this.getMetaValue(meta, depthTracker);
                Object metaValue = pair.getRight();
                if (!(metaValue instanceof List)) {
                    throw new LoadException("MetaList/Set injection candidate must be list, is type " + metaValue.getClass().getCanonicalName(), depthTracker);
                }
                List metaList = (List)metaValue;
                newList.remove(i + offset);
                newList.addAll(i + offset, metaList);
                int begin = i + offset;
                int end = i + (offset += metaList.size() - 1);
                depthTracker.addIntrinsicLevel(level -> {
                    IndexLevel indexLevel;
                    if (level instanceof IndexLevel && (indexLevel = (IndexLevel)level).getIndex() >= begin && indexLevel.getIndex() <= end) {
                        String configName = ((Configuration)pair.getLeft()).getName() == null ? "Anonymous Configuration" : ((Configuration)pair.getLeft()).getName();
                        return Optional.of("From configuration \"" + configName + "\"");
                    }
                    return Optional.empty();
                });
            }
            return Result.overwrite(newList, depthTracker);
        }
        return Result.noOp();
    }
}

