/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lib.paralithic.eval.tokenizer;

import com.dfsek.terra.lib.paralithic.eval.tokenizer.Char;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.Lookahead;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.LookaheadReader;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.ParseError;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.ParseException;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.Position;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.Token;
import java.io.Reader;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tokenizer
extends Lookahead<Token> {
    private static final char SCIENTIFIC_NOTATION_SEPARATOR = 'e';
    private static final char ALTERNATE_SCIENTIFIC_NOTATION_SEPARATOR = 'E';
    private static final char EFFECTIVE_SCIENTIFIC_NOTATION_SEPARATOR = 'e';
    private static final char[] BRACKETS = new char[]{'(', '[', '{', '}', ']', ')'};
    private static final boolean TREAT_SINGLE_PIPE_AS_BRACKET = true;
    private final Set<Character> specialIdStarters = new HashSet<Character>();
    private final Set<Character> specialIdTerminators = new HashSet<Character>();
    private final Map<String, String> keywords = new IdentityHashMap<String, String>();
    private final Map<Character, Character> stringDelimiters = new IdentityHashMap<Character, Character>();
    protected LookaheadReader input;
    private char decimalSeparator = (char)46;
    private char effectiveDecimalSeparator = (char)46;
    private char groupingSeparator = (char)95;
    private String lineComment = "//";
    private String blockCommentStart = "/*";
    private String blockCommentEnd = "*/";
    private boolean keywordsCaseSensitive = false;

    public Tokenizer(Reader input) {
        this.input = new LookaheadReader(input);
        this.input.setProblemCollector(this.problemCollector);
        this.addStringDelimiter('\"', '\\');
        this.addStringDelimiter('\'', '\u0000');
    }

    public void addStringDelimiter(char stringDelimiter, char escapeCharacter) {
        this.stringDelimiters.put(Character.valueOf(stringDelimiter), Character.valueOf(escapeCharacter));
    }

    @Override
    protected Token endOfInput() {
        return Token.createAndFill(Token.TokenType.EOI, (Char)this.input.current());
    }

    @Override
    protected Token fetch() {
        while (((Char)this.input.current()).isWhitespace()) {
            this.input.consume();
        }
        if (((Char)this.input.current()).isEndOfInput()) {
            return null;
        }
        if (this.isAtStartOfLineComment(true)) {
            this.skipToEndOfLine();
            return this.fetch();
        }
        if (this.isAtStartOfBlockComment(true)) {
            this.skipBlockComment();
            return this.fetch();
        }
        if (this.isAtStartOfNumber()) {
            return this.fetchNumber();
        }
        if (this.isAtStartOfIdentifier()) {
            return this.fetchId();
        }
        if (this.stringDelimiters.containsKey(Character.valueOf(((Char)this.input.current()).getValue()))) {
            return this.fetchString();
        }
        if (this.isAtBracket(false)) {
            return Token.createAndFill(Token.TokenType.SYMBOL, (Char)this.input.consume());
        }
        if (this.isAtStartOfSpecialId()) {
            return this.fetchSpecialId();
        }
        if (this.isSymbolCharacter((Char)this.input.current())) {
            return this.fetchSymbol();
        }
        this.problemCollector.add(ParseError.error((Position)this.input.current(), String.format("Invalid character in input: '%s'", ((Char)this.input.current()).getStringValue())));
        this.input.consume();
        return this.fetch();
    }

    @Override
    public void setProblemCollector(List<ParseError> problemCollector) {
        super.setProblemCollector(problemCollector);
        this.input.setProblemCollector(problemCollector);
    }

    protected boolean isAtStartOfSpecialId() {
        return this.specialIdStarters.contains(Character.valueOf(((Char)this.input.current()).getValue()));
    }

    protected boolean isAtStartOfNumber() {
        return ((Char)this.input.current()).isDigit() || ((Char)this.input.current()).is('-') && ((Char)this.input.next()).isDigit() || ((Char)this.input.current()).is('-') && ((Char)this.input.next()).is('.') && ((Char)this.input.next(2)).isDigit() || ((Char)this.input.current()).is('.') && ((Char)this.input.next()).isDigit();
    }

    protected boolean isAtBracket(boolean inSymbol) {
        return ((Char)this.input.current()).is(BRACKETS) || !inSymbol && ((Char)this.input.current()).is('|') && !((Char)this.input.next()).is('|');
    }

    protected boolean canConsumeThisString(String string, boolean consume) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (((Char)this.input.next(i)).is(string.charAt(i))) continue;
            return false;
        }
        if (consume) {
            this.input.consume(string.length());
        }
        return true;
    }

    protected boolean isAtStartOfLineComment(boolean consume) {
        if (this.lineComment != null) {
            return this.canConsumeThisString(this.lineComment, consume);
        }
        return false;
    }

    protected void skipToEndOfLine() {
        while (!((Char)this.input.current()).isEndOfInput() && !((Char)this.input.current()).isNewLine()) {
            this.input.consume();
        }
    }

    protected boolean isAtStartOfBlockComment(boolean consume) {
        return this.canConsumeThisString(this.blockCommentStart, consume);
    }

    protected boolean isAtEndOfBlockComment() {
        return this.canConsumeThisString(this.blockCommentEnd, true);
    }

    protected void skipBlockComment() {
        while (!((Char)this.input.current()).isEndOfInput()) {
            if (this.isAtEndOfBlockComment()) {
                return;
            }
            this.input.consume();
        }
        this.problemCollector.add(ParseError.error((Position)this.input.current(), "Premature end of block comment"));
    }

    protected Token fetchString() {
        char separator = ((Char)this.input.current()).getValue();
        char escapeChar = this.stringDelimiters.get(Character.valueOf(((Char)this.input.current()).getValue())).charValue();
        Token result = Token.create(Token.TokenType.STRING, (Position)this.input.current());
        result.addToTrigger((Char)this.input.consume());
        while (!(((Char)this.input.current()).isNewLine() || ((Char)this.input.current()).is(separator) || ((Char)this.input.current()).isEndOfInput())) {
            if (escapeChar != '\u0000' && ((Char)this.input.current()).is(escapeChar)) {
                result.addToSource((Char)this.input.consume());
                if (this.handleStringEscape(separator, escapeChar, result)) continue;
                this.problemCollector.add(ParseError.error((Position)this.input.next(), String.format("Cannot use '%s' as escaped character", ((Char)this.input.next()).getStringValue())));
                continue;
            }
            result.addToContent((Char)this.input.consume());
        }
        if (((Char)this.input.current()).is(separator)) {
            result.addToSource((Char)this.input.consume());
        } else {
            this.problemCollector.add(ParseError.error((Position)this.input.current(), "Premature end of string constant"));
        }
        return result;
    }

    protected boolean handleStringEscape(char separator, char escapeChar, Token stringToken) {
        if (((Char)this.input.current()).is(separator)) {
            stringToken.addToContent(separator);
            stringToken.addToSource((Char)this.input.consume());
            return true;
        }
        if (((Char)this.input.current()).is(escapeChar)) {
            stringToken.silentAddToContent(escapeChar);
            stringToken.addToSource((Char)this.input.consume());
            return true;
        }
        if (((Char)this.input.current()).is('n')) {
            stringToken.silentAddToContent('\n');
            stringToken.addToSource((Char)this.input.consume());
            return true;
        }
        if (((Char)this.input.current()).is('r')) {
            stringToken.silentAddToContent('\r');
            stringToken.addToSource((Char)this.input.consume());
            return true;
        }
        return false;
    }

    protected boolean isAtStartOfIdentifier() {
        return ((Char)this.input.current()).isLetter();
    }

    protected Token fetchId() {
        Token result = Token.create(Token.TokenType.ID, (Position)this.input.current());
        result.addToContent((Char)this.input.consume());
        while (this.isIdentifierChar((Char)this.input.current())) {
            result.addToContent((Char)this.input.consume());
        }
        if (!((Char)this.input.current()).isEndOfInput() && this.specialIdTerminators.contains(Character.valueOf(((Char)this.input.current()).getValue()))) {
            Token specialId = Token.create(Token.TokenType.SPECIAL_ID, result);
            specialId.setTrigger(((Char)this.input.current()).getStringValue());
            specialId.setContent(result.getContents());
            specialId.setSource(result.getContents());
            specialId.addToSource((Char)this.input.current());
            this.input.consume();
            return this.handleKeywords(specialId);
        }
        return this.handleKeywords(result);
    }

    protected Token handleKeywords(Token idToken) {
        String keyword = this.keywords.get(this.keywordsCaseSensitive ? idToken.getContents().intern() : idToken.getContents().toLowerCase().intern());
        if (keyword != null) {
            Token keywordToken = Token.create(Token.TokenType.KEYWORD, idToken);
            keywordToken.setTrigger(keyword);
            keywordToken.setContent(idToken.getContents());
            keywordToken.setSource(idToken.getSource());
            return keywordToken;
        }
        return idToken;
    }

    protected boolean isIdentifierChar(Char current) {
        return current.isDigit() || current.isLetter() || current.is('_');
    }

    protected Token fetchSpecialId() {
        Token result = Token.create(Token.TokenType.SPECIAL_ID, (Position)this.input.current());
        result.addToTrigger((Char)this.input.consume());
        while (this.isIdentifierChar((Char)this.input.current())) {
            result.addToContent((Char)this.input.consume());
        }
        return this.handleKeywords(result);
    }

    protected Token fetchSymbol() {
        Token result = Token.create(Token.TokenType.SYMBOL, (Position)this.input.current());
        result.addToTrigger((Char)this.input.consume());
        if (result.isSymbol("*") && ((Char)this.input.current()).is('*') || result.isSymbol("&") && ((Char)this.input.current()).is('&') || result.isSymbol("|") && ((Char)this.input.current()).is('|') || result.isSymbol(new String[0]) && ((Char)this.input.current()).is('=')) {
            result.addToTrigger((Char)this.input.consume());
        }
        return result;
    }

    protected boolean isSymbolCharacter(Char ch) {
        if (ch.isEndOfInput() || ch.isDigit() || ch.isLetter() || ch.isWhitespace()) {
            return false;
        }
        char c = ch.getValue();
        if (Character.isISOControl(c)) {
            return false;
        }
        return !this.isAtBracket(true) && !this.isAtStartOfBlockComment(false) && !this.isAtStartOfLineComment(false) && !this.isAtStartOfNumber() && !this.isAtStartOfIdentifier() && !this.stringDelimiters.containsKey(Character.valueOf(ch.getValue()));
    }

    protected Token fetchNumber() {
        Token result = Token.create(Token.TokenType.INTEGER, (Position)this.input.current());
        result.addToContent((Char)this.input.consume());
        while (((Char)this.input.current()).isDigit() || ((Char)this.input.current()).is(this.decimalSeparator) || ((Char)this.input.current()).is(this.groupingSeparator) && ((Char)this.input.next()).isDigit() || (((Char)this.input.current()).is('e') || ((Char)this.input.current()).is('E')) && (((Char)this.input.next()).isDigit() || ((Char)this.input.next()).is('+') || ((Char)this.input.next()).is('-'))) {
            if (((Char)this.input.current()).is(this.groupingSeparator)) {
                result.addToSource((Char)this.input.consume());
                continue;
            }
            if (((Char)this.input.current()).is(this.decimalSeparator)) {
                if (result.is(Token.TokenType.DECIMAL) || result.is(Token.TokenType.SCIENTIFIC_DECIMAL)) {
                    this.problemCollector.add(ParseError.error((Position)this.input.current(), "Unexpected decimal separators"));
                } else {
                    Token decimalToken = Token.create(Token.TokenType.DECIMAL, result);
                    decimalToken.setContent(result.getContents() + this.effectiveDecimalSeparator);
                    decimalToken.setSource(result.getSource());
                    result = decimalToken;
                }
                result.addToSource((Char)this.input.consume());
                continue;
            }
            if (((Char)this.input.current()).is('e') || ((Char)this.input.current()).is('E')) {
                if (result.is(Token.TokenType.SCIENTIFIC_DECIMAL)) {
                    this.problemCollector.add(ParseError.error((Position)this.input.current(), "Unexpected scientific notation separators"));
                    continue;
                }
                Token scientificDecimalToken = Token.create(Token.TokenType.SCIENTIFIC_DECIMAL, result);
                scientificDecimalToken.setContent(result.getContents() + 'e');
                scientificDecimalToken.setSource(result.getSource() + 'e');
                result = scientificDecimalToken;
                this.input.consume();
                if (!((Char)this.input.current()).is('+') && !((Char)this.input.current()).is('-')) continue;
                result.addToContent((Char)this.input.consume());
                continue;
            }
            result.addToContent((Char)this.input.consume());
        }
        return result;
    }

    public boolean isKeywordsCaseSensitive() {
        return this.keywordsCaseSensitive;
    }

    public void setKeywordsCaseSensitive(boolean keywordsCaseSensitive) {
        this.keywordsCaseSensitive = keywordsCaseSensitive;
    }

    public void addKeyword(String keyword) {
        this.keywords.put(this.keywordsCaseSensitive ? keyword.intern() : keyword.toLowerCase().intern(), keyword);
    }

    public void addSpecialIdStarter(char character) {
        this.specialIdStarters.add(Character.valueOf(character));
    }

    public void addSpecialIdTerminator(char character) {
        this.specialIdTerminators.add(Character.valueOf(character));
    }

    public void clearStringDelimiters() {
        this.stringDelimiters.clear();
    }

    public void addUnescapedStringDelimiter(char stringDelimiter) {
        this.stringDelimiters.put(Character.valueOf(stringDelimiter), Character.valueOf('\u0000'));
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getEffectiveDecimalSeparator() {
        return this.effectiveDecimalSeparator;
    }

    public void setEffectiveDecimalSeparator(char effectiveDecimalSeparator) {
        this.effectiveDecimalSeparator = effectiveDecimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public String getLineComment() {
        return this.lineComment;
    }

    public void setLineComment(String lineComment) {
        this.lineComment = lineComment;
    }

    public String getBlockCommentStart() {
        return this.blockCommentStart;
    }

    public void setBlockCommentStart(String blockCommentStart) {
        this.blockCommentStart = blockCommentStart;
    }

    public String getBlockCommentEnd() {
        return this.blockCommentEnd;
    }

    public void setBlockCommentEnd(String blockCommentEnd) {
        this.blockCommentEnd = blockCommentEnd;
    }

    public String toString() {
        if (this.itemBuffer.isEmpty()) {
            return "No Token fetched...";
        }
        if (this.itemBuffer.size() < 2) {
            return "Current: " + this.current();
        }
        return "Current: " + ((Token)this.current()).toString() + ", Next: " + ((Token)this.next()).toString();
    }

    public boolean more() {
        return ((Token)this.current()).isNotEnd();
    }

    public boolean atEnd() {
        return ((Token)this.current()).isEnd();
    }

    public void addWarning(Position pos, String message, Object ... parameters) {
        this.getProblemCollector().add(ParseError.warning(pos, String.format(message, parameters)));
    }

    public void consumeExpectedSymbol(String symbol) {
        if (((Token)this.current()).matches(Token.TokenType.SYMBOL, symbol)) {
            this.consume();
        } else {
            this.addError((Position)this.current(), "Unexpected token: '%s'. Expected: '%s'", ((Token)this.current()).getSource(), symbol);
        }
    }

    public void addError(Position pos, String message, Object ... parameters) {
        this.getProblemCollector().add(ParseError.error(pos, String.format(message, parameters)));
    }

    public void consumeExpectedKeyword(String keyword) {
        if (((Token)this.current()).matches(Token.TokenType.KEYWORD, keyword)) {
            this.consume();
        } else {
            this.addError((Position)this.current(), "Unexpected token: '%s'. Expected: '%s'", ((Token)this.current()).getSource(), keyword);
        }
    }

    public void throwOnErrorOrWarning() throws ParseException {
        if (!this.getProblemCollector().isEmpty()) {
            throw ParseException.create(this.getProblemCollector());
        }
    }

    public void throwOnError() throws ParseException {
        for (ParseError e : this.getProblemCollector()) {
            if (e.getSeverity() != ParseError.Severity.ERROR) continue;
            throw ParseException.create(this.getProblemCollector());
        }
    }
}

