/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.mod;

import com.dfsek.tectonic.api.TypeRegistry;
import com.dfsek.tectonic.api.depth.DepthTracker;
import com.dfsek.tectonic.api.exception.LoadException;
import com.dfsek.terra.AbstractPlatform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.handle.ItemHandle;
import com.dfsek.terra.api.handle.WorldHandle;
import com.dfsek.terra.api.world.biome.PlatformBiome;
import com.dfsek.terra.mod.config.BiomeAdditionsSoundTemplate;
import com.dfsek.terra.mod.config.BiomeMoodSoundTemplate;
import com.dfsek.terra.mod.config.BiomeParticleConfigTemplate;
import com.dfsek.terra.mod.config.EntityTypeTemplate;
import com.dfsek.terra.mod.config.MusicSoundTemplate;
import com.dfsek.terra.mod.config.ProtoPlatformBiome;
import com.dfsek.terra.mod.config.SoundEventTemplate;
import com.dfsek.terra.mod.config.SpawnCostConfig;
import com.dfsek.terra.mod.config.SpawnEntryTemplate;
import com.dfsek.terra.mod.config.SpawnGroupTemplate;
import com.dfsek.terra.mod.config.SpawnSettingsTemplate;
import com.dfsek.terra.mod.config.SpawnTypeConfig;
import com.dfsek.terra.mod.config.VillagerTypeTemplate;
import com.dfsek.terra.mod.handle.MinecraftItemHandle;
import com.dfsek.terra.mod.handle.MinecraftWorldHandle;
import com.dfsek.terra.mod.util.PresetUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3854;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5284;
import net.minecraft.class_5483;
import net.minecraft.class_7145;
import net.minecraft.class_8197;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class ModPlatform
extends AbstractPlatform {
    private final ItemHandle itemHandle = new MinecraftItemHandle();
    private final WorldHandle worldHandle = new MinecraftWorldHandle();

    public abstract MinecraftServer getServer();

    public void registerWorldTypes(BiConsumer<class_2960, class_7145> registerFunction) {
        this.getRawConfigRegistry().forEach(pack -> PresetUtil.createDefault(pack, this).apply(registerFunction));
    }

    @Override
    public void register(TypeRegistry registry) {
        super.register(registry);
        registry.registerLoader((Type)((Object)PlatformBiome.class), (type, o, loader, depthTracker) -> this.parseBiome((String)o, depthTracker)).registerLoader((Type)((Object)class_2960.class), (type, o, loader, depthTracker) -> {
            class_2960 identifier = class_2960.method_12829((String)((String)o));
            if (identifier == null) {
                throw new LoadException("Invalid identifier: " + o, depthTracker);
            }
            return identifier;
        }).registerLoader((Type)((Object)class_1959.class_1963.class), (type, o, loader, depthTracker) -> class_1959.class_1963.valueOf((String)((String)o).toUpperCase(Locale.ROOT))).registerLoader((Type)((Object)class_4763.class_5486.class), (type, o, loader, depthTracker) -> class_4763.class_5486.valueOf((String)((String)o).toUpperCase(Locale.ROOT))).registerLoader((Type)((Object)class_4763.class_5486.class), (type, o, loader, depthTracker) -> class_1959.class_5484.valueOf((String)((String)o).toUpperCase(Locale.ROOT))).registerLoader((Type)((Object)class_4761.class), BiomeParticleConfigTemplate::new).registerLoader((Type)((Object)class_3414.class), SoundEventTemplate::new).registerLoader((Type)((Object)class_4968.class), BiomeMoodSoundTemplate::new).registerLoader((Type)((Object)class_4967.class), BiomeAdditionsSoundTemplate::new).registerLoader((Type)((Object)class_5195.class), MusicSoundTemplate::new).registerLoader((Type)((Object)class_1299.class), EntityTypeTemplate::new).registerLoader((Type)((Object)SpawnCostConfig.class), SpawnCostConfig::new).registerLoader((Type)((Object)class_5483.class_1964.class), SpawnEntryTemplate::new).registerLoader((Type)((Object)class_1311.class), SpawnGroupTemplate::new).registerLoader((Type)((Object)SpawnTypeConfig.class), SpawnTypeConfig::new).registerLoader((Type)((Object)class_5483.class), SpawnSettingsTemplate::new).registerLoader((Type)((Object)class_3854.class), VillagerTypeTemplate::new);
    }

    private ProtoPlatformBiome parseBiome(String id, DepthTracker tracker) throws LoadException {
        class_2960 identifier = class_2960.method_12829((String)id);
        if (!this.biomeRegistry().method_10250(identifier)) {
            throw new LoadException("Invalid Biome ID: " + identifier, tracker);
        }
        return new ProtoPlatformBiome(identifier);
    }

    @Override
    protected Iterable<BaseAddon> platformAddon() {
        return List.of(this.getPlatformAddon());
    }

    protected abstract BaseAddon getPlatformAddon();

    public abstract class_2378<class_2874> dimensionTypeRegistry();

    public abstract class_2378<class_1959> biomeRegistry();

    public abstract class_2378<class_5284> chunkGeneratorSettingsRegistry();

    public abstract class_2378<class_8197> multiNoiseBiomeSourceParameterListRegistry();

    @Override
    @NotNull
    public WorldHandle getWorldHandle() {
        return this.worldHandle;
    }

    @Override
    @NotNull
    public ItemHandle getItemHandle() {
        return this.itemHandle;
    }
}

