/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.result.api.AreaClaimResult;
import xaero.pac.common.claims.result.api.ClaimResult;

public class ClientboundClaimResultPacket {
    private final AreaClaimResult result;

    public ClientboundClaimResultPacket(AreaClaimResult result) {
        this.result = result;
    }

    public static class ClientHandler
    implements Consumer<ClientboundClaimResultPacket> {
        @Override
        public void accept(ClientboundClaimResultPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimResult(t.result);
        }
    }

    public static class Codec
    implements BiConsumer<ClientboundClaimResultPacket, class_2540>,
    Function<class_2540, ClientboundClaimResultPacket> {
        @Override
        public ClientboundClaimResultPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 2048) {
                    return null;
                }
                class_2487 tag = input.method_30617();
                if (tag == null) {
                    return null;
                }
                byte[] resultTypesArray = tag.method_10547("ta");
                HashSet<ClaimResult.Type> resultTypes = new HashSet<ClaimResult.Type>();
                for (byte ordinal : resultTypesArray) {
                    ClaimResult.Type resultType;
                    try {
                        resultType = ClaimResult.Type.values()[ordinal];
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        OpenPartiesAndClaims.LOGGER.error("illegal claim result id in packet", (Throwable)aioobe);
                        return null;
                    }
                    resultTypes.add(resultType);
                }
                int left = tag.method_10550("l");
                int top = tag.method_10550("t");
                int right = tag.method_10550("r");
                int bottom = tag.method_10550("b");
                return new ClientboundClaimResultPacket(new AreaClaimResult(resultTypes, left, top, right, bottom));
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }

        @Override
        public void accept(ClientboundClaimResultPacket t, class_2540 u) {
            class_2487 tag = new class_2487();
            Iterator<ClaimResult.Type> iterator = t.result.getResultTypesIterable().iterator();
            byte[] resultTypes = new byte[t.result.getSize()];
            int index = 0;
            while (iterator.hasNext()) {
                resultTypes[index] = (byte)iterator.next().ordinal();
                ++index;
            }
            tag.method_10570("ta", resultTypes);
            tag.method_10569("l", t.result.getLeft());
            tag.method_10569("t", t.result.getTop());
            tag.method_10569("r", t.result.getRight());
            tag.method_10569("b", t.result.getBottom());
            u.method_10794(tag);
        }
    }
}

