/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundRemoveSubClaimPacket
extends LazyPacket<LazyPacket.Encoder<ClientboundRemoveSubClaimPacket>, ClientboundRemoveSubClaimPacket> {
    public static final LazyPacket.Encoder<ClientboundRemoveSubClaimPacket> ENCODER = new LazyPacket.Encoder();
    private final UUID playerId;
    private final int subConfigIndex;

    public ClientboundRemoveSubClaimPacket(UUID playerId, int subConfigIndex) {
        this.playerId = playerId;
        this.subConfigIndex = subConfigIndex;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundRemoveSubClaimPacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundRemoveSubClaimPacket> encoder, class_2540 u) {
        class_2487 nbt = new class_2487();
        nbt.method_25927("p", this.playerId);
        nbt.method_10569("s", this.subConfigIndex);
        u.method_10794(nbt);
    }

    public String toString() {
        return String.format("[%s, %d]", this.playerId, this.subConfigIndex);
    }

    public static class ClientHandler
    implements Consumer<ClientboundRemoveSubClaimPacket> {
        @Override
        public void accept(ClientboundRemoveSubClaimPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onRemoveSubClaim(t.playerId, t.subConfigIndex);
        }
    }

    public static class Decoder
    implements Function<class_2540, ClientboundRemoveSubClaimPacket> {
        @Override
        public ClientboundRemoveSubClaimPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                class_2487 nbt = input.method_30617();
                if (nbt == null) {
                    return null;
                }
                UUID playerId = nbt.method_25926("p");
                int subConfigIndex = nbt.method_10550("s");
                return new ClientboundRemoveSubClaimPacket(playerId, subConfigIndex);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }
}

