/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.lazypacket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.server.lazypacket.PlayerLazyPacketManager;

public class LazyPacketManager {
    private final MinecraftServer server;
    private final List<UUID> orderHolder;
    private final Map<UUID, PlayerLazyPacketManager> storage;
    private int currentIndex;
    private int totalBytesEnqueued;

    private LazyPacketManager(MinecraftServer server, List<UUID> orderHolder, Map<UUID, PlayerLazyPacketManager> storage) {
        this.server = server;
        this.orderHolder = orderHolder;
        this.storage = storage;
    }

    private PlayerLazyPacketManager getForPlayer(UUID id) {
        PlayerLazyPacketManager result = this.storage.get(id);
        if (result == null) {
            result = PlayerLazyPacketManager.Builder.begin().setServer(this.server).setPlayerId(id).build();
            int insertionIndex = Collections.binarySearch(this.orderHolder, id);
            if (insertionIndex < 0) {
                insertionIndex = -1 - insertionIndex;
            }
            this.orderHolder.add(insertionIndex, id);
            this.storage.put(id, result);
        }
        return result;
    }

    public void clearForPlayer(class_3222 player, UUID playerId) {
        int insertionIndex = Collections.binarySearch(this.orderHolder, playerId);
        if (insertionIndex >= 0) {
            this.orderHolder.remove(insertionIndex);
            PlayerLazyPacketManager removedPlayerPackets = this.storage.remove(playerId);
            if (player != null) {
                removedPlayerPackets.onDropped(player);
            }
        }
    }

    public void enqueue(class_3222 player, LazyPacket<?, ?> packet) {
        if (this.getForPlayer(player.method_5667()).enqueue(packet)) {
            this.totalBytesEnqueued += packet.prepare();
        }
    }

    public void countSentBytes(LazyPacket<?, ?> packet) {
        this.totalBytesEnqueued -= packet.getPreparedSize();
    }

    public int getTotalBytesEnqueued() {
        return this.totalBytesEnqueued;
    }

    public PlayerLazyPacketManager getNext(int bytesPerConfirmation, boolean overCapacity) {
        if (!this.orderHolder.isEmpty()) {
            for (int i = 0; i < this.orderHolder.size(); ++i) {
                this.currentIndex %= this.orderHolder.size();
                UUID id = this.orderHolder.get(this.currentIndex);
                ++this.currentIndex;
                PlayerLazyPacketManager playerPackets = this.getForPlayer(id);
                if (!playerPackets.hasNext(overCapacity, this)) continue;
                return playerPackets;
            }
        }
        return null;
    }

    void onConfirmation(class_3222 player) {
        this.getForPlayer(player.method_5667()).clientConfirm();
    }

    public boolean isClogged(class_3222 player) {
        return this.getForPlayer(player.method_5667()).isClogged();
    }

    public static final class Builder {
        private MinecraftServer server;

        public Builder setDefault() {
            this.setServer(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public LazyPacketManager build() {
            if (this.server == null) {
                throw new IllegalStateException();
            }
            return new LazyPacketManager(this.server, new ArrayList<UUID>(), new HashMap<UUID, PlayerLazyPacketManager>());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

