/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.io.serialization.nbt;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.io.serialization.SimpleSerializer;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.io.serialization.nbt.member.PartyInviteNbtSerializer;
import xaero.pac.common.server.parties.party.io.serialization.nbt.member.PartyMemberNbtSerializer;

public final class PartyNbtSerializer
implements SimpleSerializer<class_2487, String, ServerParty, PartyManager> {
    private final PartyMemberNbtSerializer partyMemberNbtSerializer;
    private final PartyInviteNbtSerializer partyInviteNbtSerializer;

    public PartyNbtSerializer(PartyMemberNbtSerializer partyMemberNbtSerializer, PartyInviteNbtSerializer partyInviteNbtSerializer) {
        this.partyMemberNbtSerializer = partyMemberNbtSerializer;
        this.partyInviteNbtSerializer = partyInviteNbtSerializer;
    }

    @Override
    public class_2487 serialize(ServerParty party) {
        class_2487 result = new class_2487();
        result.method_10566("owner", (class_2520)this.partyMemberNbtSerializer.serialize(party.getOwner()));
        result.method_10544("lastConfirmedActivity", party.getLastConfirmedActivity());
        class_2499 membersTag = new class_2499();
        class_2499 invitesTag = new class_2499();
        class_2499 alliesTag = new class_2499();
        party.getInvitedPlayersStream().forEach(p -> invitesTag.add((Object)this.partyInviteNbtSerializer.serialize((PartyInvite)p)));
        party.getAllyPartiesStream().forEach(a -> alliesTag.add((Object)class_2512.method_25929((UUID)a.getPartyId())));
        party.getMemberInfoStream().filter(mi -> mi != party.getOwner()).forEach(mi -> membersTag.add((Object)this.partyMemberNbtSerializer.serialize((PartyMember)mi)));
        result.method_10566("invites", (class_2520)invitesTag);
        result.method_10566("allies", (class_2520)alliesTag);
        result.method_10566("members", (class_2520)membersTag);
        return result;
    }

    @Override
    public ServerParty deserialize(String id, PartyManager manager, class_2487 serializedData) {
        PartyMember owner = this.partyMemberNbtSerializer.deserialize(serializedData.method_10562("owner"), true);
        long lastConfirmedActivity = serializedData.method_10537("lastConfirmedActivity");
        class_2499 membersTag = serializedData.method_10554("members", 10);
        class_2499 invitesTag = serializedData.method_10554("invites", 10);
        class_2499 alliesTag = serializedData.method_10554("allies", 11);
        HashMap members = new HashMap(32);
        HashMap invites = new HashMap(32);
        HashMap allies = new HashMap();
        membersTag.forEach(t -> {
            PartyMember member = this.partyMemberNbtSerializer.deserialize((class_2487)t, false);
            members.put(member.getUUID(), member);
        });
        invitesTag.forEach(t -> {
            PartyInvite invite = this.partyInviteNbtSerializer.deserialize((class_2487)t);
            invites.put(invite.getUUID(), invite);
        });
        alliesTag.forEach(t -> {
            UUID ally = class_2512.method_25930((class_2520)t);
            allies.put(ally, new PartyAlly(ally));
        });
        ServerParty result = ((ServerParty.Builder)((ServerParty.Builder)((ServerParty.Builder)ServerParty.Builder.begin().setManagedBy(manager).setOwner(owner).setId(UUID.fromString(id)).setMemberInfo((Map)members)).setInvitedPlayers((Map)invites)).setAllyParties((Map)allies)).build();
        result.setLastConfirmedActivity(lastConfirmedActivity);
        return result;
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public PartyNbtSerializer build() {
            return new PartyNbtSerializer(new PartyMemberNbtSerializer(), new PartyInviteNbtSerializer());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

