/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.fluid;

import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class FluidHooks2 {
    public static final long BUCKET = FluidHooks.buckets((double)1.0);
    public static final long MILLI_BUCKET = BUCKET / 1000L;

    public static boolean notEmptyAndTest(FluidHolder fluid, @Nullable Predicate<FluidHolder> predicate) {
        if (fluid.isEmpty()) {
            return false;
        }
        return predicate == null || predicate.test(fluid);
    }

    public static double getStoredRatio(long amount, long capacity) {
        return capacity == 0L ? 0.0 : (double)amount / (double)capacity;
    }

    public static FluidHolder extractFluid(UniveralFluidHandler fluidHandler, @Nullable Predicate<FluidHolder> predicate, long amount, boolean simulate) {
        int tanks = fluidHandler.getTankAmount();
        for (int i = 0; i < tanks; ++i) {
            FluidHolder extracting;
            FluidHolder fluid = fluidHandler.getFluidInTank(i);
            if (!FluidHooks2.notEmptyAndTest(fluid, predicate) || (extracting = fluidHandler.extractFluid(fluid.copyWithAmount(amount), simulate)).isEmpty()) continue;
            return extracting;
        }
        return FluidHooks.emptyFluid();
    }

    public static FluidHolder extractFluid(UniveralFluidHandler fluidHandler, @Nullable Predicate<FluidHolder> predicate, boolean simulate) {
        int tanks = fluidHandler.getTankAmount();
        for (int i = 0; i < tanks; ++i) {
            FluidHolder extracting;
            FluidHolder fluid = fluidHandler.getFluidInTank(i);
            if (!FluidHooks2.notEmptyAndTest(fluid, predicate) || (extracting = fluidHandler.extractFluid(fluid, simulate)).isEmpty()) continue;
            return extracting;
        }
        return FluidHooks.emptyFluid();
    }

    public static FluidHolder insertFluidAny(UniveralFluidHandler fluidHandler, Collection<FluidHolder> fluids, boolean simulate) {
        for (FluidHolder fluid : fluids) {
            long insertAmount;
            if (fluid.isEmpty() || (insertAmount = fluidHandler.insertFluid(fluid, simulate)) <= 0L) continue;
            return fluid.copyWithAmount(insertAmount);
        }
        return FluidHooks.emptyFluid();
    }

    public static FluidHolder moveFluidAny(UniveralFluidHandler from, UniveralFluidHandler to, @Nullable Predicate<FluidHolder> predicate, long amount, boolean simulate) {
        FluidHolder extracting = FluidHooks2.extractFluid(from, predicate, amount, true);
        if (extracting.isEmpty()) {
            return FluidHooks.emptyFluid();
        }
        FluidHolder inserting = extracting.copyWithAmount(to.insertFluid(extracting, true));
        if (!simulate && !inserting.isEmpty()) {
            from.extractFluid(inserting, false);
            to.insertFluid(inserting, false);
        }
        return inserting;
    }

    public static FluidHolder moveFluidAny(UniveralFluidHandler from, UniveralFluidHandler to, @Nullable Predicate<FluidHolder> predicate, boolean simulate) {
        FluidHolder extracting = FluidHooks2.extractFluid(from, predicate, true);
        if (extracting.isEmpty()) {
            return FluidHooks.emptyFluid();
        }
        FluidHolder inserting = extracting.copyWithAmount(to.insertFluid(extracting, true));
        if (!simulate && !inserting.isEmpty()) {
            from.extractFluid(inserting, false);
            to.insertFluid(inserting, false);
        }
        return inserting;
    }

    private FluidHooks2() {
    }
}

