/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client;

import com.telepathicgrunt.the_bumblezone.events.player.PlayerTickEvent;
import com.telepathicgrunt.the_bumblezone.mixin.client.SoundEngineAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.client.SoundManagerAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4235;
import net.minecraft.class_7923;

public class MusicHandler {
    private static final Map<class_2960, MusicFader> MUSIC_FADERS = new HashMap<class_2960, MusicFader>();
    private static class_1113 ANGRY_BEE_MUSIC = null;
    private static class_1113 SEMPITERNAL_SANCTUM_MUSIC = null;
    private static class_1113 ESSENCE_EVENT_MUSIC = null;
    private static final class_2960 BIOME_MUSIC = new class_2960("the_bumblezone", "biome_music");
    public static boolean BUMBLEZONE_MUSIC_PLAYING = false;

    public static void tickMusicFader(PlayerTickEvent event) {
        class_310 minecraftClient = class_310.method_1551();
        Iterator<Map.Entry<class_2960, MusicFader>> iterator = MUSIC_FADERS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2960, MusicFader> entry = iterator.next();
            MusicFader musicFader = entry.getValue();
            if (musicFader.fadeIn) {
                boolean success = musicFader.stopOtherMusic.test(minecraftClient);
                if (!success) {
                    minecraftClient.method_1483().method_4870(musicFader.music);
                    iterator.remove();
                    continue;
                }
                boolean isPlaying = MusicHandler.isMusicPlaying(minecraftClient, musicFader.music);
                if (!isPlaying) {
                    minecraftClient.method_1483().method_4873(musicFader.music);
                } else if (musicFader.counter == 0) continue;
                float newVolume = Math.max(0.01f, 1.0f - (float)musicFader.counter / (float)musicFader.counterStart);
                MusicHandler.setMusicVolume(minecraftClient, musicFader.music, newVolume);
            } else {
                if (musicFader.counter == 0) {
                    minecraftClient.method_1483().method_4870(musicFader.music);
                    iterator.remove();
                    continue;
                }
                float newVolume = (float)musicFader.counter / (float)musicFader.counterStart;
                MusicHandler.setMusicVolume(minecraftClient, musicFader.music, newVolume);
            }
            if (musicFader.counter <= 0) continue;
            --musicFader.counter;
        }
    }

    public static void playStopAngryBeeMusic(class_1657 entity, boolean play) {
        class_310 minecraftClient = class_310.method_1551();
        if (play && (ANGRY_BEE_MUSIC == null || !MusicHandler.isMusicPlaying(minecraftClient, ANGRY_BEE_MUSIC))) {
            if (ESSENCE_EVENT_MUSIC != null && MusicHandler.isMusicPlaying(minecraftClient, ESSENCE_EVENT_MUSIC)) {
                return;
            }
            if (!(entity.method_7337() || entity.method_7325() || entity != minecraftClient.field_1724 || MusicHandler.isMusicPlaying(minecraftClient, ANGRY_BEE_MUSIC))) {
                ANGRY_BEE_MUSIC = class_1109.method_4759((class_3414)BzSounds.ANGERED_BEES.get());
                BUMBLEZONE_MUSIC_PLAYING = true;
                minecraftClient.method_1483().method_4873(ANGRY_BEE_MUSIC);
                MusicHandler.setMusicVolume(minecraftClient, ANGRY_BEE_MUSIC, 0.01f);
                MusicHandler.addMusicFade(ANGRY_BEE_MUSIC, 100, true, m -> {
                    if (MusicHandler.isMusicPlaying(minecraftClient, ESSENCE_EVENT_MUSIC)) {
                        return false;
                    }
                    m.method_1483().method_4875(BIOME_MUSIC, class_3419.field_15253);
                    m.method_1483().method_4875(class_3417.field_14995.method_40237().method_29177(), class_3419.field_15253);
                    m.method_1483().method_4875(class_3417.field_14681.method_40237().method_29177(), class_3419.field_15253);
                    m.method_1483().method_4875(BzSounds.SEMPITERNAL_SANCTUM.get().method_14833(), class_3419.field_15253);
                    return true;
                });
            }
        } else if (!play && ANGRY_BEE_MUSIC != null) {
            BUMBLEZONE_MUSIC_PLAYING = false;
            MusicHandler.addMusicFade(ANGRY_BEE_MUSIC, 150, false, m -> false);
        }
    }

    public static void playStopSempiternalSanctumMusic(class_1657 entity, class_2960 resourceLocation, boolean play) {
        class_310 minecraftClient = class_310.method_1551();
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(resourceLocation);
        if (soundEvent != BzSounds.SEMPITERNAL_SANCTUM.get()) {
            return;
        }
        if (play && (SEMPITERNAL_SANCTUM_MUSIC == null || !MusicHandler.isMusicPlaying(minecraftClient, SEMPITERNAL_SANCTUM_MUSIC))) {
            if (ANGRY_BEE_MUSIC != null && MusicHandler.isMusicPlaying(minecraftClient, ANGRY_BEE_MUSIC)) {
                return;
            }
            if (ESSENCE_EVENT_MUSIC != null && MusicHandler.isMusicPlaying(minecraftClient, ESSENCE_EVENT_MUSIC)) {
                return;
            }
            if (entity == minecraftClient.field_1724 && !MusicHandler.isMusicPlaying(minecraftClient, SEMPITERNAL_SANCTUM_MUSIC)) {
                SEMPITERNAL_SANCTUM_MUSIC = class_1109.method_4759((class_3414)BzSounds.SEMPITERNAL_SANCTUM.get());
                BUMBLEZONE_MUSIC_PLAYING = true;
                minecraftClient.method_1483().method_4873(SEMPITERNAL_SANCTUM_MUSIC);
                MusicHandler.setMusicVolume(minecraftClient, SEMPITERNAL_SANCTUM_MUSIC, 0.01f);
                MusicHandler.addMusicFade(SEMPITERNAL_SANCTUM_MUSIC, 1000, true, m -> {
                    if (MusicHandler.isMusicPlaying(minecraftClient, ESSENCE_EVENT_MUSIC) || MusicHandler.isMusicPlaying(minecraftClient, ANGRY_BEE_MUSIC)) {
                        return false;
                    }
                    m.method_1483().method_4875(class_3417.field_14995.method_40237().method_29177(), class_3419.field_15253);
                    m.method_1483().method_4875(BIOME_MUSIC, class_3419.field_15253);
                    m.method_1483().method_4875(class_3417.field_14995.method_40237().method_29177(), class_3419.field_15253);
                    m.method_1483().method_4875(class_3417.field_14681.method_40237().method_29177(), class_3419.field_15253);
                    return true;
                });
            }
        } else if (!play && SEMPITERNAL_SANCTUM_MUSIC != null) {
            BUMBLEZONE_MUSIC_PLAYING = false;
            MusicHandler.addMusicFade(SEMPITERNAL_SANCTUM_MUSIC, 500, false, m -> false);
        }
    }

    public static void playStopEssenceEventMusic(class_1657 entity, class_2960 resourceLocation, boolean play) {
        class_310 minecraftClient = class_310.method_1551();
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(resourceLocation);
        if (soundEvent == null || !GeneralUtils.isInTag(class_7923.field_41172, BzTags.ESSENCE_EVENT_MUSIC, soundEvent)) {
            return;
        }
        if (play && (ESSENCE_EVENT_MUSIC == null || !MusicHandler.isMusicPlaying(minecraftClient, ESSENCE_EVENT_MUSIC))) {
            if (entity == minecraftClient.field_1724 && !MusicHandler.isMusicPlaying(minecraftClient, ESSENCE_EVENT_MUSIC)) {
                ESSENCE_EVENT_MUSIC = class_1109.method_4759((class_3414)soundEvent);
                BUMBLEZONE_MUSIC_PLAYING = true;
                minecraftClient.method_1483().method_4873(ESSENCE_EVENT_MUSIC);
                MusicHandler.setMusicVolume(minecraftClient, ESSENCE_EVENT_MUSIC, 0.01f);
                MusicHandler.addMusicFade(ESSENCE_EVENT_MUSIC, 300, true, m -> {
                    m.method_1483().method_4875(BIOME_MUSIC, class_3419.field_15253);
                    m.method_1483().method_4875(class_3417.field_14995.method_40237().method_29177(), class_3419.field_15253);
                    m.method_1483().method_4875(class_3417.field_14681.method_40237().method_29177(), class_3419.field_15253);
                    m.method_1483().method_4875(BzSounds.ANGERED_BEES.get().method_14833(), class_3419.field_15253);
                    m.method_1483().method_4875(BzSounds.SEMPITERNAL_SANCTUM.get().method_14833(), class_3419.field_15253);
                    return true;
                });
            }
        } else if (!play && ESSENCE_EVENT_MUSIC != null) {
            BUMBLEZONE_MUSIC_PLAYING = false;
            MusicHandler.addMusicFade(ESSENCE_EVENT_MUSIC, 300, false, m -> false);
        }
    }

    private static void addMusicFade(class_1113 soundInstance, int counterStart, boolean fadeIn, Predicate<class_310> stopOtherMusic) {
        if (MUSIC_FADERS.containsKey(soundInstance.method_4775())) {
            MusicFader musicFader = MUSIC_FADERS.get(soundInstance.method_4775());
            boolean originalFadeIn = musicFader.fadeIn;
            if (originalFadeIn != fadeIn) {
                musicFader.fadeIn = fadeIn;
                musicFader.counter = musicFader.counterStart - musicFader.counter;
            }
        } else {
            MUSIC_FADERS.put(soundInstance.method_4775(), new MusicFader(soundInstance, stopOtherMusic, counterStart, fadeIn));
        }
    }

    private static void setMusicVolume(class_310 minecraftClient, class_1113 soundInstance, float volume) {
        float playerSetVolume = minecraftClient.field_1690.method_1630(soundInstance.method_4774());
        class_4235.class_4236 channelHandle = ((SoundEngineAccessor)((SoundManagerAccessor)minecraftClient.method_1483()).getSoundEngine()).getInstanceToChannel().get(soundInstance);
        if (channelHandle != null) {
            channelHandle.method_19735(channel -> channel.method_19647(Math.min(volume, playerSetVolume)));
        }
    }

    private static boolean isMusicPlaying(class_310 minecraftClient, class_1113 soundInstance) {
        return minecraftClient.method_1483().method_4877(soundInstance);
    }

    public static class MusicFader {
        public final class_1113 music;
        public final Predicate<class_310> stopOtherMusic;
        public final int counterStart;
        public boolean fadeIn;
        public int counter;

        public MusicFader(class_1113 music, Predicate<class_310> stopOtherMusic, int counterStart, boolean fadeIn) {
            this.music = music;
            this.stopOtherMusic = stopOtherMusic;
            this.counterStart = counterStart;
            this.fadeIn = fadeIn;
            this.counter = this.counterStart;
        }
    }
}

