/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseChunkAccessor;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BiomeInfluencedNoiseSampler;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BiomeRegistryHolder;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.NoVerticalBlendBiomeManager;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1315;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3215;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3754;
import net.minecraft.class_4538;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5425;
import net.minecraft.class_5483;
import net.minecraft.class_5539;
import net.minecraft.class_5817;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5868;
import net.minecraft.class_6012;
import net.minecraft.class_6350;
import net.minecraft.class_6544;
import net.minecraft.class_6568;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_6954;
import net.minecraft.class_7138;
import net.minecraft.class_7243;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;

public class BzChunkGenerator
extends class_3754 {
    public static final Codec<BzChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(bzChunkGenerator -> bzChunkGenerator.field_12761), (App)class_5284.field_24781.fieldOf("settings").forGetter(bzChunkGenerator -> bzChunkGenerator.settings)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    protected final class_2680 defaultBlock;
    protected final class_2680 defaultFluid;
    private final class_6880<class_5284> settings;
    private final class_6350.class_6565 globalFluidPicker;

    public BzChunkGenerator(class_1966 biomeSource, class_6880<class_5284> supplier) {
        super(biomeSource, supplier);
        class_5284 noiseGeneratorSettings = (class_5284)supplier.comp_349();
        this.defaultBlock = noiseGeneratorSettings.comp_475();
        this.defaultFluid = noiseGeneratorSettings.comp_476();
        class_6953 noiseRouter = noiseGeneratorSettings.comp_477();
        BiomeNoise.biomeSource = this.method_12098();
        BiomeNoise.sampler = new class_6544.class_6552(noiseRouter.comp_420(), noiseRouter.comp_539(), noiseRouter.comp_484(), noiseRouter.comp_423(), noiseRouter.comp_424(), noiseRouter.comp_485(), noiseGeneratorSettings.comp_538());
        this.settings = supplier;
        int seaLevel = noiseGeneratorSettings.comp_479();
        class_6350.class_6351 sea = new class_6350.class_6351(seaLevel, noiseGeneratorSettings.comp_476());
        this.globalFluidPicker = (x, y, z) -> sea;
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public CompletableFuture<class_2791> method_38275(Executor executor, class_7138 randomState, class_6748 blender, class_5138 structureManager, class_2791 chunkAccess) {
        return CompletableFuture.supplyAsync(class_156.method_37910((String)"init_biomes", () -> {
            this.doCreateBiomes(blender, randomState, structureManager, chunkAccess);
            return chunkAccess;
        }), class_156.method_18349());
    }

    private void doCreateBiomes(class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunkAccess) {
        class_6780 biomeresolver = this.getBiomeResolver((class_6780)this.field_12761);
        class_6568 noisechunk = chunkAccess.method_38255(noiseChunk -> this.createNoiseChunk((class_2791)noiseChunk, structureManager, blender, randomState));
        class_6544.class_6552 sampler = ((NoiseChunkAccessor)noisechunk).callCachedClimateSampler(randomState.method_42370(), ((class_5284)this.settings.comp_349()).comp_538());
        chunkAccess.method_38257(biomeresolver, sampler);
    }

    private class_6780 getBiomeResolver(class_6780 noiseBiome) {
        return (x, y, z, biomeHolder) -> noiseBiome.method_38109(x, 0, z, biomeHolder);
    }

    private class_6568 createNoiseChunk(class_2791 chunkAccess, class_5138 structureManager, class_6748 blender, class_7138 randomState) {
        return class_6568.method_39543((class_2791)chunkAccess, (class_7138)randomState, (class_6916.class_7050)class_5817.method_42695((class_5138)structureManager, (class_1923)chunkAccess.method_12004()), (class_5284)((class_5284)this.settings.comp_349()), (class_6350.class_6565)this.globalFluidPicker, (class_6748)blender);
    }

    public int method_16397(int x, int z, class_2902.class_2903 types, class_5539 levelHeightAccessor, class_7138 randomState) {
        return this.iterateNoiseColumn(levelHeightAccessor, randomState, x, z, null, types.method_16402()).orElse(levelHeightAccessor.method_31607());
    }

    public class_4966 method_26261(int x, int z, class_5539 levelHeightAccessor, class_7138 randomState) {
        MutableObject mutableobject = new MutableObject();
        this.iterateNoiseColumn(levelHeightAccessor, randomState, x, z, (MutableObject<class_4966>)mutableobject, null);
        return (class_4966)mutableobject.getValue();
    }

    public void method_40450(List<String> strings, class_7138 randomState, class_2338 blockPos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        class_6953 noiserouter = randomState.method_42370();
        class_6910.class_6914 densityfunction$singlepointcontext = new class_6910.class_6914(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        double d0 = noiserouter.comp_485().method_40464((class_6910.class_6912)densityfunction$singlepointcontext);
        strings.add("NoiseRouter T: " + decimalformat.format(noiserouter.comp_420().method_40464((class_6910.class_6912)densityfunction$singlepointcontext)) + " V: " + decimalformat.format(noiserouter.comp_539().method_40464((class_6910.class_6912)densityfunction$singlepointcontext)) + " C: " + decimalformat.format(noiserouter.comp_484().method_40464((class_6910.class_6912)densityfunction$singlepointcontext)) + " E: " + decimalformat.format(noiserouter.comp_423().method_40464((class_6910.class_6912)densityfunction$singlepointcontext)) + " D: " + decimalformat.format(noiserouter.comp_424().method_40464((class_6910.class_6912)densityfunction$singlepointcontext)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(class_6954.method_41546((float)((float)d0))) + " AS: " + decimalformat.format(noiserouter.comp_486().method_40464((class_6910.class_6912)densityfunction$singlepointcontext)) + " N: " + decimalformat.format(noiserouter.comp_487().method_40464((class_6910.class_6912)densityfunction$singlepointcontext)));
    }

    protected OptionalInt iterateNoiseColumn(class_5539 levelHeightAccessor, class_7138 randomState, int x, int z, MutableObject<class_4966> mutableObject, Predicate<class_2680> blockStatePredicate) {
        class_5309 noisesettings = ((class_5284)this.settings.comp_349()).comp_474().method_42368(levelHeightAccessor);
        int i = noisesettings.method_39545();
        int j = noisesettings.comp_173();
        int k = class_3532.method_48116((int)j, (int)i);
        int l = class_3532.method_48116((int)noisesettings.comp_174(), (int)i);
        if (l > 0) {
            class_2680[] ablockstate;
            if (mutableObject == null) {
                ablockstate = null;
            } else {
                ablockstate = new class_2680[noisesettings.comp_174()];
                mutableObject.setValue((Object)new class_4966(j, ablockstate));
            }
            int i1 = noisesettings.method_39546();
            int j1 = Math.floorDiv(x, i1);
            int k1 = Math.floorDiv(z, i1);
            int l1 = Math.floorMod(x, i1);
            int i2 = Math.floorMod(z, i1);
            int j2 = j1 * i1;
            int k2 = k1 * i1;
            double d0 = (double)l1 / (double)i1;
            double d1 = (double)i2 / (double)i1;
            class_6568 noiseChunk = new class_6568(1, randomState, j2, k2, noisesettings, (class_6916.class_7050)class_6916.class_7049.field_37076, (class_5284)this.settings.comp_349(), this.globalFluidPicker, class_6748.method_39336());
            noiseChunk.method_38336();
            noiseChunk.method_38339(0);
            for (int l2 = l - 1; l2 >= 0; --l2) {
                noiseChunk.method_38362(l2, 0);
                for (int i3 = i - 1; i3 >= 0; --i3) {
                    class_2680 blockstate1;
                    int j3 = (k + l2) * i + i3;
                    double d2 = (double)i3 / (double)i;
                    noiseChunk.method_38337(j3, d2);
                    noiseChunk.method_38349(x, d0);
                    noiseChunk.method_38355(z, d1);
                    class_2680 blockstate = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                    class_2680 class_26802 = blockstate1 = blockstate == null ? this.defaultBlock : blockstate;
                    if (ablockstate != null) {
                        int k3 = l2 * i + i3;
                        ablockstate[k3] = blockstate1;
                    }
                    if (blockStatePredicate == null || !blockStatePredicate.test(blockstate1)) continue;
                    noiseChunk.method_40537();
                    return OptionalInt.of(j3 + 1);
                }
            }
            noiseChunk.method_40537();
        }
        return OptionalInt.empty();
    }

    public void method_12110(class_3233 worldGenRegion, class_5138 structureManager, class_7138 randomState, class_2791 chunkAccess) {
        class_4543 biomeManager;
        class_5868 worldgenerationcontext = new class_5868((class_2794)this, (class_5539)worldGenRegion);
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof class_4543.class_4544) {
            class_4543.class_4544 noiseBiomeSource = (class_4543.class_4544)class_19662;
            biomeManager = new class_4543(noiseBiomeSource, worldGenRegion.method_8412());
        } else {
            biomeManager = worldGenRegion.method_22385();
        }
        biomeManager = new NoVerticalBlendBiomeManager(biomeManager);
        this.method_41538(chunkAccess, worldgenerationcontext, randomState, structureManager, biomeManager, (class_2378<class_1959>)worldGenRegion.method_30349().method_30530(class_7924.field_41236), class_6748.method_39342((class_3233)worldGenRegion));
    }

    public void method_41538(class_2791 chunkAccess, class_5868 worldGenerationContext, class_7138 randomState, class_5138 structureManager, class_4543 biomeManager, class_2378<class_1959> biomeRegistry, class_6748 blender) {
        class_6568 noisechunk = chunkAccess.method_38255(noiseChunk -> this.createNoiseChunk((class_2791)noiseChunk, structureManager, blender, randomState));
        class_5284 noisegeneratorsettings = (class_5284)this.settings.comp_349();
        randomState.method_42372().method_39106(randomState, biomeManager, biomeRegistry, noisegeneratorsettings.comp_483(), worldGenerationContext, chunkAccess, noisechunk, noisegeneratorsettings.comp_478());
    }

    public void method_12108(class_3233 worldGenRegion, long seed, class_7138 randomState, class_4543 biomeManager, class_5138 structureManager, class_2791 chunkAccess, class_2893.class_2894 carving) {
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunkAccess) {
        class_5309 noisesettings = ((class_5284)this.settings.comp_349()).comp_474().method_42368(chunkAccess.method_39460());
        int i = noisesettings.comp_173();
        int j = class_3532.method_48116((int)i, (int)noisesettings.method_39545());
        int k = class_3532.method_48116((int)noisesettings.comp_174(), (int)noisesettings.method_39545());
        if (k <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int l = chunkAccess.method_31602(k * noisesettings.method_39545() - 1 + i);
        int i1 = chunkAccess.method_31602(i);
        HashSet set = Sets.newHashSet();
        for (int j1 = l; j1 >= i1; --j1) {
            class_2826 levelchunksection = chunkAccess.method_38259(j1);
            levelchunksection.method_16676();
            set.add(levelchunksection);
        }
        return CompletableFuture.supplyAsync(class_156.method_37910((String)"wgen_fill_noise", () -> this.doFill(blender, structureManager, randomState, chunkAccess, j, k)), class_156.method_18349()).whenCompleteAsync((p_224309_, p_224310_) -> {
            for (class_2826 levelchunksection1 : set) {
                levelchunksection1.method_16677();
            }
        }, executor);
    }

    private class_2791 doFill(class_6748 blender, class_5138 structureManager, class_7138 randomState, class_2791 chunkAccess, int x, int z) {
        class_6568 noiseChunk = chunkAccess.method_38255(chunkAccess1 -> this.createNoiseChunk((class_2791)chunkAccess1, structureManager, blender, randomState));
        class_2902 heightmap = chunkAccess.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmap1 = chunkAccess.method_12032(class_2902.class_2903.field_13194);
        class_1923 chunkpos = chunkAccess.method_12004();
        int i = chunkpos.method_8326();
        int j = chunkpos.method_8328();
        class_6350 aquifer = noiseChunk.method_38354();
        noiseChunk.method_38336();
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        int k = ((class_5284)this.settings.comp_349()).comp_474().method_39546();
        int l = ((class_5284)this.settings.comp_349()).comp_474().method_39545();
        int i1 = 16 / k;
        int j1 = 16 / k;
        for (int k1 = 0; k1 < i1; ++k1) {
            noiseChunk.method_38339(k1);
            for (int l1 = 0; l1 < j1; ++l1) {
                int bottomBlockY = chunkAccess.method_32890() - 1;
                class_2826 levelchunksection = chunkAccess.method_38259(chunkAccess.method_32890() - 1);
                for (int i2 = z - 1; i2 >= 0; --i2) {
                    noiseChunk.method_38362(i2, l1);
                    for (int j2 = l - 1; j2 >= 0; --j2) {
                        int k2 = (x + i2) * l + j2;
                        int l2 = k2 & 0xF;
                        int i3 = chunkAccess.method_31602(k2);
                        if (bottomBlockY != i3) {
                            levelchunksection = chunkAccess.method_38259(i3);
                        }
                        double d0 = (double)j2 / (double)l;
                        noiseChunk.method_38337(k2, d0);
                        for (int j3 = 0; j3 < k; ++j3) {
                            int k3 = i + k1 * k + j3;
                            int l3 = k3 & 0xF;
                            double d1 = (double)j3 / (double)k;
                            noiseChunk.method_38349(k3, d1);
                            for (int i4 = 0; i4 < k; ++i4) {
                                int j4 = j + l1 * k + i4;
                                int k4 = j4 & 0xF;
                                double d2 = (double)i4 / (double)k;
                                noiseChunk.method_38355(j4, d2);
                                class_2680 blockstate = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                                if (blockstate == null) {
                                    blockstate = this.defaultBlock;
                                }
                                if (blockstate == class_2246.field_10124.method_9564()) continue;
                                levelchunksection.method_12256(l3, l2, k4, blockstate, false);
                                heightmap.method_12597(l3, k2, k4, blockstate);
                                heightmap1.method_12597(l3, k2, k4, blockstate);
                                if (!aquifer.method_33742() || blockstate.method_26227().method_15769()) continue;
                                blockpos$mutableblockpos.method_10103(k3, k2, j4);
                                chunkAccess.method_12039((class_2338)blockpos$mutableblockpos);
                            }
                        }
                    }
                }
            }
            noiseChunk.method_38348();
        }
        noiseChunk.method_40537();
        return chunkAccess;
    }

    public int method_12104() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_174();
    }

    public int method_16398() {
        return ((class_5284)this.settings.comp_349()).comp_479();
    }

    public int method_33730() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_173();
    }

    public class_6880<class_5284> method_41541() {
        return this.settings;
    }

    public void method_12107(class_3233 region) {
        if (!((class_5284)this.settings.comp_349()).comp_480()) {
            class_1923 chunkpos = region.method_33561();
            class_6880 holder = region.method_23753(chunkpos.method_8323().method_33096(region.method_31600() - 1));
            class_2919 worldgenrandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
            worldgenrandom.method_12661(region.method_8412(), chunkpos.method_8326(), chunkpos.method_8328());
            BzChunkGenerator.spawnNonBeeMobsForChunkGeneration((class_5425)region, (class_6880<class_1959>)holder, chunkpos, (class_5819)worldgenrandom);
        }
    }

    public static void spawnNonBeeMobsForChunkGeneration(class_5425 serverLevelAccessor, class_6880<class_1959> biomeHolder, class_1923 chunkPos, class_5819 randomSource) {
        class_5483 mobspawnsettings = ((class_1959)biomeHolder.comp_349()).method_30966();
        class_6012 weightedrandomlist = mobspawnsettings.method_31004(class_1311.field_6294);
        if (!(weightedrandomlist = class_6012.method_34988(weightedrandomlist.method_34994().stream().filter(e -> e.field_9389 != class_1299.field_20346).toList())).method_34993()) {
            int i = chunkPos.method_8326();
            int j = chunkPos.method_8328();
            int seaLevel = ((class_3215)serverLevelAccessor.method_8398()).method_12129().method_16398();
            while ((double)randomSource.method_43057() < (double)mobspawnsettings.method_31002() * 0.5) {
                Optional optional = weightedrandomlist.method_34992(randomSource);
                if (!optional.isPresent()) continue;
                class_5483.class_1964 mobspawnsettings$spawnerdata = (class_5483.class_1964)optional.get();
                int k = mobspawnsettings$spawnerdata.field_9388 + randomSource.method_43048(1 + mobspawnsettings$spawnerdata.field_9387 - mobspawnsettings$spawnerdata.field_9388);
                class_1315 spawngroupdata = null;
                int x = i + randomSource.method_43048(16);
                int z = j + randomSource.method_43048(16);
                int j1 = x;
                int k1 = z;
                for (int l1 = 0; l1 < k; ++l1) {
                    class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, randomSource.method_43048(250 - seaLevel) + seaLevel, z);
                    if (serverLevelAccessor.method_8597().comp_643()) {
                        do {
                            mutableBlockPos.method_10098(class_2350.field_11033);
                        } while (!serverLevelAccessor.method_8320((class_2338)mutableBlockPos).method_26215());
                        do {
                            mutableBlockPos.method_10098(class_2350.field_11033);
                        } while (serverLevelAccessor.method_8320((class_2338)mutableBlockPos).method_26215() && mutableBlockPos.method_10264() > serverLevelAccessor.method_31607());
                    }
                    if (mobspawnsettings$spawnerdata.field_9389.method_5896()) {
                        float mobWidth = mobspawnsettings$spawnerdata.field_9389.method_17685();
                        double finalX = class_3532.method_15350((double)x, (double)((double)i + (double)mobWidth), (double)((double)i + 16.0 - (double)mobWidth));
                        double finalZ = class_3532.method_15350((double)z, (double)((double)j + (double)mobWidth), (double)((double)j + 16.0 - (double)mobWidth));
                        if (!serverLevelAccessor.method_8621().method_35317(finalX, finalZ) || mutableBlockPos.method_10264() < serverLevelAccessor.method_31607() || mutableBlockPos.method_10264() >= serverLevelAccessor.method_31600()) continue;
                        class_1297 entity = null;
                        try {
                            entity = mobspawnsettings$spawnerdata.field_9389.method_5883((class_1937)serverLevelAccessor.method_8410());
                            entity.method_5808(finalX, (double)mutableBlockPos.method_10264(), finalZ, randomSource.method_43057() * 360.0f, 0.0f);
                            if (entity instanceof class_1308) {
                                class_1308 mob = (class_1308)entity;
                                PlatformHooks.finalizeSpawn(mob, serverLevelAccessor, null, class_3730.field_16472, null);
                                if (mob.method_5957((class_4538)serverLevelAccessor)) {
                                    spawngroupdata = mob.method_5943(serverLevelAccessor, serverLevelAccessor.method_8404(mob.method_24515()), class_3730.field_16472, spawngroupdata, null);
                                    mob.method_24203(mob.method_23317(), mob.method_23318() + 1.0, mob.method_23321());
                                    serverLevelAccessor.method_30771((class_1297)mob);
                                }
                            }
                        }
                        catch (Exception exception) {
                            Bumblezone.LOGGER.error("Failed to create mob: {}", (Object)entity);
                            exception.addSuppressed(new RuntimeException("Failed to create mob: " + entity));
                            throw exception;
                        }
                    }
                    x += randomSource.method_43048(5) - randomSource.method_43048(5);
                    z += randomSource.method_43048(5) - randomSource.method_43048(5);
                    while (x < i || x >= i + 16 || z < j || z >= j + 16) {
                        x = j1 + randomSource.method_43048(5) - randomSource.method_43048(5);
                        z = k1 + randomSource.method_43048(5) - randomSource.method_43048(5);
                    }
                }
            }
        }
    }

    public record BiomeNoise() implements class_6910.class_6913
    {
        public static final class_7243<BiomeNoise> CODEC = class_7243.method_42116((MapCodec)MapCodec.unit((Object)new BiomeNoise()));
        public static class_6544.class_6552 sampler;
        public static class_1966 biomeSource;

        public double method_40464(class_6910.class_6912 functionContext) {
            return BiomeInfluencedNoiseSampler.calculateBaseNoise(functionContext.comp_371(), functionContext.comp_373(), sampler, biomeSource, BiomeRegistryHolder.BIOME_REGISTRY);
        }

        public double comp_377() {
            return -10.0;
        }

        public double comp_378() {
            return 10.0;
        }

        public class_7243<? extends class_6910> method_41062() {
            return CODEC;
        }
    }
}

