/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2496;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class SpawnerRandomizingProcessor
extends class_3491 {
    public static final Codec<SpawnerRandomizingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)class_7923.field_41177.method_39673().fieldOf("resourcelocation"), (MapCodec)class_5699.field_33442.fieldOf("weight")).codec().listOf().fieldOf("spawner_mob_entries").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.mainSpawnerData), (App)class_6895.method_40341((class_5321)class_7924.field_41266, (Codec)class_7923.field_41177.method_39673()).optionalFieldOf("override_mobs_to_pick_from").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.overrideMobsToPickFrom), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_to_override_with_tagged_mobs").orElse((Object)Float.valueOf(0.0f)).forGetter(spawnerRandomizingProcessor -> Float.valueOf(spawnerRandomizingProcessor.chanceToOverrideWithTaggedMobs))).apply((Applicative)instance, instance.stable(SpawnerRandomizingProcessor::new)));
    public final List<Pair<class_1299<?>, Integer>> mainSpawnerData;
    public final Optional<class_6885<class_1299<?>>> overrideMobsToPickFrom;
    public final float chanceToOverrideWithTaggedMobs;

    private SpawnerRandomizingProcessor(List<Pair<class_1299<?>, Integer>> mainSpawnerData, Optional<class_6885<class_1299<?>>> overrideMobsToPickFrom, float chanceToOverrideWithTaggedMobs) {
        this.mainSpawnerData = mainSpawnerData;
        this.overrideMobsToPickFrom = overrideMobsToPickFrom;
        this.chanceToOverrideWithTaggedMobs = chanceToOverrideWithTaggedMobs;
    }

    public class_3499.class_3501 method_15110(class_4538 worldView, class_2338 pos, class_2338 blockPos, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 structurePlacementData) {
        if (structureBlockInfoWorld.comp_1342().method_26204() instanceof class_2496) {
            class_2487 newSpawnerData;
            class_2338 worldPos = structureBlockInfoWorld.comp_1341();
            class_5819 randomSource = structurePlacementData.method_15115(worldPos);
            if (this.overrideMobsToPickFrom.isPresent() && this.overrideMobsToPickFrom.get().method_40247() > 0 && randomSource.method_43057() < this.chanceToOverrideWithTaggedMobs) {
                newSpawnerData = this.SetMobSpawnerEntity((class_1299)this.overrideMobsToPickFrom.get().method_40240(randomSource.method_43048(this.overrideMobsToPickFrom.get().method_40247())).comp_349(), structureBlockInfoWorld.comp_1343());
            } else if (this.mainSpawnerData.size() > 0) {
                newSpawnerData = this.SetMobSpawnerEntity((class_1299)GeneralUtils.getRandomEntry(this.mainSpawnerData, randomSource), structureBlockInfoWorld.comp_1343());
            } else {
                return structureBlockInfoWorld;
            }
            return new class_3499.class_3501(worldPos, structureBlockInfoWorld.comp_1342(), newSpawnerData);
        }
        return structureBlockInfoWorld;
    }

    private class_2487 SetMobSpawnerEntity(class_1299<?> entity, class_2487 nbt) {
        if (entity != null) {
            if (nbt != null) {
                class_2487 entityTag;
                class_2487 spawnDataTag = nbt.method_10562("SpawnData");
                if (spawnDataTag.method_33133()) {
                    spawnDataTag = new class_2487();
                    nbt.method_10566("SpawnData", (class_2520)spawnDataTag);
                }
                if ((entityTag = nbt.method_10562("entity")).method_33133()) {
                    entityTag = new class_2487();
                    spawnDataTag.method_10566("entity", (class_2520)entityTag);
                }
                entityTag.method_10582("id", class_7923.field_41177.method_10221(entity).toString());
                class_2487 spawnEntityDataTag = new class_2487();
                spawnEntityDataTag.method_10582("id", class_7923.field_41177.method_10221(entity).toString());
                class_2487 spawnPotentialDataEntryTag = new class_2487();
                spawnPotentialDataEntryTag.method_10566("entity", (class_2520)spawnEntityDataTag);
                class_2487 spawnPotentialEntryTag = new class_2487();
                spawnPotentialEntryTag.method_10566("data", (class_2520)spawnPotentialDataEntryTag);
                spawnPotentialEntryTag.method_10566("weight", (class_2520)class_2497.method_23247((int)1));
                nbt.method_10566("SpawnPotentials", (class_2520)new class_2499());
                return nbt;
            }
            class_2487 compound = new class_2487();
            compound.method_10575("Delay", (short)20);
            compound.method_10575("MinSpawnDelay", (short)200);
            compound.method_10575("MaxSpawnDelay", (short)800);
            compound.method_10575("SpawnCount", (short)4);
            compound.method_10575("MaxNearbyEntities", (short)6);
            compound.method_10575("RequiredPlayerRange", (short)16);
            compound.method_10575("SpawnRange", (short)4);
            class_2487 spawnDataEntity = new class_2487();
            spawnDataEntity.method_10582("id", class_7923.field_41177.method_10221(entity).toString());
            class_2487 spawnData = new class_2487();
            spawnData.method_10566("entity", (class_2520)spawnDataEntity);
            compound.method_10566("SpawnData", (class_2520)spawnData);
            class_2487 entityData = new class_2487();
            entityData.method_10582("id", class_7923.field_41177.method_10221(entity).toString());
            class_2487 spawnPotentialData = new class_2487();
            spawnPotentialData.method_10566("entity", (class_2520)entityData);
            class_2487 listEntry = new class_2487();
            listEntry.method_10566("data", (class_2520)spawnPotentialData);
            listEntry.method_10569("weight", 1);
            compound.method_10566("SpawnPotentials", (class_2520)new class_2499());
            return compound;
        }
        return nbt;
    }

    protected class_3828<?> method_16772() {
        return BzProcessors.SPAWNER_RANDOMIZING_PROCESSOR.get();
    }
}

