/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item.hatchet;

import net.dakotapride.garnished.registry.GarnishedEnchantments;
import net.dakotapride.garnished.registry.GarnishedItems;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Unique;

public class HatchetUtils {
    static class_1887 salvaging = (class_1887)GarnishedEnchantments.SALVAGING.get();
    static class_1887 ravaging = (class_1887)GarnishedEnchantments.RAVAGING.get();
    public static final class_5819 random = class_5819.method_43047();

    public static void getDrops(class_1309 entity, class_1309 attacker) {
        int additionalDropChance;
        int singleCount = 1;
        int count = singleCount + random.method_43048(2);
        String mob = "Unavailable";
        String enchant = "Unavailable";
        if (HatchetUtils.hasSalvaging(attacker)) {
            enchant = "Salvaging";
            if (MobHelper.isFish((class_1297)entity)) {
                mob = "Fish";
                int fishBoneDropChance = 0;
                int additionalDropChance2 = 0;
                if (HatchetUtils.isCorrectEnchantmentLevel(salvaging, attacker, 1)) {
                    fishBoneDropChance = random.method_43048(6);
                    additionalDropChance2 = random.method_43048(20);
                } else if (HatchetUtils.isCorrectEnchantmentLevel(salvaging, attacker, 2)) {
                    fishBoneDropChance = random.method_43048(3);
                    additionalDropChance2 = random.method_43048(8);
                }
                if (fishBoneDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)class_1802.field_8606, count));
                } else if (additionalDropChance2 == 1 && HatchetUtils.isCorrectEnchantmentLevel(salvaging, attacker, 2)) {
                    int fishCount = singleCount + random.method_43048(2);
                    int tropicalFishCount = singleCount + random.method_43048(3);
                    if (MobHelper.isSalmon((class_1297)entity)) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_8209, fishCount));
                    } else if (MobHelper.isCod((class_1297)entity)) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_8429, fishCount));
                    } else if (MobHelper.isPufferfish((class_1297)entity)) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_8323, singleCount));
                    } else if (MobHelper.isTropicalFish((class_1297)entity)) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_8846, tropicalFishCount));
                    }
                }
            }
            if (MobHelper.isSquidOrSimilar((class_1297)entity)) {
                mob = "SquidOrSimilar";
                additionalDropChance = 0;
                int lichenDropChance = 0;
                if (HatchetUtils.isCorrectEnchantmentLevel(salvaging, attacker, 1)) {
                    additionalDropChance = random.method_43048(6);
                    lichenDropChance = random.method_43048(8);
                } else if (HatchetUtils.isCorrectEnchantmentLevel(salvaging, attacker, 2)) {
                    additionalDropChance = random.method_43048(4);
                    lichenDropChance = random.method_43048(6);
                }
                if (additionalDropChance == 1) {
                    int sacCount = singleCount + random.method_43048(3);
                    if (MobHelper.isSquid((class_1297)entity)) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_8794, sacCount));
                    } else if (MobHelper.isGlowSquid((class_1297)entity)) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_28410, sacCount));
                    }
                } else if (lichenDropChance == 1 && MobHelper.isGlowSquid((class_1297)entity)) {
                    int lichenDropCount = singleCount + random.method_43048(2);
                    entity.method_5775(new class_1799((class_1935)class_1802.field_28409, lichenDropCount));
                }
            }
            if (MobHelper.isFrog((class_1297)entity)) {
                mob = "Frog";
                int magmaCreamDropChance = random.method_43048(28);
                int moltenRemnantDropChance = 0;
                if (HatchetUtils.isCorrectEnchantmentLevel(salvaging, attacker, 1)) {
                    moltenRemnantDropChance = random.method_43048(60);
                } else if (HatchetUtils.isCorrectEnchantmentLevel(salvaging, attacker, 2)) {
                    moltenRemnantDropChance = random.method_43048(40);
                }
                if (magmaCreamDropChance == 1) {
                    int magmaCreamCount = singleCount + random.method_43048(2);
                    entity.method_5775(new class_1799((class_1935)class_1802.field_8135, magmaCreamCount));
                }
                if (moltenRemnantDropChance == 1) {
                    int moltenRemnantCount = singleCount + random.method_43048(1);
                    entity.method_5775(new class_1799((class_1935)GarnishedItems.MOLTEN_REMNANT.get(), moltenRemnantCount));
                }
            }
        }
        if (HatchetUtils.hasRavaging(attacker)) {
            int additionalDropCount;
            enchant = "Ravaging";
            if (MobHelper.isMagmaCube((class_1297)entity)) {
                mob = "MagmaCube";
                additionalDropChance = random.method_43048(8);
                additionalDropCount = singleCount + random.method_43048(3);
                int moltenRemnantDropChance = random.method_43048(12);
                int moltenRemnantDropCount = singleCount + random.method_43048(2);
                int froglightDropChance = random.method_43048(16);
                int froglightVariant = random.method_43048(3);
                if (additionalDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)class_1802.field_8135, additionalDropCount));
                } else if (moltenRemnantDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)GarnishedItems.MOLTEN_REMNANT.get(), moltenRemnantDropCount));
                }
                if (froglightDropChance == 1) {
                    if (froglightVariant == 0) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_37539, singleCount));
                    } else if (froglightVariant == 1) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_37540, singleCount));
                    } else if (froglightVariant == 2) {
                        entity.method_5775(new class_1799((class_1935)class_1802.field_37541, singleCount));
                    }
                }
            }
            if (MobHelper.isBlaze((class_1297)entity)) {
                mob = "Blaze";
                additionalDropChance = random.method_43048(6);
                additionalDropCount = singleCount + random.method_43048(3);
                int powderDropChance = random.method_43048(10);
                int powderDropCount = singleCount + random.method_43048(2);
                int mandibleDropChance = random.method_43048(16);
                if (additionalDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)class_1802.field_8894, additionalDropCount));
                } else if (powderDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)class_1802.field_8183, powderDropCount));
                }
                if (mandibleDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)GarnishedItems.ENFLAMED_MANDIBLE.get(), singleCount));
                }
            }
            if (MobHelper.isGhast((class_1297)entity)) {
                mob = "Ghast";
                additionalDropChance = random.method_43048(8);
                additionalDropCount = singleCount + random.method_43048(3);
                int ghastTearDropChance = random.method_43048(12);
                int ghastTearDropCount = singleCount + random.method_43048(2);
                int ghastTendrilDropChance = random.method_43048(8);
                int ghastTendrilDropCount = singleCount + random.method_43048(2);
                if (additionalDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)class_1802.field_8054, additionalDropCount));
                } else if (ghastTearDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)class_1802.field_8070, ghastTearDropCount));
                }
                if (ghastTendrilDropChance == 1) {
                    entity.method_5775(new class_1799((class_1935)GarnishedItems.GHAST_TENDRIL.get(), ghastTendrilDropCount));
                }
            }
            if (MobHelper.isWarden((class_1297)entity)) {
                mob = "Warden";
                int rawTenebrousMeatDropCount = singleCount + random.method_43048(6);
                entity.method_5775(new class_1799((class_1935)GarnishedItems.RAW_TENEBROUS_MEAT.get(), rawTenebrousMeatDropCount));
            }
        }
        DevAssistance.printLootTableToConsole(enchant, mob);
    }

    public static boolean isAffectedByRavaging(class_1297 entity) {
        return entity.method_5864().method_20210(GarnishedTags.IS_AFFECTED_BY_RAVAGING);
    }

    public static boolean isAffectedBySalvaging(class_1297 entity) {
        return entity.method_5864().method_20210(GarnishedTags.IS_AFFECTED_BY_SALVAGING);
    }

    public static boolean hasRavaging(class_1309 entity) {
        return HatchetUtils.hasEnchantment(ravaging, entity);
    }

    public static boolean hasSalvaging(class_1309 entity) {
        return HatchetUtils.hasEnchantment(salvaging, entity);
    }

    public static boolean canApplyRavagingEffects(class_1309 entity) {
        return entity.method_6047().method_31573(GarnishedTags.HATCHETS_TAG) && HatchetUtils.hasEnchantment(ravaging, entity) && entity.method_6032() <= 10.0f;
    }

    @Unique
    private static boolean hasEnchantment(class_1887 enchantment, class_1309 entity) {
        return class_1890.method_8203((class_1887)enchantment, (class_1309)entity) > 0;
    }

    @Unique
    private static boolean isCorrectEnchantmentLevel(class_1887 enchantment, class_1309 entity, int level) {
        return class_1890.method_8203((class_1887)enchantment, (class_1309)entity) == level;
    }

    public static class MobHelper {
        public static boolean isWarden(class_1297 entity) {
            return entity.method_5864() == class_1299.field_38095;
        }

        public static boolean isPhantom(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6078;
        }

        public static boolean isWitherBoss(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6119;
        }

        public static boolean isWitherSkeleton(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6076;
        }

        public static boolean isSkeletonHorse(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6075;
        }

        public static boolean isSkeleton(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6137;
        }

        public static boolean isSkeletonOrSimilar(class_1297 entity) {
            return MobHelper.isWitherBoss(entity) || MobHelper.isWitherSkeleton(entity) || MobHelper.isSkeleton(entity) || MobHelper.isSkeletonHorse(entity) || MobHelper.isPhantom(entity);
        }

        public static boolean isHusk(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6071;
        }

        public static boolean isZombie(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6051;
        }

        public static boolean isZombieHorse(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6048;
        }

        public static boolean isZombieOrSimilar(class_1297 entity) {
            return MobHelper.isZombie(entity) || MobHelper.isHusk(entity) || MobHelper.isZombieHorse(entity);
        }

        public static boolean isUndead(class_1297 entity) {
            return MobHelper.isZombieOrSimilar(entity) || MobHelper.isSkeletonOrSimilar(entity);
        }

        public static boolean isGhast(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6107;
        }

        public static boolean isMagmaCube(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6102;
        }

        public static boolean isBlaze(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6099;
        }

        public static boolean isSalmon(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6073;
        }

        public static boolean isCod(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6070;
        }

        public static boolean isPufferfish(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6062;
        }

        public static boolean isTropicalFish(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6111;
        }

        public static boolean isFish(class_1297 entity) {
            return MobHelper.isSalmon(entity) || MobHelper.isCod(entity) || MobHelper.isPufferfish(entity) || MobHelper.isTropicalFish(entity);
        }

        public static boolean isSquid(class_1297 entity) {
            return entity.method_5864() == class_1299.field_6114;
        }

        public static boolean isGlowSquid(class_1297 entity) {
            return entity.method_5864() == class_1299.field_28402;
        }

        public static boolean isSquidOrSimilar(class_1297 entity) {
            return MobHelper.isSquid(entity) || MobHelper.isGlowSquid(entity);
        }

        public static boolean isFrog(class_1297 entity) {
            return entity.method_5864() == class_1299.field_37419;
        }

        public static boolean isTadpole(class_1297 entity) {
            return entity.method_5864() == class_1299.field_37420;
        }

        public static boolean isFrogOrSimilar(class_1297 entity) {
            return MobHelper.isFrog(entity) || MobHelper.isTadpole(entity);
        }

        public static boolean isAllay(class_1297 entity) {
            return entity.method_5864() == class_1299.field_38384;
        }
    }

    public static class DevAssistance {
        public static void printLootTableToConsole(String enchant, String mob) {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                System.out.println("[Create: Garnished] " + enchant + " Loot Tables Loaded (MobHelper.is" + mob + "(entity))");
            }
        }
    }
}

