/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.lib.util.NBT;

public class Builder {
    private final ReactorTile reactor;
    private List<class_2338> queue = new ArrayList<class_2338>();
    public boolean built;
    private int delay = 5;

    public Builder(ReactorTile reactor) {
        this.reactor = reactor;
    }

    public void read(class_2487 nbt) {
        this.built = nbt.method_10577("built");
        if (!this.built) {
            this.queue = NBT.readPosList(nbt, "queue_pos", new ArrayList());
        }
    }

    public void write(class_2487 nbt) {
        nbt.method_10556("built", this.built);
        if (!this.built) {
            NBT.writePosList(nbt, this.queue, "queue_pos");
        }
    }

    public boolean isDone(class_1937 world) {
        if (this.built) {
            return true;
        }
        if (!this.queue.isEmpty()) {
            if (this.delay-- <= 0) {
                Iterator<class_2338> itr = this.queue.iterator();
                while (itr.hasNext()) {
                    class_2338 pos = itr.next();
                    class_2680 state = ((ReactorBlock)this.reactor.getBlock()).method_9564();
                    if (!world.method_8320(pos).method_45474()) {
                        this.demolish(world);
                        return false;
                    }
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)ReactorBlock.CORE, (Comparable)Boolean.valueOf(false)), 3);
                    class_2586 tileEntity = world.method_8321(pos);
                    if (!(tileEntity instanceof ReactorPartTile)) continue;
                    ReactorPartTile part = (ReactorPartTile)tileEntity;
                    part.setCorePos(this.reactor.method_11016());
                    world.method_20290(2001, pos, class_2248.method_9507((class_2680)this.reactor.method_11010()));
                    itr.remove();
                    this.delay = 5;
                    return false;
                }
            }
        } else {
            for (class_2350 side : class_2350.values()) {
                if (side.equals((Object)class_2350.field_11033)) continue;
                class_2338 pos = this.reactor.method_11016().method_10093(side).method_10086(side.equals((Object)class_2350.field_11036) ? 2 : 0);
                class_2586 tileEntity = world.method_8321(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setExtractor(true);
                world.method_8452(pos, part.getBlock());
            }
            for (class_2338 pos : this.getPosList()) {
                class_2586 tileEntity = world.method_8321(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setBuilt(true);
                part.sync();
            }
            this.built = true;
            this.reactor.sync();
        }
        return false;
    }

    public void shuffle() {
        this.queue.addAll(this.getPosList());
        Collections.shuffle(this.queue);
    }

    public void demolish(class_1937 world) {
        List<class_2338> list = this.getPosList();
        list.add(this.reactor.method_11016());
        list.removeAll(this.queue);
        int count = 0;
        for (class_2338 blockPos : list) {
            if (!world.method_8320(blockPos).method_26204().equals(this.reactor.getBlock())) continue;
            ++count;
            world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
        }
        class_2248.method_9577((class_1937)world, (class_2338)this.reactor.method_11016(), (class_1799)new class_1799(this.reactor.getBlock(), count + this.queue.size()));
        world.method_8652(this.reactor.method_11016(), class_2246.field_10124.method_9564(), 3);
        this.queue.clear();
    }

    public List<class_2338> getPosList() {
        class_2338 pos = this.reactor.method_11016();
        return class_2338.method_20437((class_2338)pos.method_10069(-1, 0, -1), (class_2338)pos.method_10069(1, 3, 1)).map(class_2338::method_10062).filter(pos1 -> !pos1.equals((Object)pos)).collect(Collectors.toList());
    }
}

