/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import owmii.powah.Powah;
import owmii.powah.network.IPacket;
import owmii.powah.network.packet.NextEnergyConfigPacket;
import owmii.powah.network.packet.NextRedstoneModePacket;
import owmii.powah.network.packet.SetChannelPacket;
import owmii.powah.network.packet.SwitchGenModePacket;

public final class Network {
    private static final class_2960 PACKET_ID = Powah.id("packet");
    private static int nextId = 0;
    private static final List<Constructor<? extends IPacket>> decoders = new ArrayList<Constructor<? extends IPacket>>();
    private static final IdentityHashMap<Class<?>, Integer> packetIds = new IdentityHashMap();

    public static <T extends IPacket> void register(Class<T> packetClass) {
        Constructor<T> ctor = null;
        try {
            ctor = packetClass.getConstructor(class_2540.class);
            decoders.add(ctor);
            packetIds.put(packetClass, nextId);
            ++nextId;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to register packet", e);
        }
    }

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)PACKET_ID, (buf, ctx) -> {
            int packetId = buf.method_10816();
            try {
                IPacket packet = decoders.get(packetId).newInstance(buf);
                ctx.queue(() -> packet.handle(ctx.getPlayer()));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to construct packet of type " + packetId, e);
            }
        });
        Network.register(NextEnergyConfigPacket.class);
        Network.register(NextRedstoneModePacket.class);
        Network.register(SetChannelPacket.class);
        Network.register(SwitchGenModePacket.class);
    }

    private static class_2540 encodePacket(IPacket packet) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(packetIds.get(packet.getClass()).intValue());
        packet.encode(buf);
        return buf;
    }

    public static void toServer(IPacket msg) {
        NetworkManager.sendToServer((class_2960)PACKET_ID, (class_2540)Network.encodePacket(msg));
    }

    public static void toClient(IPacket msg, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)PACKET_ID, (class_2540)Network.encodePacket(msg));
        }
    }
}

